/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.event;

import com.github.tartaricacid.touhoulittlemaid.api.event.MaidEquipEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidTickEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.api.ISpellBookProvider;
import com.github.yimeng261.maidspell.spell.data.MaidSlashBladeData;
import com.github.yimeng261.maidspell.spell.manager.BaubleStateManager;
import com.github.yimeng261.maidspell.spell.manager.SpellBookManager;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import mods.flammpfeil.slashblade.capability.inputstate.CapabilityInputState;
import mods.flammpfeil.slashblade.capability.inputstate.InputStateCapabilityProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="touhou_little_maid_spell")
public class MaidSpellEventHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final UUID MAID_STEP_HEIGHT_UUID = UUID.fromString("8e2c4a16-7f9d-4b45-a3e2-1c8f5d9a6b47");

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            if (!event.getLevel().m_5776_()) {
                SpellBookManager manager = SpellBookManager.getOrCreateManager(maid);
                manager.setMaid(maid);
                manager.updateSpellBooks();
                LivingEntity owner = maid.m_269323_();
                if (owner != null) {
                    Global.maidInfos.computeIfAbsent(owner.m_20148_(), k -> new HashMap()).put(maid.m_20148_(), maid);
                }
                MaidSpellEventHandler.addStepHeightToMaid(maid);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            if (!event.getLevel().m_5776_()) {
                SpellBookManager manager = SpellBookManager.getOrCreateManager(maid);
                manager.stopAllCasting();
                LivingEntity owner = maid.m_269323_();
                if (owner != null) {
                    Global.maidInfos.computeIfAbsent(owner.m_20148_(), k -> new HashMap()).remove(maid.m_20148_());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onMaidEquip(MaidEquipEvent event) {
        EntityMaid maid = event.getMaid();
        EquipmentSlot slot = event.getSlot();
        if (!(maid.m_9236_().m_5776_() || slot != EquipmentSlot.MAINHAND && slot != EquipmentSlot.OFFHAND)) {
            try {
                SpellBookManager manager = SpellBookManager.getOrCreateManager(maid);
                if (manager != null) {
                    manager.updateSpellBooks();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error handling maid equip event for maid {}: {}", new Object[]{maid.m_7755_().getString(), e.getMessage(), e});
            }
        }
    }

    @SubscribeEvent
    public static void onMaidTick(MaidTickEvent event) {
        EntityMaid maid = event.getMaid();
        if (!maid.m_9236_().m_5776_()) {
            try {
                SpellBookManager manager = SpellBookManager.getOrCreateManager(maid);
                if (manager != null) {
                    manager.tick();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error in maid tick handler for maid {}: {}", new Object[]{maid.m_7755_().getString(), e.getMessage(), e});
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        EntityMaid maid;
        LivingEntity entity = event.getEntity();
        Entity direct = event.getSource().m_7640_();
        Entity source = event.getSource().m_7639_();
        if (source instanceof EntityMaid) {
            maid = (EntityMaid)source;
            MaidSpellEventHandler.processor_pre(event, maid);
        } else if (direct instanceof EntityMaid) {
            EntityMaid maid2 = (EntityMaid)direct;
            MaidSpellEventHandler.processor_pre(event, maid2);
        }
        if (entity instanceof EntityMaid) {
            maid = (EntityMaid)entity;
            Global.common_hurtProcessors.forEach((Consumer<BiFunction<LivingHurtEvent, EntityMaid, Void>>)((Consumer<BiFunction>)function -> function.apply(event, maid)));
            BaubleStateManager.getBaubles(maid).forEach(bauble -> {
                BiFunction<LivingHurtEvent, EntityMaid, Void> func = Global.bauble_hurtProcessors_pre.getOrDefault(bauble.m_41778_(), (livingHurtEvent, entityMaid) -> null);
                func.apply(event, maid);
            });
        }
    }

    @SubscribeEvent
    public static void onEntityDamage(LivingDamageEvent event) {
        EntityMaid maid;
        LivingEntity entity = event.getEntity();
        Entity direct = event.getSource().m_7640_();
        Entity source = event.getSource().m_7639_();
        if (source instanceof EntityMaid) {
            maid = (EntityMaid)source;
            MaidSpellEventHandler.processor_aft(event, maid);
        } else if (direct instanceof EntityMaid) {
            EntityMaid maid2 = (EntityMaid)direct;
            MaidSpellEventHandler.processor_aft(event, maid2);
        }
        if (entity instanceof EntityMaid) {
            maid = (EntityMaid)entity;
            BaubleStateManager.getBaubles(maid).forEach(bauble -> {
                BiFunction<LivingDamageEvent, EntityMaid, Void> func = Global.bauble_hurtProcessors_aft.getOrDefault(bauble.m_41778_(), (livingHurtEvent, entityMaid) -> null);
                func.apply(event, maid);
            });
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            Global.player_hurtProcessors_aft.forEach((Consumer<BiFunction<LivingDamageEvent, Player, Void>>)((Consumer<BiFunction>)func -> func.apply(event, player)));
        }
    }

    @SubscribeEvent
    public static void onMaidEffectAdded(MobEffectEvent.Added event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)livingEntity;
            BaubleStateManager.getBaubles(maid).forEach(bauble -> {
                BiFunction<MobEffectEvent.Added, EntityMaid, Void> func = Global.bauble_effectAddedProcessors.getOrDefault(bauble.m_41778_(), (mobEffectEvent, entityMaid) -> null);
                func.apply(event, maid);
            });
        }
    }

    private static void processor_aft(LivingDamageEvent event, EntityMaid maid) {
        BaubleStateManager.getBaubles(maid).forEach(bauble -> {
            BiFunction<LivingDamageEvent, EntityMaid, Void> func = Global.bauble_damageProcessors_aft.getOrDefault(bauble.m_41778_(), (livingHurtEvent, entityMaid) -> null);
            func.apply(event, maid);
        });
    }

    private static void processor_pre(LivingHurtEvent event, EntityMaid maid) {
        Global.common_damageProcessors.forEach((Consumer<BiFunction<LivingHurtEvent, EntityMaid, Void>>)((Consumer<BiFunction>)function -> function.apply(event, maid)));
        BaubleStateManager.getBaubles(maid).forEach(bauble -> {
            BiFunction<LivingHurtEvent, EntityMaid, Void> func = Global.bauble_damageProcessors_pre.getOrDefault(bauble.m_41778_(), (livingHurtEvent, entityMaid) -> null);
            func.apply(event, maid);
        });
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (((Entity)event.getObject()).m_9236_().m_5776_()) {
            return;
        }
        if (event.getObject() instanceof EntityMaid) {
            if (!ModList.get().isLoaded("slashblade")) {
                return;
            }
            Entity entity = (Entity)event.getObject();
            ResourceLocation maidInputStateKey = new ResourceLocation("touhou_little_maid_spell", "maid_inputstate");
            try {
                if (!entity.getCapability(CapabilityInputState.INPUT_STATE).isPresent()) {
                    event.addCapability(maidInputStateKey, (ICapabilityProvider)new InputStateCapabilityProvider());
                    LOGGER.debug("Added INPUT_STATE capability to maid entity");
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to add INPUT_STATE capability to maid: {}", (Object)e.getMessage());
            }
        }
    }

    @SubscribeEvent
    public static void onMaidDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)livingEntity;
            MaidSpellEventHandler.cleanupMaidSpellData(maid);
        }
    }

    private static void cleanupMaidSpellData(EntityMaid maid) {
        try {
            SpellBookManager manager = SpellBookManager.getOrCreateManager(maid);
            if (manager != null) {
                for (ISpellBookProvider provider : manager.getProviders()) {
                    if (!provider.isCasting(maid)) continue;
                    provider.stopCasting(maid);
                }
            }
            MaidSlashBladeData.remove(maid.m_20148_());
            SpellBookManager.removeManager(maid);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addStepHeightToMaid(EntityMaid maid) {
        try {
            AttributeInstance stepHeightAttribute = maid.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
            if (stepHeightAttribute == null) {
                LOGGER.warn("Maid {} does not have step height attribute", (Object)maid.m_7755_().getString());
                return;
            }
            if (stepHeightAttribute.m_22111_(MAID_STEP_HEIGHT_UUID) == null) {
                AttributeModifier stepHeightModifier = new AttributeModifier(MAID_STEP_HEIGHT_UUID, "Maid Step Height Addition", 1.0, AttributeModifier.Operation.ADDITION);
                stepHeightAttribute.m_22125_(stepHeightModifier);
                LOGGER.debug("Added step height attribute to maid: {}", (Object)maid.m_7755_().getString());
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to add step height attribute to maid {}: {}", (Object)maid.m_7755_().getString(), (Object)e.getMessage());
        }
    }
}

