/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.task.DefaultMaidTaskConfigContainer;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public interface IMaidTask {
    public static final int VERTICAL_SEARCH_RANGE = 4;

    public ResourceLocation getUid();

    public ItemStack getIcon();

    @Nullable
    public SoundEvent getAmbientSound(EntityMaid var1);

    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid var1);

    default public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        return Collections.emptyList();
    }

    default public boolean isEnable(EntityMaid maid) {
        return true;
    }

    default public boolean enableLookAndRandomWalk(EntityMaid maid) {
        return true;
    }

    default public boolean enablePanic(EntityMaid maid) {
        return true;
    }

    default public boolean enableEating(EntityMaid maid) {
        return true;
    }

    default public boolean workPointTask(EntityMaid maid) {
        return false;
    }

    default public boolean canSitInJoy(EntityMaid maid, String joyType) {
        return false;
    }

    default public List<Pair<String, Predicate<EntityMaid>>> getEnableConditionDesc(EntityMaid maid) {
        return Collections.emptyList();
    }

    default public MutableComponent getName() {
        return Component.m_237115_((String)String.format("task.%s.%s", this.getUid().m_135827_(), this.getUid().m_135815_()));
    }

    default public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Collections.emptyList();
    }

    default public List<String> getDescription(EntityMaid maid) {
        String key = String.format("task.%s.%s.desc", this.getUid().m_135827_(), this.getUid().m_135815_());
        return Lists.newArrayList((Object[])new String[]{key});
    }

    default public MenuProvider getTaskConfigGuiProvider(EntityMaid maid) {
        final int entityId = maid.m_19879_();
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Maid Task Config Container");
            }

            public AbstractMaidContainer createMenu(int index, Inventory playerInventory, Player player) {
                return new DefaultMaidTaskConfigContainer(index, playerInventory, entityId);
            }
        };
    }

    default public MenuProvider getTaskInfoGuiProvider(EntityMaid maid) {
        return maid.getMaidBackpackType().getGuiProvider(maid.m_19879_());
    }

    default public AABB searchDimension(EntityMaid maid) {
        float radius = this.searchRadius(maid);
        if (maid.m_21536_()) {
            return new AABB(maid.m_21534_()).m_82377_((double)radius, 4.0, (double)radius);
        }
        return maid.m_20191_().m_82377_((double)radius, 4.0, (double)radius);
    }

    default public float searchRadius(EntityMaid maid) {
        return maid.m_21535_();
    }
}

