/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraftforge.common.ForgeConfigSpec;

public interface IRangedAttackTask
extends IAttackTask {
    public static final TargetingConditions TARGET_CONDITIONS = TargetingConditions.m_148352_();

    public static Optional<? extends LivingEntity> findFirstValidAttackTarget(EntityMaid maid) {
        LivingEntity lastAttacker = maid.m_21188_();
        if (lastAttacker != null && maid.m_6779_(lastAttacker) && maid.canSee(lastAttacker)) {
            return Optional.of(lastAttacker);
        }
        Optional memory = maid.m_6274_().m_21952_(MemoryModuleType.f_148204_);
        if (memory.isEmpty()) {
            return Optional.empty();
        }
        for (LivingEntity e : (List)memory.get()) {
            if (!maid.m_6779_(e) || !maid.canSee(e)) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public static boolean targetConditionsTest(EntityMaid maid, LivingEntity target, ForgeConfigSpec.IntValue configRange) {
        TARGET_CONDITIONS.m_26883_((double)((Integer)configRange.get()).intValue());
        return TARGET_CONDITIONS.m_26885_((LivingEntity)maid, target);
    }

    public void performRangedAttack(EntityMaid var1, LivingEntity var2, float var3);

    default public boolean canSee(EntityMaid maid, LivingEntity target) {
        return BehaviorUtils.m_22667_((LivingEntity)maid, (LivingEntity)target);
    }
}

