/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.api.block.IBoardGameBlock;
import com.github.tartaricacid.touhoulittlemaid.api.game.xqwlight.Position;
import com.github.tartaricacid.touhoulittlemaid.block.BlockJoy;
import com.github.tartaricacid.touhoulittlemaid.block.properties.GomokuPart;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.CChessToClientMessage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityCChess;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityJoy;
import com.github.tartaricacid.touhoulittlemaid.util.CChessUtil;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockCChess
extends BlockJoy
implements IBoardGameBlock {
    public static final EnumProperty<GomokuPart> PART = EnumProperty.m_61587_((String)"part", GomokuPart.class);
    public static final VoxelShape AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public BlockCChess() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f).m_280606_().m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)((Object)GomokuPart.CENTER))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    private static void handleCChessRemove(Level world, BlockPos pos, BlockState state) {
        if (!world.f_46443_) {
            GomokuPart part = (GomokuPart)((Object)state.m_61143_(PART));
            BlockPos centerPos = pos.m_121996_(new Vec3i(part.getPosX(), 0, part.getPosY()));
            BlockEntity te = world.m_7702_(centerPos);
            BlockCChess.m_49840_((Level)world, (BlockPos)centerPos, (ItemStack)((Item)InitItems.CCHESS.get()).m_7968_());
            if (te instanceof TileEntityCChess) {
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        world.m_46597_(centerPos.m_7918_(i, 0, j), Blocks.f_50016_.m_49966_());
                    }
                }
            }
        }
    }

    public static void maidMove(ServerPlayer player, Level level, BlockPos pos, int move, boolean maidLost, boolean playerLost) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TileEntityCChess) {
            EntitySit sit;
            ServerLevel serverLevel;
            Entity entity;
            TileEntityCChess chess = (TileEntityCChess)blockEntity;
            if (chess.isPlayerTurn()) {
                return;
            }
            Position chessData = chess.getChessData();
            UUID sitId = chess.getSitId();
            if (maidLost && CChessUtil.isMaid(chessData) && chessData.isMate()) {
                EntityMaid maid;
                EntitySit sit2;
                ServerLevel serverLevel2;
                Entity entity2;
                chess.setCheckmate(true);
                chess.refresh();
                if (level instanceof ServerLevel && (entity2 = (serverLevel2 = (ServerLevel)level).m_8791_(sitId)) instanceof EntitySit && (entity2 = (sit2 = (EntitySit)entity2).m_146895_()) instanceof EntityMaid && (maid = (EntityMaid)entity2).m_21830_((LivingEntity)player)) {
                    maid.getFavorabilityManager().apply(Type.CCHESS_WIN);
                    maid.getGameRecordManager().markStatue(false);
                    InitTrigger.MAID_EVENT.trigger(player, "win_cchess");
                }
                return;
            }
            boolean notChecked = chessData.makeMove(move);
            if (notChecked && chessData.captured()) {
                chessData.setIrrev();
            }
            chess.setSelectChessPoint(Position.DST(move));
            chess.setCheckmate(playerLost);
            if (!playerLost) {
                if (CChessUtil.reachMoveLimit(chessData)) {
                    chess.setMoveNumberLimit(true);
                } else if (CChessUtil.isRepeat(chessData)) {
                    chess.setRepeat(true);
                }
            }
            if (level instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).m_8791_(sitId)) instanceof EntitySit && (entity = (sit = (EntitySit)entity).m_146895_()) instanceof EntityMaid) {
                EntityMaid maid = (EntityMaid)entity;
                maid.m_6674_(InteractionHand.MAIN_HAND);
                if (playerLost) {
                    maid.getGameRecordManager().markStatue(true);
                }
            }
            level.m_5594_(null, pos, (SoundEvent)InitSounds.GOMOKU.get(), SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            chess.refresh();
        }
    }

    @Override
    public void startMaidSit(EntityMaid maid, BlockState state, Level worldIn, BlockPos pos) {
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            BlockEntity blockEntity = worldIn.m_7702_(pos);
            if (blockEntity instanceof TileEntityJoy) {
                TileEntityJoy joy = (TileEntityJoy)blockEntity;
                Entity oldSitEntity = serverLevel.m_8791_(joy.getSitId());
                if (oldSitEntity != null && oldSitEntity.m_6084_()) {
                    return;
                }
                Direction face = ((Direction)state.m_61143_((Property)FACING)).m_122424_();
                Vec3 position = new Vec3(0.5 + (double)(face.m_122429_() * 2), 0.1, 0.5 + (double)(face.m_122431_() * 2));
                EntitySit newSitEntity = new EntitySit(worldIn, Vec3.m_272021_((Vec3i)pos, (double)position.f_82479_, (double)position.f_82480_, (double)position.f_82481_), this.getTypeName(), pos);
                newSitEntity.m_146922_(face.m_122424_().m_122435_() + (float)this.sitYRot());
                worldIn.m_7967_((Entity)newSitEntity);
                joy.setSitId(newSitEntity.m_20148_());
                joy.m_6596_();
                maid.m_20329_(newSitEntity);
            }
        }
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        BlockCChess.handleCChessRemove(world, pos, state);
        super.m_5707_(world, pos, state, player);
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        BlockCChess.handleCChessRemove(world, pos, state);
        super.onBlockExploded(state, world, pos, explosion);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos centerPos = context.m_8083_();
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos searchPos = centerPos.m_7918_(i, 0, j);
                if (context.m_43725_().m_8055_(searchPos).m_60629_(context)) continue;
                return null;
            }
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (worldIn.f_46443_) {
            return;
        }
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos searchPos = pos.m_7918_(i, 0, j);
                GomokuPart part = GomokuPart.getPartByPos(i, j);
                if (part == null || part.isCenter()) continue;
                worldIn.m_7731_(searchPos, (BlockState)state.m_61124_(PART, (Comparable)((Object)part)), 3);
            }
        }
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (hand == InteractionHand.MAIN_HAND && player.m_21205_().m_41619_()) {
                int nowClick;
                Entity entity;
                GomokuPart part = (GomokuPart)((Object)state.m_61143_(PART));
                BlockPos centerPos = pos.m_121996_(new Vec3i(part.getPosX(), 0, part.getPosY()));
                BlockEntity te = level.m_7702_(centerPos);
                if (!(te instanceof TileEntityCChess)) {
                    return InteractionResult.FAIL;
                }
                TileEntityCChess chess = (TileEntityCChess)te;
                if (!chess.isPlayerTurn() && !chess.isCheckmate()) {
                    return InteractionResult.FAIL;
                }
                Entity sitEntity = serverLevel.m_8791_(chess.getSitId());
                if (sitEntity == null || !sitEntity.m_6084_() || !((entity = sitEntity.m_146895_()) instanceof EntityMaid)) {
                    player.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.gomoku.no_maid"));
                    return InteractionResult.FAIL;
                }
                EntityMaid maid = (EntityMaid)entity;
                if (((Boolean)MaidConfig.MAID_GOMOKU_OWNER_LIMIT.get()).booleanValue() && !maid.m_21830_((LivingEntity)player)) {
                    player.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.gomoku.not_owner"));
                    return InteractionResult.FAIL;
                }
                Direction facing = (Direction)state.m_61143_((Property)FACING);
                Vec3 clickPos = hit.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82520_((double)part.getPosX() - 0.5, 0.0, (double)part.getPosY() - 0.5).m_82524_(facing.m_122435_() * ((float)Math.PI / 180));
                boolean clickResetArea = CChessUtil.isClickResetArea(clickPos);
                if (clickResetArea) {
                    chess.reset();
                    chess.refresh();
                    level.m_5594_(null, centerPos, (SoundEvent)InitSounds.GOMOKU_RESET.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    maid.getGameRecordManager().resetStatue();
                }
                if ((nowClick = CChessUtil.getClickPosition(clickPos)) < 0 || !Position.IN_BOARD(nowClick)) {
                    return InteractionResult.PASS;
                }
                if (chess.isCheckmate() && chess.isPlayerTurn()) {
                    return InteractionResult.FAIL;
                }
                if (chess.isMoveNumberLimit() || chess.isRepeat()) {
                    return InteractionResult.FAIL;
                }
                Position chessData = chess.getChessData();
                byte[] squares = chessData.squares;
                int preClick = chess.getSelectChessPoint();
                if (preClick < 0 || squares.length <= preClick) {
                    preClick = 0;
                }
                byte prePiece = squares[preClick];
                byte nowPiece = squares[nowClick];
                if (prePiece <= 0 || CChessUtil.isBlack(prePiece)) {
                    if (CChessUtil.isRed(nowPiece)) {
                        chess.setSelectChessPoint(nowClick);
                        chess.refresh();
                        level.m_5594_(null, pos, (SoundEvent)InitSounds.GOMOKU.get(), SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (CChessUtil.isRed(prePiece) && CChessUtil.isRed(nowPiece)) {
                    chess.setSelectChessPoint(nowClick);
                    chess.refresh();
                    level.m_5594_(null, pos, (SoundEvent)InitSounds.GOMOKU.get(), SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
                    return InteractionResult.SUCCESS;
                }
                int move = Position.MOVE(preClick, nowClick);
                if (!chessData.legalMove(move)) {
                    return InteractionResult.FAIL;
                }
                boolean notChecked = chessData.makeMove(move);
                if (notChecked) {
                    if (chessData.captured()) {
                        chessData.setIrrev();
                    }
                    chess.addChessCounter();
                    chess.setSelectChessPoint(nowClick);
                    chess.refresh();
                    level.m_5594_(null, pos, (SoundEvent)InitSounds.GOMOKU.get(), SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
                    NetworkHandler.sendToClientPlayer(new CChessToClientMessage(centerPos, chessData.toFen()), player);
                    return InteractionResult.SUCCESS;
                }
                player.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.cchess.check"));
                level.m_5594_(null, pos, (SoundEvent)SoundEvents.f_12210_.get(), SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    protected Vec3 sitPosition() {
        return Vec3.f_82478_;
    }

    @Override
    protected String getTypeName() {
        return Type.GOMOKU.getTypeName();
    }

    @Override
    protected int sitYRot() {
        return 0;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PART, FACING});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (((GomokuPart)((Object)state.m_61143_(PART))).isCenter()) {
            return new TileEntityCChess(pos, state);
        }
        return null;
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AABB;
    }
}

