/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang;

import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang.functions.BonePosition;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang.functions.BoneRotation;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang.functions.BoneScale;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang.functions.EffectLevel;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang.functions.EquippedEnchantmentLevel;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang.functions.ModVersion;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang.functions.RelativeBlockName;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang.variable.LadderFacingVariable;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.binding.ContextBinding;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.EmptyFunction;
import com.github.tartaricacid.touhoulittlemaid.util.EquipmentUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.ForgeMod;

public class YSMBinding
extends ContextBinding {
    public static final YSMBinding INSTANCE = new YSMBinding();

    private YSMBinding() {
        this.function("mod_version", new ModVersion());
        this.function("equipped_enchantment_level", new EquippedEnchantmentLevel());
        this.function("effect_level", new EffectLevel());
        this.function("relative_block_name", new RelativeBlockName());
        this.function("bone_rot", new BoneRotation());
        this.function("bone_pos", new BonePosition());
        this.function("bone_scale", new BoneScale());
        this.var("head_yaw", ctx -> Float.valueOf(ctx.data().netHeadYaw));
        this.var("head_pitch", ctx -> Float.valueOf(ctx.data().headPitch));
        this.var("weather", ctx -> YSMBinding.getWeather(ctx.level()));
        this.var("dimension_name", ctx -> ctx.level().m_46472_().m_135782_().toString());
        this.var("fps", ctx -> Minecraft.m_91087_().m_260875_());
        this.entityVar("is_passenger", ctx -> ((Entity)ctx.entity()).m_20159_());
        this.entityVar("is_sleep", ctx -> ((Entity)ctx.entity()).m_20089_() == Pose.SLEEPING);
        this.entityVar("is_sneak", ctx -> ((Entity)ctx.entity()).m_20096_() && ((Entity)ctx.entity()).m_20089_() == Pose.CROUCHING);
        this.entityVar("is_open_air", ctx -> YSMBinding.isOpenAir((Entity)ctx.entity()));
        this.entityVar("eye_in_water", ctx -> ((Entity)ctx.entity()).m_5842_());
        this.entityVar("frozen_ticks", ctx -> ((Entity)ctx.entity()).m_146888_());
        this.entityVar("air_supply", ctx -> ((Entity)ctx.entity()).m_20146_());
        this.livingEntityVar("has_helmet", ctx -> YSMBinding.getSlotValue((LivingEntity)ctx.entity(), EquipmentSlot.HEAD));
        this.livingEntityVar("has_chest_plate", ctx -> YSMBinding.getSlotValue((LivingEntity)ctx.entity(), EquipmentSlot.CHEST));
        this.livingEntityVar("has_leggings", ctx -> YSMBinding.getSlotValue((LivingEntity)ctx.entity(), EquipmentSlot.LEGS));
        this.livingEntityVar("has_boots", ctx -> YSMBinding.getSlotValue((LivingEntity)ctx.entity(), EquipmentSlot.FEET));
        this.livingEntityVar("has_mainhand", ctx -> YSMBinding.getSlotValue((LivingEntity)ctx.entity(), EquipmentSlot.MAINHAND));
        this.livingEntityVar("has_offhand", ctx -> YSMBinding.getSlotValue((LivingEntity)ctx.entity(), EquipmentSlot.OFFHAND));
        this.livingEntityVar("has_elytra", ctx -> !EquipmentUtil.getEquippedElytraItem((LivingEntity)ctx.entity()).m_41619_());
        this.livingEntityVar("is_riptide", ctx -> ((LivingEntity)ctx.entity()).m_21209_());
        this.livingEntityVar("armor_value", ctx -> ((LivingEntity)ctx.entity()).m_21230_());
        this.livingEntityVar("hurt_time", ctx -> ((LivingEntity)ctx.entity()).f_20916_);
        this.livingEntityVar("is_close_eyes", ctx -> YSMBinding.getEyeCloseState(ctx.animationEvent(), (LivingEntity)ctx.entity()));
        this.livingEntityVar("on_ladder", ctx -> ((LivingEntity)ctx.entity()).m_6147_());
        this.livingEntityVar("ladder_facing", new LadderFacingVariable());
        this.livingEntityVar("arrow_count", ctx -> ((LivingEntity)ctx.entity()).m_21234_());
        this.livingEntityVar("stinger_count", ctx -> ((LivingEntity)ctx.entity()).m_21235_());
        this.livingEntityVar("attack_damage", ctx -> ((LivingEntity)ctx.entity()).m_21133_(Attributes.f_22281_));
        this.livingEntityVar("attack_speed", ctx -> ((LivingEntity)ctx.entity()).m_21133_(Attributes.f_22283_));
        this.livingEntityVar("attack_knockback", ctx -> ((LivingEntity)ctx.entity()).m_21133_(Attributes.f_22282_));
        this.livingEntityVar("movement_speed", ctx -> ((LivingEntity)ctx.entity()).m_21133_(Attributes.f_22279_));
        this.livingEntityVar("knockback_resistance", ctx -> ((LivingEntity)ctx.entity()).m_21133_(Attributes.f_22278_));
        this.livingEntityVar("luck", ctx -> ((LivingEntity)ctx.entity()).m_21133_(Attributes.f_22286_));
        this.livingEntityVar("block_reach", ctx -> ((LivingEntity)ctx.entity()).m_21133_((Attribute)ForgeMod.BLOCK_REACH.get()));
        this.livingEntityVar("entity_reach", ctx -> ((LivingEntity)ctx.entity()).m_21133_((Attribute)ForgeMod.ENTITY_REACH.get()));
        this.livingEntityVar("swim_speed", ctx -> ((LivingEntity)ctx.entity()).m_21133_((Attribute)ForgeMod.SWIM_SPEED.get()));
        this.livingEntityVar("entity_gravity", ctx -> ((LivingEntity)ctx.entity()).m_21133_((Attribute)ForgeMod.ENTITY_GRAVITY.get()));
        this.livingEntityVar("step_height_addition", ctx -> ((LivingEntity)ctx.entity()).m_21133_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()));
        this.livingEntityVar("nametag_distance", ctx -> ((LivingEntity)ctx.entity()).m_21133_((Attribute)ForgeMod.NAMETAG_DISTANCE.get()));
        this.function("dump_equipped_item", new EmptyFunction());
        this.function("dump_relative_block", new EmptyFunction());
        this.function("bone_pivot_abs", new EmptyFunction());
        this.var("dump_mods", ctx -> 0);
        this.var("texture_name", ctx -> "");
        this.var("elytra_rot_x", ctx -> 0);
        this.var("elytra_rot_y", ctx -> 0);
        this.var("elytra_rot_z", ctx -> 0);
        this.entityVar("dump_effects", ctx -> 0);
        this.entityVar("dump_biome", ctx -> 0);
        this.entityVar("biome_category", ctx -> 0);
        this.livingEntityVar("rendering_in_inventory", ctx -> false);
        this.maidEntityVar("food_level", ctx -> 20);
        this.var("first_person_mod_hide", ctx -> false);
        this.var("has_left_shoulder_parrot", ctx -> false);
        this.var("has_right_shoulder_parrot", ctx -> false);
        this.var("left_shoulder_parrot_variant", ctx -> 0);
        this.var("right_shoulder_parrot_variant", ctx -> 0);
    }

    private static boolean getEyeCloseState(AnimationEvent<?> animationEvent, LivingEntity player) {
        double remainder = (animationEvent.getAnimationTick() + (double)(Math.abs(player.m_20148_().getLeastSignificantBits()) % 10L)) % 90.0;
        boolean isBlinkTime = 85.0 < remainder && remainder < 90.0;
        return player.m_5803_() || isBlinkTime;
    }

    private static boolean getSlotValue(LivingEntity entity, EquipmentSlot slot) {
        return !EquipmentUtil.getEquippedItem(entity, slot).m_41619_();
    }

    private static int getWeather(ClientLevel world) {
        if (world.m_46470_()) {
            return 2;
        }
        if (world.m_46471_()) {
            return 1;
        }
        return 0;
    }

    private static boolean isOpenAir(Entity entity) {
        BlockPos blockpos = entity.m_20183_();
        if (!entity.f_19853_.m_45527_(blockpos)) {
            return false;
        }
        return entity.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockpos).m_123342_() <= blockpos.m_123342_();
    }
}

