/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.ai;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.MaidAIChatManager;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.CharacterSetting;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.SettingReader;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.bean.MetaData;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SaveMaidAIDataMessage;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class SettingEditScreen
extends Screen {
    private static final long MAX_TIP_TIME = 2000L;
    private final EntityMaid maid;
    private final MaidAIChatManager manager;
    private EditBox ownerName;
    private MultiLineEditBox customSetting;
    private long tipTimestamp = -1L;

    public SettingEditScreen(EntityMaid maid) {
        super((Component)Component.m_237113_((String)"Setting Edit Screen"));
        this.maid = maid;
        this.manager = maid.getAiChatManager();
    }

    protected void m_7856_() {
        this.m_169413_();
        int posX = this.f_96543_ / 2 - 195;
        int boxWidth = 256;
        this.ownerName = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, posX + 1, 30, boxWidth - 2, 20, (Component)Component.m_237113_((String)"Owner Name Box")));
        this.ownerName.m_94144_(this.manager.ownerName);
        this.ownerName.m_94199_(128);
        this.ownerName.m_94151_(s -> {
            this.manager.ownerName = s;
        });
        this.customSetting = (MultiLineEditBox)this.m_142416_((GuiEventListener)new MultiLineEditBox(this.f_96547_, posX, 70, boxWidth, this.f_96544_ - 100, (Component)Component.m_237115_((String)"gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.edit"), (Component)Component.m_237113_((String)"Custom Setting Box")));
        this.customSetting.m_240159_(this.manager.customSetting);
        this.customSetting.m_239313_(4096);
        this.customSetting.m_239273_(s -> {
            this.manager.customSetting = s;
        });
        MutableComponent export = Component.m_237115_((String)"gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.export");
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)export, b -> this.exportSetting(export)).m_252987_(posX + 265, this.ownerName.m_252907_(), 128, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"selectWorld.edit.save"), b -> {
            this.saveConfig();
            this.tipTimestamp = System.currentTimeMillis();
        }).m_252987_(posX + 265, this.customSetting.m_252907_(), 128, 20).m_253136_());
        MutableComponent saveQuit = Component.m_237115_((String)"gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.save_and_quit");
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)saveQuit, b -> {
            this.saveConfig();
            Minecraft.m_91087_().m_91152_(null);
        }).m_252987_(posX + 265, this.customSetting.m_252907_() + 25, 128, 20).m_253136_());
    }

    private void exportSetting(MutableComponent export) {
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            String title = export.getString();
            String defaultFileName = "%s.yml".formatted(this.maid.m_7755_().getString());
            String path = SettingReader.getSettingsFolder().resolve(defaultFileName).toString();
            String fileFilter = Component.m_237115_((String)"gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.export.format").getString();
            PointerBuffer filterPattern = memoryStack.mallocPointer(1);
            filterPattern.put(memoryStack.UTF8((CharSequence)"*.yml"));
            filterPattern.flip();
            String result = TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)title, (CharSequence)path, (PointerBuffer)filterPattern, (CharSequence)fileFilter);
            if (StringUtils.isBlank((CharSequence)result)) {
                return;
            }
            File exportFile = new File(result);
            MetaData metaData = this.getMetaData();
            CharacterSetting setting = new CharacterSetting(metaData, this.customSetting.m_239249_());
            setting.save(exportFile);
            if (this.getMinecraft().f_91074_ != null) {
                MutableComponent tip = Component.m_237110_((String)"gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.export.success", (Object[])new Object[]{result}).m_130940_(ChatFormatting.GRAY);
                this.getMinecraft().f_91074_.m_213846_((Component)tip);
            }
        }
        catch (IOException e) {
            TouhouLittleMaid.LOGGER.error("Error saving setting", (Throwable)e);
        }
    }

    @NotNull
    private MetaData getMetaData() {
        String lang = this.getMinecraft().m_91102_().m_264236_();
        String author = "Unknown";
        if (this.getMinecraft().f_91074_ != null) {
            author = this.getMinecraft().f_91074_.m_6302_();
        }
        String modelId = this.maid.getModelId();
        return new MetaData(0, author, Collections.singletonList(modelId), lang);
    }

    public void m_86600_() {
        this.customSetting.m_239213_();
        this.ownerName.m_94120_();
        super.m_86600_();
    }

    public void m_6574_(Minecraft mc, int pWidth, int pHeight) {
        String ownerNameValue = this.ownerName.m_94155_();
        String customSettingValue = this.customSetting.m_239249_();
        super.m_6574_(mc, pWidth, pHeight);
        this.ownerName.m_94144_(ownerNameValue);
        this.customSetting.m_240159_(customSettingValue);
    }

    public boolean m_6348_(double x, double y, int button) {
        return super.m_6348_(x, y, button) || this.customSetting.m_6348_(x, y, button);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.touhou_little_maid.button.maid_ai_chat_config.owner_name"), this.ownerName.m_252754_() + 2, this.ownerName.m_252907_() - 12, 0xFFFFFF);
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.touhou_little_maid.button.maid_ai_chat_config.custom_setting"), this.customSetting.m_252754_() + 2, this.customSetting.m_252907_() - 12, 0xFFFFFF);
        this.drawMaid(graphics, this.customSetting.m_252754_() + this.customSetting.m_5711_() + 73, this.customSetting.m_252907_() + 96, this.maid);
        long time = System.currentTimeMillis() - this.tipTimestamp;
        if (time < 2000L) {
            double value = (double)time / 2000.0 * Math.PI;
            int alpha = (int)(Math.sin(value) * 255.0);
            alpha = Mth.m_14045_((int)alpha, (int)15, (int)240);
            graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.saved"), this.customSetting.m_252754_() + this.customSetting.m_5711_() + 73, this.customSetting.m_252907_() - 12, (alpha << 24) + 0xFF1111);
        }
    }

    private void drawMaid(GuiGraphics graphics, int posX, int posY, EntityMaid rawMaid) {
        EntityMaid maid;
        ClientLevel world = this.getMinecraft().f_91073_;
        if (world == null) {
            return;
        }
        Optional<MaidModelInfo> info = CustomPackLoader.MAID_MODELS.getInfo(rawMaid.getModelId());
        if (info.isEmpty()) {
            return;
        }
        MaidModelInfo modelInfo = info.get();
        try {
            maid = (EntityMaid)EntityCacheUtil.ENTITY_CACHE.get(EntityMaid.TYPE, () -> SettingEditScreen.lambda$drawMaid$6((Level)world));
        }
        catch (ClassCastException | ExecutionException e) {
            e.fillInStackTrace();
            return;
        }
        EntityCacheUtil.clearMaidDataResidue(maid, false);
        if (modelInfo.getEasterEgg() != null) {
            maid.setModelId("touhou_little_maid:easter_egg_model");
        } else {
            maid.setModelId(modelInfo.getModelId().toString());
        }
        maid.setIsYsmModel(false);
        float renderItemScale = modelInfo.getRenderItemScale();
        InventoryScreen.m_274545_((GuiGraphics)graphics, (int)posX, (int)(posY + (int)(45.0f * renderItemScale)), (int)((int)(45.0f * renderItemScale)), (float)25.0f, (float)0.0f, (LivingEntity)maid);
    }

    public boolean m_7043_() {
        return false;
    }

    private void saveConfig() {
        NetworkHandler.CHANNEL.sendToServer((Object)new SaveMaidAIDataMessage(this.maid.m_19879_(), this.manager));
    }

    private static /* synthetic */ Entity lambda$drawMaid$6(Level world) throws Exception {
        Entity e = EntityMaid.TYPE.m_20615_(world);
        return Objects.requireNonNullElseGet(e, () -> new EntityMaid(world));
    }
}

