/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.detail.ChairModelDetailsGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model.AbstractModelGui;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.ChairModelInfo;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.ChairModelMessage;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class ChairModelGui
extends AbstractModelGui<EntityChair, ChairModelInfo> {
    private static int PAGE_INDEX = 0;
    private static int PACK_INDEX = 0;
    private static int ROW_INDEX = 0;

    public ChairModelGui(EntityChair entity) {
        super(entity, CustomPackLoader.CHAIR_MODELS.getPackList());
    }

    @Override
    protected void drawLeftEntity(GuiGraphics graphics, int middleX, int middleY, float mouseX, float mouseY) {
        float renderItemScale = CustomPackLoader.CHAIR_MODELS.getModelRenderItemScale(((EntityChair)this.entity).getModelId());
        InventoryScreen.m_274545_((GuiGraphics)graphics, (int)((middleX - 128) / 2), (int)(middleY + 80), (int)((int)(45.0f * renderItemScale)), (float)-25.0f, (float)-20.0f, (LivingEntity)this.entity);
    }

    @Override
    protected void drawRightEntity(GuiGraphics graphics, int posX, int posY, ChairModelInfo modelItem) {
        ResourceLocation cacheIconId = modelItem.getCacheIconId();
        Map allTextures = Minecraft.m_91087_().f_90987_.f_118468_;
        if (((Boolean)MiscConfig.MODEL_ICON_CACHE.get()).booleanValue() && allTextures.containsKey(cacheIconId)) {
            int textureSize = 24;
            graphics.m_280411_(cacheIconId, posX - textureSize / 2, posY - textureSize, textureSize, textureSize, 0.0f, 0.0f, textureSize, textureSize, textureSize, textureSize);
        } else {
            this.drawEntity(graphics, posX, posY, modelItem);
        }
    }

    @Override
    protected void openDetailsGui(EntityChair entity, ChairModelInfo modelInfo) {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_((Screen)new ChairModelDetailsGui(entity, modelInfo));
        }
    }

    @Override
    protected void notifyModelChange(EntityChair entity, ChairModelInfo modelInfo) {
        NetworkHandler.CHANNEL.sendToServer((Object)new ChairModelMessage(entity.m_19879_(), modelInfo.getModelId(), modelInfo.getMountedYOffset(), modelInfo.isTameableCanRide(), modelInfo.isNoGravity()));
    }

    @Override
    protected void addModelCustomTips(ChairModelInfo modelItem, List<Component> tooltips) {
    }

    @Override
    protected int getPageIndex() {
        return PAGE_INDEX;
    }

    @Override
    protected void setPageIndex(int pageIndex) {
        PAGE_INDEX = pageIndex;
    }

    @Override
    protected int getPackIndex() {
        return PACK_INDEX;
    }

    @Override
    protected void setPackIndex(int packIndex) {
        PACK_INDEX = packIndex;
    }

    @Override
    protected int getRowIndex() {
        return ROW_INDEX;
    }

    @Override
    protected void setRowIndex(int rowIndex) {
        ROW_INDEX = rowIndex;
    }

    private void drawEntity(GuiGraphics graphics, int posX, int posY, ChairModelInfo modelItem) {
        EntityChair chair;
        ClientLevel world = this.getMinecraft().f_91073_;
        if (world == null) {
            return;
        }
        try {
            chair = (EntityChair)((Object)EntityCacheUtil.ENTITY_CACHE.get(EntityChair.TYPE, () -> ChairModelGui.lambda$drawEntity$1((Level)world)));
        }
        catch (ClassCastException | ExecutionException e) {
            e.printStackTrace();
            return;
        }
        chair.setModelId(modelItem.getModelId().toString());
        InventoryScreen.m_274545_((GuiGraphics)graphics, (int)posX, (int)posY, (int)((int)(12.0f * modelItem.getRenderItemScale())), (float)-25.0f, (float)-20.0f, (LivingEntity)chair);
    }

    private static /* synthetic */ Entity lambda$drawEntity$1(Level world) throws Exception {
        Entity e = EntityChair.TYPE.m_20615_(world);
        return Objects.requireNonNullElseGet(e, () -> new EntityChair(world));
    }
}

