/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.implement;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.EntityGraphics;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.IChatBubbleRenderer;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextChatBubbleRenderer
implements IChatBubbleRenderer {
    private static final int MAX_WIDTH = 240;
    private static final int MAX_CENTER_WIDTH = 480;
    private final List<FormattedCharSequence> split;
    private final Font font;
    private final int width;
    private final int height;
    private final ResourceLocation bg;

    public TextChatBubbleRenderer(Component text, ResourceLocation bg, IChatBubbleRenderer.Position position) {
        this.font = Minecraft.m_91087_().f_91062_;
        if (position == IChatBubbleRenderer.Position.CENTER) {
            this.split = this.font.m_92923_((FormattedText)text, 480);
            this.width = this.getMaxWidth(this.split);
        } else {
            this.split = this.font.m_92923_((FormattedText)text, 240);
            this.width = this.getMaxWidth(this.split);
        }
        int n = this.split.size();
        Objects.requireNonNull(this.font);
        this.height = n * 9;
        this.bg = bg;
    }

    private int getMaxWidth(List<FormattedCharSequence> split) {
        int width = 0;
        for (FormattedCharSequence sequence : split) {
            int lineWidth = this.font.m_92724_(sequence);
            if (lineWidth <= width) continue;
            width = lineWidth;
        }
        return width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void render(EntityMaidRenderer renderer, EntityGraphics graphics) {
        int y = 0;
        for (FormattedCharSequence sequence : this.split) {
            graphics.drawString(this.font, sequence, 0.0f, (float)y, 0, false);
            Objects.requireNonNull(this.font);
            y += 9;
        }
    }

    @Override
    public ResourceLocation getBackgroundTexture() {
        return this.bg;
    }
}

