/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.aquaculture.client;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.MaidFishingHookRenderer;
import com.github.tartaricacid.touhoulittlemaid.compat.aquaculture.entity.AquacultureFishingHook;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class AquacultureFishingHookRenderer
extends MaidFishingHookRenderer<AquacultureFishingHook> {
    private static final ResourceLocation BOBBER = new ResourceLocation("aquaculture", "textures/entity/rod/bobber/bobber.png");
    private static final ResourceLocation BOBBER_OVERLAY = new ResourceLocation("aquaculture", "textures/entity/rod/bobber/bobber_overlay.png");
    private static final ResourceLocation BOBBER_VANILLA = new ResourceLocation("aquaculture", "textures/entity/rod/bobber/bobber_vanilla.png");
    private static final ResourceLocation HOOK = new ResourceLocation("aquaculture", "textures/entity/rod/hook/hook.png");
    private static final RenderType BOBBER_RENDER = RenderType.m_110452_((ResourceLocation)BOBBER);
    private static final RenderType BOBBER_OVERLAY_RENDER = RenderType.m_110452_((ResourceLocation)BOBBER_OVERLAY);
    private static final RenderType BOBBER_VANILLA_RENDER = RenderType.m_110452_((ResourceLocation)BOBBER_VANILLA);
    private static final RenderType HOOK_RENDER = RenderType.m_110452_((ResourceLocation)HOOK);

    public AquacultureFishingHookRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderBobber(AquacultureFishingHook fishingHook, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        poseStack.m_252781_(this.f_114476_.m_253208_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        PoseStack.Pose lasted = poseStack.m_85850_();
        Matrix4f lastedPose = lasted.m_252922_();
        Matrix3f lastedNormal = lasted.m_252943_();
        VertexConsumer consumer = fishingHook.hasBobber() ? buffer.m_6299_(BOBBER_OVERLAY_RENDER) : buffer.m_6299_(BOBBER_VANILLA_RENDER);
        ItemStack bobberStack = fishingHook.getBobber();
        float bobberR = 1.0f;
        float bobberG = 1.0f;
        float bobberB = 1.0f;
        if (!bobberStack.m_41619_() && bobberStack.m_41720_() instanceof DyeableLeatherItem) {
            int colorInt = ((DyeableLeatherItem)bobberStack.m_41720_()).m_41121_(bobberStack);
            bobberR = (float)(colorInt >> 16 & 0xFF) / 255.0f;
            bobberG = (float)(colorInt >> 8 & 0xFF) / 255.0f;
            bobberB = (float)(colorInt & 0xFF) / 255.0f;
        }
        AquacultureFishingHookRenderer.vertex(consumer, lastedPose, lastedNormal, packedLight, 0.0f, 0, 0, 1, bobberR, bobberG, bobberB);
        AquacultureFishingHookRenderer.vertex(consumer, lastedPose, lastedNormal, packedLight, 1.0f, 0, 1, 1, bobberR, bobberG, bobberB);
        AquacultureFishingHookRenderer.vertex(consumer, lastedPose, lastedNormal, packedLight, 1.0f, 1, 1, 0, bobberR, bobberG, bobberB);
        AquacultureFishingHookRenderer.vertex(consumer, lastedPose, lastedNormal, packedLight, 0.0f, 1, 0, 0, bobberR, bobberG, bobberB);
        if (fishingHook.hasBobber()) {
            VertexConsumer bobberVertex = buffer.m_6299_(BOBBER_RENDER);
            AquacultureFishingHookRenderer.renderPosTexture(bobberVertex, lastedPose, lastedNormal, packedLight, 0.0f, 0, 0, 1);
            AquacultureFishingHookRenderer.renderPosTexture(bobberVertex, lastedPose, lastedNormal, packedLight, 1.0f, 0, 1, 1);
            AquacultureFishingHookRenderer.renderPosTexture(bobberVertex, lastedPose, lastedNormal, packedLight, 1.0f, 1, 1, 0);
            AquacultureFishingHookRenderer.renderPosTexture(bobberVertex, lastedPose, lastedNormal, packedLight, 0.0f, 1, 0, 0);
        }
        RenderType renderType = RenderType.m_110452_((ResourceLocation)fishingHook.getHook().getTexture());
        VertexConsumer hookVertex = fishingHook.hasHook() ? buffer.m_6299_(renderType) : buffer.m_6299_(HOOK_RENDER);
        AquacultureFishingHookRenderer.renderPosTexture(hookVertex, lastedPose, lastedNormal, packedLight, 0.0f, 0, 0, 1);
        AquacultureFishingHookRenderer.renderPosTexture(hookVertex, lastedPose, lastedNormal, packedLight, 1.0f, 0, 1, 1);
        AquacultureFishingHookRenderer.renderPosTexture(hookVertex, lastedPose, lastedNormal, packedLight, 1.0f, 1, 1, 0);
        AquacultureFishingHookRenderer.renderPosTexture(hookVertex, lastedPose, lastedNormal, packedLight, 0.0f, 1, 0, 0);
        poseStack.m_85849_();
    }

    @Override
    protected float[] getLineColor(AquacultureFishingHook fishingHook) {
        DyeableLeatherItem lineItem;
        ItemStack line = fishingHook.getFishingLine();
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (!line.m_41619_() && (lineItem = (DyeableLeatherItem)line.m_41720_()).m_41113_(line)) {
            int colorInt = lineItem.m_41121_(line);
            r = (float)(colorInt >> 16 & 0xFF) / 255.0f;
            g = (float)(colorInt >> 8 & 0xFF) / 255.0f;
            b = (float)(colorInt & 0xFF) / 255.0f;
        }
        return new float[]{r, g, b};
    }

    @Override
    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull AquacultureFishingHook fishHook) {
        return BOBBER_VANILLA;
    }
}

