/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.kinds.IdF;
import com.mojang.datafixers.kinds.OptionalBox;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.behavior.declarative.Trigger;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class MaidRangedWalkToTarget {
    public static BehaviorControl<EntityMaid> create(float speedModifier) {
        return MaidRangedWalkToTarget.create(entity -> Float.valueOf(speedModifier));
    }

    public static BehaviorControl<EntityMaid> create(Function<LivingEntity, Float> speedModifier) {
        return BehaviorBuilder.m_258034_(maidInstance -> maidInstance.group((App)maidInstance.m_257492_(MemoryModuleType.f_26370_), (App)maidInstance.m_257492_(MemoryModuleType.f_26371_), (App)maidInstance.m_257495_(MemoryModuleType.f_26372_), (App)maidInstance.m_257492_(MemoryModuleType.f_148205_)).apply((Applicative)maidInstance, (walkTargetMemory, positionMemory, entityMemory, livingEntitiesMemory) -> MaidRangedWalkToTarget.setTarget(speedModifier, (BehaviorBuilder.Instance<EntityMaid>)maidInstance, (MemoryAccessor<OptionalBox.Mu, WalkTarget>)walkTargetMemory, (MemoryAccessor<OptionalBox.Mu, PositionTracker>)positionMemory, (MemoryAccessor<IdF.Mu, LivingEntity>)entityMemory, (MemoryAccessor<OptionalBox.Mu, NearestVisibleLivingEntities>)livingEntitiesMemory)));
    }

    @NotNull
    private static Trigger<EntityMaid> setTarget(Function<LivingEntity, Float> speedModifier, BehaviorBuilder.Instance<EntityMaid> maidInstance, MemoryAccessor<OptionalBox.Mu, WalkTarget> walkTargetMemory, MemoryAccessor<OptionalBox.Mu, PositionTracker> positionMemory, MemoryAccessor<IdF.Mu, LivingEntity> entityMemory, MemoryAccessor<OptionalBox.Mu, NearestVisibleLivingEntities> livingEntitiesMemory) {
        return (level, maid, gameTime) -> {
            LivingEntity target = (LivingEntity)maidInstance.m_258051_(entityMemory);
            if (maid.canSee(target) && MaidRangedWalkToTarget.shouldEraseWalkTarget(maid, target)) {
                walkTargetMemory.m_257971_();
            } else {
                positionMemory.m_257512_((Object)new EntityTracker((Entity)target, true));
                walkTargetMemory.m_257512_((Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)target, false), ((Float)speedModifier.apply(maid)).floatValue(), 0));
            }
            return true;
        };
    }

    private static boolean shouldEraseWalkTarget(EntityMaid maid, LivingEntity target) {
        float restrictRadius = maid.m_21535_() - 2.0f;
        double checkRadius = 8.0;
        if (maid.m_21536_()) {
            BlockPos center = maid.m_21534_();
            checkRadius = Math.sqrt(target.m_20275_((double)center.m_123341_(), (double)center.m_123342_(), (double)center.m_123343_()));
        } else {
            LivingEntity livingEntity = maid.m_269323_();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                checkRadius = target.m_20270_((Entity)player);
            }
        }
        return checkRadius <= 4.0 || checkRadius >= (double)restrictRadius;
    }
}

