/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.backpack;

import com.github.tartaricacid.touhoulittlemaid.api.backpack.IBackpackData;
import com.github.tartaricacid.touhoulittlemaid.api.backpack.IMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.data.TankBackpackData;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityTombstone;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack.TankBackpackContainer;
import com.github.tartaricacid.touhoulittlemaid.item.ItemTankBackpack;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TankBackpack
extends IMaidBackpack {
    public static final ResourceLocation ID = new ResourceLocation("touhou_little_maid", "tank");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public Item getItem() {
        return (Item)InitItems.TANK_BACKPACK.get();
    }

    @Override
    public void onPutOn(ItemStack stack, Player player, EntityMaid maid) {
        IBackpackData backpackData = maid.getBackpackData();
        if (backpackData instanceof TankBackpackData) {
            TankBackpackData tankBackpackData = (TankBackpackData)backpackData;
            ItemTankBackpack.setTankBackpack(maid, tankBackpackData, stack);
        }
    }

    @Override
    public void onTakeOff(ItemStack stack, Player player, EntityMaid maid) {
        IBackpackData backpackData = maid.getBackpackData();
        if (backpackData instanceof TankBackpackData) {
            TankBackpackData tankBackpackData = (TankBackpackData)backpackData;
            InvWrapper inv = new InvWrapper((Container)tankBackpackData);
            ItemsUtil.dropEntityItems((Entity)maid, (IItemHandler)inv);
        }
        this.dropRelativeItems(stack, maid);
    }

    @Override
    public ItemStack getTakeOffItemStack(ItemStack stack, @Nullable Player player, EntityMaid maid) {
        IBackpackData backpackData = maid.getBackpackData();
        if (backpackData instanceof TankBackpackData) {
            TankBackpackData tankBackpackData = (TankBackpackData)backpackData;
            return ItemTankBackpack.getTankBackpack(tankBackpackData);
        }
        return super.getTakeOffItemStack(stack, player, maid);
    }

    @Override
    public void onSpawnTombstone(EntityMaid maid, EntityTombstone tombstone) {
        IBackpackData backpackData = maid.getBackpackData();
        if (backpackData instanceof TankBackpackData) {
            TankBackpackData tankBackpackData = (TankBackpackData)backpackData;
            InvWrapper inv = new InvWrapper((Container)tankBackpackData);
            for (int i = 0; i < inv.getSlots(); ++i) {
                int size = inv.getSlotLimit(i);
                tombstone.insertItem(inv.extractItem(i, size, false));
            }
        }
    }

    @Override
    public boolean hasBackpackData() {
        return true;
    }

    @Override
    @Nullable
    public IBackpackData getBackpackData(EntityMaid maid) {
        return new TankBackpackData(maid);
    }

    @Override
    public MenuProvider getGuiProvider(final int entityId) {
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Maid Tank Container");
            }

            public AbstractMaidContainer createMenu(int index, Inventory playerInventory, Player player) {
                return new TankBackpackContainer(index, playerInventory, entityId);
            }
        };
    }

    @Override
    public int getAvailableMaxContainerIndex() {
        return 18;
    }

    @Override
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public EntityModel<EntityMaid> getBackpackModel(EntityModelSet modelSet) {
        return BedrockModelLoader.getModel(BedrockModelLoader.TANK_BACKPACK);
    }

    @Override
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getBackpackTexture() {
        return new ResourceLocation("touhou_little_maid", "textures/bedrock/entity/backpack/tank_backpack.png");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void offsetBackpackItem(PoseStack poseStack) {
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-7.5f));
        poseStack.m_85837_(0.0, 0.625, -0.25);
    }
}

