/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.IChatBubbleRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.implement.ImageChatBubbleRenderer;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.IChatBubbleData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ImageChatBubbleData
implements IChatBubbleData {
    public static final ResourceLocation ID = new ResourceLocation("touhou_little_maid", "image");
    private final int existTick;
    private final ResourceLocation bg;
    private final ResourceLocation image;
    private final int width;
    private final int height;
    private final int uOffset;
    private final int vOffset;
    private final int textureWidth;
    private final int textureHeight;
    private final int priority;
    @OnlyIn(value=Dist.CLIENT)
    private IChatBubbleRenderer renderer;

    private ImageChatBubbleData(int existTick, ResourceLocation bg, ResourceLocation image, int width, int height, int uOffset, int vOffset, int textureWidth, int textureHeight, int priority) {
        this.existTick = existTick;
        this.bg = bg;
        this.image = image;
        this.width = width;
        this.height = height;
        this.uOffset = uOffset;
        this.vOffset = vOffset;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.priority = priority;
    }

    public static ImageChatBubbleData create(ResourceLocation image, int width, int height) {
        return new ImageChatBubbleData(300, TYPE_2, image, width, height, 0, 0, 256, 256, 0);
    }

    public static ImageChatBubbleData create(ResourceLocation image, int width, int height, int uOffset, int vOffset) {
        return new ImageChatBubbleData(300, TYPE_2, image, width, height, uOffset, vOffset, 256, 256, 0);
    }

    public static ImageChatBubbleData create(int existTick, ResourceLocation bg, ResourceLocation image, int width, int height, int uOffset, int vOffset, int textureWidth, int textureHeight, int priority) {
        return new ImageChatBubbleData(existTick, bg, image, width, height, uOffset, vOffset, textureWidth, textureHeight, priority);
    }

    @Override
    public int existTick() {
        return this.existTick;
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IChatBubbleRenderer getRenderer(IChatBubbleRenderer.Position position) {
        if (this.renderer == null) {
            this.renderer = new ImageChatBubbleRenderer(this.width, this.height, this.uOffset, this.vOffset, this.textureWidth, this.textureHeight, this.bg, this.image);
        }
        return this.renderer;
    }

    public static class ImageChatSerializer
    implements IChatBubbleData.ChatSerializer {
        @Override
        public IChatBubbleData readFromBuff(FriendlyByteBuf buf) {
            int width = buf.m_130242_();
            int height = buf.m_130242_();
            int uOffset = buf.m_130242_();
            int vOffset = buf.m_130242_();
            int textureWidth = buf.m_130242_();
            int textureHeight = buf.m_130242_();
            ResourceLocation bg = buf.m_130281_();
            ResourceLocation image = buf.m_130281_();
            return new ImageChatBubbleData(300, bg, image, width, height, uOffset, vOffset, textureWidth, textureHeight, 0);
        }

        @Override
        public void writeToBuff(FriendlyByteBuf buf, IChatBubbleData data) {
            ImageChatBubbleData imageChat = (ImageChatBubbleData)data;
            buf.m_130130_(imageChat.width);
            buf.m_130130_(imageChat.height);
            buf.m_130130_(imageChat.uOffset);
            buf.m_130130_(imageChat.vOffset);
            buf.m_130130_(imageChat.textureWidth);
            buf.m_130130_(imageChat.textureHeight);
            buf.m_130085_(imageChat.bg);
            buf.m_130085_(imageChat.image);
        }
    }
}

