/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.projectile;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidFishedEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskFishing;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class MaidFishingHook
extends Projectile {
    public static final EntityType<MaidFishingHook> TYPE = EntityType.Builder.m_20704_(MaidFishingHook::new, (MobCategory)MobCategory.MISC).m_20716_().m_20698_().m_20699_(0.25f, 0.25f).m_20702_(4).m_20717_(5).m_20712_("fishing_hook");
    protected static final EntityDataAccessor<Boolean> DATA_BITING = SynchedEntityData.m_135353_(MaidFishingHook.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final int MAX_OUT_OF_WATER_TIME = 10;
    protected final RandomSource syncronizedRandom = RandomSource.m_216327_();
    protected final int luck;
    protected final int lureSpeed;
    protected boolean biting;
    protected int nibble;
    protected int timeUntilLured;
    protected int timeUntilHooked;
    protected int outOfWaterTime;
    protected int life;
    protected float fishAngle;
    protected boolean openWater = true;
    protected FishHookState currentState = FishHookState.FLYING;

    protected MaidFishingHook(EntityType<? extends MaidFishingHook> entityType, Level level, int luck, int lureSpeed) {
        super(entityType, level);
        this.f_19811_ = true;
        this.luck = Math.max(0, luck);
        this.lureSpeed = Math.max(0, lureSpeed);
    }

    public MaidFishingHook(EntityType<MaidFishingHook> entityType, Level level) {
        this(entityType, level, 0, 0);
    }

    public MaidFishingHook(EntityMaid maid, Level level, int luck, int lureSpeed, Vec3 pos) {
        this(TYPE, level, luck, lureSpeed);
        this.m_5602_((Entity)maid);
        this.m_20219_(pos);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_BITING, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (DATA_BITING.equals(key)) {
            this.biting = (Boolean)this.m_20088_().m_135370_(DATA_BITING);
            if (this.biting) {
                this.m_20334_(this.m_20184_().f_82479_, -0.4 * (double)Mth.m_216267_((RandomSource)this.syncronizedRandom, (float)0.6f, (float)1.0f), this.m_20184_().f_82481_);
            }
        }
        super.m_7350_(key);
    }

    public boolean m_6783_(double distance) {
        return distance < 4096.0;
    }

    public void m_6453_(double pX, double pY, double pZ, float pYaw, float pPitch, int pPosRotationIncrements, boolean pTeleport) {
    }

    public void m_8119_() {
        this.syncronizedRandom.m_188584_(this.m_20148_().getLeastSignificantBits() ^ this.f_19853_.m_46467_());
        super.m_8119_();
        EntityMaid maid = this.getMaidOwner();
        if (maid == null) {
            this.m_146870_();
        } else if (this.f_19853_.f_46443_ || !this.shouldStopFishing(maid)) {
            if (this.lifeTick()) {
                return;
            }
            maid.m_21563_().m_148051_((Entity)this);
            this.fishingTick();
        }
    }

    protected boolean lifeTick() {
        if (this.m_20096_()) {
            ++this.life;
            if (this.life >= 100) {
                this.m_146870_();
                return true;
            }
        } else {
            this.life = 0;
        }
        return false;
    }

    protected void fishingTick() {
        boolean onWaterSurface;
        BlockPos blockPos = this.m_20183_();
        FluidState fluidState = this.f_19853_.m_6425_(blockPos);
        float fluidHeight = this.getFluidHeight(fluidState, blockPos);
        boolean bl = onWaterSurface = fluidHeight > 0.0f;
        if (this.currentState == FishHookState.FLYING) {
            if (onWaterSurface) {
                this.waterSurfaceTick();
                return;
            }
        } else if (this.currentState == FishHookState.BOBBING) {
            this.bobbingTick(blockPos, fluidHeight);
            this.checkOpenWater(blockPos);
            if (onWaterSurface) {
                this.bitingTick(blockPos);
            } else {
                this.outOfWaterTime = Math.min(10, this.outOfWaterTime + 1);
            }
        }
        this.fallTick(fluidState);
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_37283_();
        if (this.currentState == FishHookState.FLYING && (this.m_20096_() || this.f_19862_)) {
            this.m_20256_(Vec3.f_82478_);
        }
        this.m_20256_(this.m_20184_().m_82490_(0.92));
        this.m_20090_();
    }

    protected void fallTick(FluidState fluidState) {
        if (!fluidState.m_205070_(FluidTags.f_13131_)) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.03, 0.0));
        }
    }

    protected void bitingTick(BlockPos blockPos) {
        this.outOfWaterTime = Math.max(0, this.outOfWaterTime - 1);
        if (this.biting) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.1 * (double)this.syncronizedRandom.m_188501_() * (double)this.syncronizedRandom.m_188501_(), 0.0));
        }
        if (!this.f_19853_.f_46443_) {
            this.catchingFish(blockPos, (ServerLevel)this.f_19853_);
        }
    }

    protected void checkOpenWater(BlockPos blockPos) {
        this.openWater = this.nibble <= 0 && this.timeUntilHooked <= 0 ? true : this.openWater && this.outOfWaterTime < 10 && this.calculateOpenWater(blockPos);
    }

    protected float getFluidHeight(FluidState fluidState, BlockPos blockPos) {
        float fluidHeight = 0.0f;
        if (fluidState.m_205070_(FluidTags.f_13131_)) {
            fluidHeight = fluidState.m_76155_((BlockGetter)this.m_9236_(), blockPos);
        }
        return fluidHeight;
    }

    protected void waterSurfaceTick() {
        this.m_20256_(this.m_20184_().m_82542_(0.3, 0.2, 0.3));
        this.currentState = FishHookState.BOBBING;
    }

    protected void bobbingTick(BlockPos blockPos, float fluidHeight) {
        Vec3 movement = this.m_20184_();
        double bobbingY = this.m_20186_() + movement.f_82480_ - (double)blockPos.m_123342_() - (double)fluidHeight;
        if (Math.abs(bobbingY) < 0.01) {
            bobbingY += Math.signum(bobbingY) * 0.1;
        }
        this.m_20334_(movement.f_82479_ * 0.9, movement.f_82480_ - bobbingY * (double)this.f_19796_.m_188501_() * 0.2, movement.f_82481_ * 0.9);
    }

    protected void catchingFish(BlockPos pos, ServerLevel level) {
        int time = 1;
        BlockPos abovePos = pos.m_7494_();
        if (this.f_19796_.m_188501_() < 0.25f && level.m_46758_(abovePos)) {
            ++time;
        }
        if (this.f_19796_.m_188501_() < 0.5f && !level.m_45527_(abovePos)) {
            --time;
        }
        if (this.nibble > 0) {
            --this.nibble;
            this.onNibble(level);
        } else if (this.timeUntilHooked > 0) {
            this.timeUntilHooked -= time;
            if (this.timeUntilHooked > 0) {
                this.fishAngle += (float)this.f_19796_.m_216328_(0.0, 9.188);
                float fishAngleRad = this.fishAngle * ((float)Math.PI / 180);
                float sin = Mth.m_14031_((float)fishAngleRad);
                float cos = Mth.m_14089_((float)fishAngleRad);
                double x = this.m_20185_() + (double)(sin * (float)this.timeUntilHooked) * 0.1;
                double y = (double)Mth.m_14107_((double)this.m_20186_()) + 1.0;
                double z = this.m_20189_() + (double)(cos * (float)this.timeUntilHooked) * 0.1;
                BlockState blockState = level.m_8055_(BlockPos.m_274561_((double)x, (double)(y - 1.0), (double)z));
                this.spawnFishingParticle(level, blockState, x, y, z, sin, cos);
            } else {
                this.spawnNibbleParticle(level);
                this.nibble = Mth.m_216271_((RandomSource)this.f_19796_, (int)20, (int)40);
                this.m_20088_().m_135381_(DATA_BITING, (Object)true);
            }
        } else if (this.timeUntilLured > 0) {
            this.timeUntilLured -= time;
            float probability = 0.15f;
            if (this.timeUntilLured < 20) {
                probability += (float)(20 - this.timeUntilLured) * 0.05f;
            } else if (this.timeUntilLured < 40) {
                probability += (float)(40 - this.timeUntilLured) * 0.02f;
            } else if (this.timeUntilLured < 60) {
                probability += (float)(60 - this.timeUntilLured) * 0.01f;
            }
            if (this.f_19796_.m_188501_() < probability) {
                float randomRot = Mth.m_216267_((RandomSource)this.f_19796_, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float randomNum = Mth.m_216267_((RandomSource)this.f_19796_, (float)25.0f, (float)60.0f);
                double x = this.m_20185_() + (double)(Mth.m_14031_((float)randomRot) * randomNum) * 0.1;
                double y = (double)Mth.m_14107_((double)this.m_20186_()) + 1.0;
                double z = this.m_20189_() + (double)(Mth.m_14089_((float)randomRot) * randomNum) * 0.1;
                BlockState blockState = level.m_8055_(BlockPos.m_274561_((double)x, (double)(y - 1.0), (double)z));
                this.spawnSplashParticle(level, blockState, x, y, z);
            }
            if (this.timeUntilLured <= 0) {
                this.fishAngle = Mth.m_216267_((RandomSource)this.f_19796_, (float)0.0f, (float)360.0f);
                this.timeUntilHooked = Mth.m_216271_((RandomSource)this.f_19796_, (int)20, (int)80);
            }
        } else {
            this.timeUntilLured = Mth.m_216271_((RandomSource)this.f_19796_, (int)100, (int)600);
            this.timeUntilLured -= this.lureSpeed * 20 * 5;
        }
    }

    protected void spawnSplashParticle(ServerLevel level, BlockState blockState, double x, double y, double z) {
        if (blockState.m_60713_(Blocks.f_49990_)) {
            level.m_8767_((ParticleOptions)ParticleTypes.f_123769_, x, y, z, 2 + this.f_19796_.m_188503_(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
        }
    }

    protected void spawnNibbleParticle(ServerLevel level) {
        double yOffset = this.m_20186_() + 0.5;
        float bbWidth = this.m_20205_();
        this.m_5496_(SoundEvents.f_11940_, 0.25f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.4f);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_(), yOffset, this.m_20189_(), (int)(1.0f + bbWidth * 20.0f), (double)bbWidth, 0.0, (double)bbWidth, (double)0.2f);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123816_, this.m_20185_(), yOffset, this.m_20189_(), (int)(1.0f + bbWidth * 20.0f), (double)bbWidth, 0.0, (double)bbWidth, (double)0.2f);
    }

    protected void spawnFishingParticle(ServerLevel level, BlockState blockState, double x, double y, double z, float sin, float cos) {
        if (blockState.m_60713_(Blocks.f_49990_)) {
            if (this.f_19796_.m_188501_() < 0.15f) {
                level.m_8767_((ParticleOptions)ParticleTypes.f_123795_, x, y - 0.1, z, 1, (double)sin, 0.1, (double)cos, 0.0);
            }
            float sinOffset = sin * 0.04f;
            float cosOffset = cos * 0.04f;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123816_, x, y, z, 0, (double)cosOffset, 0.01, (double)(-sinOffset), 1.0);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123816_, x, y, z, 0, (double)(-cosOffset), 0.01, (double)sinOffset, 1.0);
        }
    }

    protected void onNibble(ServerLevel level) {
        EntityMaid maid = this.getMaidOwner();
        int retrieveTime = Mth.m_216271_((RandomSource)this.f_19796_, (int)2, (int)10);
        if (this.nibble <= retrieveTime && maid != null) {
            ItemStack rodItem = maid.m_21205_();
            int rodDamage = this.retrieve(rodItem);
            this.hurtRod(maid, rodItem, rodDamage);
            maid.m_6674_(InteractionHand.MAIN_HAND);
            level.m_6263_(null, maid.m_20185_(), maid.m_20186_(), maid.m_20189_(), SoundEvents.f_11939_, SoundSource.NEUTRAL, 1.0f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
        }
    }

    public int retrieve(ItemStack stack) {
        EntityMaid maid = this.getMaidOwner();
        if (!this.f_19853_.f_46443_ && maid != null && !this.shouldStopFishing(maid)) {
            MaidFishedEvent event = null;
            MinecraftServer server = this.f_19853_.m_7654_();
            int rodDamage = 0;
            if (this.nibble > 0 && server != null) {
                ServerLevel serverLevel = (ServerLevel)this.f_19853_;
                LootParams lootParams = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81463_, (Object)stack).m_287286_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81458_, (Object)maid).m_287239_((float)this.luck + maid.getLuck()).m_287235_(LootContextParamSets.f_81414_);
                List<ItemStack> randomItems = this.getLoot(server, lootParams);
                this.addExtraLoot(randomItems);
                event = new MaidFishedEvent(randomItems, this.m_20096_() ? 2 : 1, this);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.isCanceled()) {
                    this.m_146870_();
                    return event.getRodDamage();
                }
                this.spawnLoot(randomItems, maid);
                this.afterFishing();
                rodDamage = 1;
            }
            if (this.m_20096_()) {
                rodDamage = 2;
            }
            this.m_146870_();
            return event == null ? rodDamage : event.getRodDamage();
        }
        return 0;
    }

    @NotNull
    protected List<ItemStack> getLoot(MinecraftServer server, LootParams lootParams) {
        LootTable lootTable = server.m_278653_().m_278676_(BuiltInLootTables.f_78720_);
        return lootTable.m_287195_(lootParams);
    }

    protected void spawnLoot(List<ItemStack> randomItems, EntityMaid maid) {
        LivingEntity livingEntity;
        EntityMaid maidOwner = this.getMaidOwner();
        ServerPlayer serverPlayer = null;
        if (maidOwner != null && (livingEntity = maidOwner.m_269323_()) instanceof ServerPlayer) {
            ServerPlayer serverPlayerIn;
            serverPlayer = serverPlayerIn = (ServerPlayer)livingEntity;
        }
        for (ItemStack result : randomItems) {
            if (serverPlayer != null && result.m_150930_(Items.f_42690_)) {
                InitTrigger.MAID_EVENT.trigger(serverPlayer, "maid_fishing_enchanted_book");
            }
            ItemEntity itemEntity = new ItemEntity(this.m_9236_(), maid.m_20185_(), maid.m_20186_() + 0.5, maid.m_20189_(), result);
            itemEntity.m_20334_(0.0, 0.1, 0.0);
            this.f_19853_.m_7967_((Entity)itemEntity);
            this.f_19853_.m_7967_((Entity)new ExperienceOrb(maid.m_9236_(), maid.m_20185_(), maid.m_20186_() + 0.5, maid.m_20189_(), this.f_19796_.m_188503_(6) + 1));
        }
    }

    protected void addExtraLoot(List<ItemStack> randomItems) {
    }

    protected void afterFishing() {
        LivingEntity livingEntity;
        EntityMaid maidOwner = this.getMaidOwner();
        if (maidOwner != null && (livingEntity = maidOwner.m_269323_()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            InitTrigger.MAID_EVENT.trigger(serverPlayer, "maid_fishing");
        }
    }

    protected void hurtRod(EntityMaid maid, ItemStack rodItem, int rodDamage) {
        rodItem.m_41622_(rodDamage, (LivingEntity)maid, m -> maid.sendItemBreakMessage(rodItem));
    }

    private boolean calculateOpenWater(BlockPos pos) {
        OpenWaterType openWaterType = OpenWaterType.INVALID;
        for (int y = -1; y <= 2; ++y) {
            OpenWaterType openWaterTypeForArea = this.getOpenWaterTypeForArea(pos.m_7918_(-2, y, -2), pos.m_7918_(2, y, 2));
            switch (openWaterTypeForArea) {
                case INVALID: {
                    return false;
                }
                case ABOVE_WATER: {
                    if (openWaterType != OpenWaterType.INVALID) break;
                    return false;
                }
                case INSIDE_WATER: {
                    if (openWaterType != OpenWaterType.ABOVE_WATER) break;
                    return false;
                }
            }
            openWaterType = openWaterTypeForArea;
        }
        return true;
    }

    private OpenWaterType getOpenWaterTypeForArea(BlockPos firstPos, BlockPos secondPos) {
        return BlockPos.m_121990_((BlockPos)firstPos, (BlockPos)secondPos).map(this::getOpenWaterTypeForBlock).reduce((firstType, secondType) -> firstType == secondType ? firstType : OpenWaterType.INVALID).orElse(OpenWaterType.INVALID);
    }

    private OpenWaterType getOpenWaterTypeForBlock(BlockPos blockPos) {
        BlockState blockState = this.f_19853_.m_8055_(blockPos);
        if (!blockState.m_60795_() && !blockState.m_60713_(Blocks.f_50196_)) {
            FluidState fluidState = blockState.m_60819_();
            return fluidState.m_205070_(FluidTags.f_13131_) && fluidState.m_76170_() && blockState.m_60812_((BlockGetter)this.m_9236_(), blockPos).m_83281_() ? OpenWaterType.INSIDE_WATER : OpenWaterType.INVALID;
        }
        return OpenWaterType.ABOVE_WATER;
    }

    public boolean isOpenWaterFishing() {
        return this.openWater;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        this.updateOwnerInfo(null);
        super.m_142687_(reason);
    }

    public void m_142036_() {
        this.updateOwnerInfo(null);
    }

    public void m_5602_(@Nullable Entity owner) {
        super.m_5602_(owner);
        this.updateOwnerInfo(this);
    }

    private void updateOwnerInfo(@Nullable MaidFishingHook fishingHook) {
        EntityMaid maid = this.getMaidOwner();
        if (maid != null) {
            maid.fishing = fishingHook;
        }
    }

    @Nullable
    public EntityMaid getMaidOwner() {
        Entity entity = this.m_19749_();
        return entity instanceof EntityMaid ? (EntityMaid)entity : null;
    }

    private boolean shouldStopFishing(EntityMaid maid) {
        boolean hasVehicle;
        ItemStack mainHandItem = maid.m_21205_();
        boolean hasFishingRod = mainHandItem.canPerformAction(ToolActions.FISHING_ROD_CAST);
        boolean isFishingTask = maid.getTask() instanceof TaskFishing;
        boolean bl = hasVehicle = maid.m_20202_() != null;
        if (!maid.m_213877_() && maid.m_6084_() && hasVehicle && isFishingTask && hasFishingRod && this.m_20280_((Entity)maid) < 256.0) {
            return false;
        }
        this.m_146870_();
        return true;
    }

    protected void m_7380_(CompoundTag compound) {
    }

    protected void m_7378_(CompoundTag compound) {
    }

    public boolean m_6072_() {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        Entity entity = this.m_19749_();
        return new ClientboundAddEntityPacket((Entity)this, entity == null ? this.m_19879_() : entity.m_19879_());
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        if (this.getMaidOwner() == null) {
            int dataId = packet.m_131509_();
            TouhouLittleMaid.LOGGER.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.f_19853_.m_6815_(dataId), (Object)dataId);
            this.m_6074_();
        }
    }

    protected static enum FishHookState {
        FLYING,
        BOBBING;

    }

    protected static enum OpenWaterType {
        ABOVE_WATER,
        INSIDE_WATER,
        INVALID;

    }
}

