/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.container.config;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.site.ClientAvailableSitesSync;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.extensions.IForgeMenuType;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class MaidAIChatConfigContainer
extends AbstractMaidContainer {
    public static final MenuType<MaidAIChatConfigContainer> TYPE = IForgeMenuType.create(MaidAIChatConfigContainer::create);
    private static final int PLAYER_INVENTORY_SIZE = 27;
    private final CompoundTag configData;
    private final Map<String, Map<String, String>> llmSites;
    private final Map<String, Map<String, String>> ttsSites;

    public MaidAIChatConfigContainer(int id, Inventory inventory, int entityId, @Nullable CompoundTag configData, Map<String, Map<String, String>> llmSites, Map<String, Map<String, String>> ttsSites) {
        super(TYPE, id, inventory, entityId);
        this.configData = configData;
        this.llmSites = llmSites;
        this.ttsSites = ttsSites;
    }

    public static MenuProvider create(final EntityMaid maid) {
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Maid AI Chat Config Container");
            }

            public AbstractContainerMenu m_7208_(int index, Inventory playerInventory, Player player) {
                int entityId = maid.m_19879_();
                CompoundTag configData = maid.getAiChatManager().writeToTag(new CompoundTag());
                return new MaidAIChatConfigContainer(index, playerInventory, entityId, configData, ClientAvailableSitesSync.getClientLLMSites(), ClientAvailableSitesSync.getClientTTSSites());
            }
        };
    }

    @NotNull
    private static MaidAIChatConfigContainer create(int windowId, Inventory inv, FriendlyByteBuf data) {
        int entityId = data.readInt();
        CompoundTag configData = data.m_130260_();
        Pair<Map<String, Map<String, String>>, Map<String, Map<String, String>>> sites = ClientAvailableSitesSync.readFromNetwork(data);
        return new MaidAIChatConfigContainer(windowId, inv, entityId, configData, (Map)sites.getLeft(), (Map)sites.getRight());
    }

    public CompoundTag getConfigData() {
        return this.configData;
    }

    public Map<String, Map<String, String>> getLLMSites() {
        return this.llmSites;
    }

    public Map<String, Map<String, String>> getTTSSites() {
        return this.ttsSites;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack stack1 = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stack2 = slot.m_7993_();
            stack1 = stack2.m_41777_();
            if (index < 27 ? !this.m_38903_(stack2, 27, this.f_38839_.size(), false) : !this.m_38903_(stack2, 0, 27, true)) {
                return ItemStack.f_41583_;
            }
            if (stack2.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return stack1;
    }
}

