/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity.TileEntityItemStackGarageKitRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.compat.ysm.YsmCompat;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.YsmMaidInfo;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemGarageKit
extends BlockItem {
    private static final String ENTITY_INFO = "EntityInfo";
    private static final String DEFAULT_ENTITY_ID = "touhou_little_maid:maid";
    private static final String DEFAULT_MODEL_ID = "touhou_little_maid:hakurei_reimu";
    private static final String ENTITY_ID_TAG_NAME = "id";
    private static final CompoundTag DEFAULT_DATA = ItemGarageKit.getDefaultData();

    public ItemGarageKit() {
        super((Block)InitBlocks.GARAGE_KIT.get(), new Item.Properties().m_41487_(1));
    }

    private static boolean hasMaidData(ItemStack stack) {
        return stack.m_41782_() && !Objects.requireNonNull(stack.m_41783_()).m_128469_(ENTITY_INFO).m_128456_();
    }

    public static CompoundTag getMaidData(ItemStack stack) {
        if (ItemGarageKit.hasMaidData(stack)) {
            return Objects.requireNonNull(stack.m_41783_()).m_128469_(ENTITY_INFO);
        }
        return DEFAULT_DATA;
    }

    private static CompoundTag getDefaultData() {
        CompoundTag data = new CompoundTag();
        data.m_128359_(ENTITY_ID_TAG_NAME, DEFAULT_ENTITY_ID);
        data.m_128359_("ModelId", DEFAULT_MODEL_ID);
        data.m_128379_("IsYsmModel", false);
        return data;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component m_7626_(ItemStack stack) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            YsmMaidInfo ysmMaidInfo;
            MutableComponent prefix = Component.m_237115_((String)"block.touhou_little_maid.garage_kit.prefix");
            CompoundTag data = ItemGarageKit.getMaidData(stack);
            String entityId = data.m_128461_(ENTITY_ID_TAG_NAME);
            if (!entityId.equals(DEFAULT_ENTITY_ID)) {
                EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(entityId));
                if (entityType != null) {
                    return prefix.m_7220_(entityType.m_20676_());
                }
                return super.m_7626_(stack);
            }
            if (YsmCompat.isInstalled() && (ysmMaidInfo = YsmCompat.getYsmMaidInfo(data)).isYsmModel()) {
                MutableComponent name = ysmMaidInfo.name();
                if (name == null || name.equals((Object)Component.m_237119_())) {
                    return prefix.m_130946_(ysmMaidInfo.modelId());
                }
                return prefix.m_7220_((Component)name);
            }
            String modelId = data.m_128461_("ModelId");
            MaidModelInfo info = CustomPackLoader.MAID_MODELS.getInfo(modelId).orElse(null);
            if (info != null) {
                return prefix.m_7220_((Component)ParseI18n.parse(info.getName()));
            }
            return super.m_7626_(stack);
        }
        return super.m_7626_(stack);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                Minecraft minecraft = Minecraft.m_91087_();
                return new TileEntityItemStackGarageKitRenderer(minecraft.m_167982_(), minecraft.m_167973_());
            }
        });
    }
}

