/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityModelSwitcher;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ItemModelSwitcher
extends BlockItem {
    private static final String STORAGE_DATA_TAG = "StorageData";
    private static final String FORGE_DATA_TAG = "ForgeData";

    public ItemModelSwitcher() {
        super((Block)InitBlocks.MODEL_SWITCHER.get(), new Item.Properties().m_41487_(1));
    }

    public static ItemStack tileEntityToItemStack(TileEntityModelSwitcher switcher) {
        ItemStack stack = ((Item)InitItems.MODEL_SWITCHER.get()).m_7968_();
        CompoundTag stackTag = stack.m_41784_();
        stackTag.m_128365_(STORAGE_DATA_TAG, (Tag)switcher.m_187482_());
        return stack;
    }

    public static void itemStackToTileEntity(ItemStack stack, TileEntityModelSwitcher switcher) {
        CompoundTag tag = stack.m_41698_(STORAGE_DATA_TAG);
        if (tag.m_128425_(FORGE_DATA_TAG, 10)) {
            switcher.m_142466_(tag);
        }
    }

    public InteractionResult m_6880_(ItemStack pStack, Player pPlayer, LivingEntity pInteractionTarget, InteractionHand pUsedHand) {
        if (pInteractionTarget instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)pInteractionTarget;
            CompoundTag tag = pStack.m_41698_(STORAGE_DATA_TAG);
            CompoundTag forgeData = tag.m_128425_(FORGE_DATA_TAG, 10) ? tag.m_128469_(FORGE_DATA_TAG) : new CompoundTag();
            forgeData.m_128365_("entity_uuid", (Tag)NbtUtils.m_129226_((UUID)maid.m_20148_()));
            tag.m_128365_(FORGE_DATA_TAG, (Tag)forgeData);
            return InteractionResult.SUCCESS;
        }
        return super.m_6880_(pStack, pPlayer, pInteractionTarget, pUsedHand);
    }

    private boolean hasMaidInfo(ItemStack stack) {
        CompoundTag tag = stack.m_41737_(STORAGE_DATA_TAG);
        if (tag != null && tag.m_128425_(FORGE_DATA_TAG, 10)) {
            CompoundTag forgeTag = tag.m_128469_(FORGE_DATA_TAG);
            return forgeTag.m_128425_("entity_uuid", 11);
        }
        return false;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        if (this.hasMaidInfo(pStack)) {
            pTooltip.add((Component)Component.m_237115_((String)"tooltips.touhou_little_maid.model_switcher.bounded").m_130940_(ChatFormatting.GRAY));
        } else {
            pTooltip.add((Component)Component.m_237115_((String)"gui.touhou_little_maid.model_switcher.uuid.empty").m_130940_(ChatFormatting.DARK_RED));
        }
    }
}

