/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.vorbis;

import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.HighLevelOggStreamPacket;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.IOUtils;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.OggPacket;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.audio.OggAudioTagsHeader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VorbisStyleComments
extends HighLevelOggStreamPacket
implements OggAudioTagsHeader {
    public static final String KEY_ARTIST = "artist";
    public static final String KEY_ALBUM = "album";
    public static final String KEY_TITLE = "title";
    public static final String KEY_GENRE = "genre";
    public static final String KEY_TRACKNUMBER = "tracknumber";
    public static final String KEY_DATE = "date";
    private String vendor;
    private Map<String, List<String>> comments = new HashMap<String, List<String>>();

    public VorbisStyleComments(OggPacket pkt, int dataBeginsAt) {
        super(pkt);
        byte framingBit;
        byte[] d = pkt.getData();
        int vlen = this.getInt4(d, dataBeginsAt);
        this.vendor = IOUtils.getUTF8(d, dataBeginsAt + 4, vlen);
        int offset = dataBeginsAt + 4 + vlen;
        int numComments = this.getInt4(d, offset);
        offset += 4;
        for (int i = 0; i < numComments; ++i) {
            int len = this.getInt4(d, offset);
            String c = IOUtils.getUTF8(d, offset += 4, len);
            offset += len;
            int equals = c.indexOf(61);
            if (equals == -1) {
                System.err.println("Warning - unable to parse comment '" + c + "'");
                continue;
            }
            String tag = VorbisStyleComments.normaliseTag(c.substring(0, equals));
            String value = c.substring(equals + 1);
            this.addComment(tag, value);
        }
        if (offset < d.length && this.hasFramingBit() && (framingBit = d[offset]) == 0) {
            throw new IllegalArgumentException("Framing bit not set, invalid");
        }
    }

    public VorbisStyleComments() {
        this.vendor = "Gagravarr.org Java Vorbis Tools v0.8 20160217";
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    protected static String normaliseTag(String tag) {
        StringBuffer nt = new StringBuffer();
        for (char c : tag.toLowerCase().toCharArray()) {
            if (c < ' ' || c > '}' || c == '=') continue;
            nt.append(c);
        }
        return nt.toString();
    }

    protected String getSingleComment(String normalisedTag) {
        List<String> c = this.comments.get(normalisedTag);
        if (c != null && c.size() > 0) {
            return c.get(0);
        }
        return null;
    }

    @Override
    public String getArtist() {
        return this.getSingleComment(KEY_ARTIST);
    }

    @Override
    public String getAlbum() {
        return this.getSingleComment(KEY_ALBUM);
    }

    @Override
    public String getTitle() {
        return this.getSingleComment(KEY_TITLE);
    }

    @Override
    public String getGenre() {
        return this.getSingleComment(KEY_GENRE);
    }

    @Override
    public String getTrackNumber() {
        return this.getSingleComment(KEY_TRACKNUMBER);
    }

    @Override
    public int getTrackNumberNumeric() {
        String number = this.getTrackNumber();
        if (number == null) {
            return -1;
        }
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Override
    public String getDate() {
        return this.getSingleComment(KEY_DATE);
    }

    @Override
    public List<String> getComments(String tag) {
        List<String> c = this.comments.get(VorbisStyleComments.normaliseTag(tag));
        if (c == null) {
            return new ArrayList<String>();
        }
        return c;
    }

    public void removeComments(String tag) {
        this.comments.remove(VorbisStyleComments.normaliseTag(tag));
    }

    public void removeAllComments() {
        this.comments.clear();
    }

    public void addComment(String tag, String comment) {
        String nt = VorbisStyleComments.normaliseTag(tag);
        if (!this.comments.containsKey(nt)) {
            this.comments.put(nt, new ArrayList());
        }
        this.comments.get(nt).add(comment);
    }

    public void setComments(String tag, List<String> comments) {
        String nt = VorbisStyleComments.normaliseTag(tag);
        if (this.comments.containsKey(nt)) {
            this.comments.remove(nt);
        }
        this.comments.put(nt, comments);
    }

    @Override
    public Map<String, List<String>> getAllComments() {
        return this.comments;
    }

    protected abstract int getHeaderSize();

    protected abstract boolean hasFramingBit();

    protected abstract void populateMetadataHeader(byte[] var1, int var2);

    protected abstract void populateMetadataFooter(OutputStream var1);

    protected int getInt4(byte[] d, int offset) {
        return (int)IOUtils.getInt4(d, offset);
    }

    @Override
    public OggPacket write() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] headerPadding = new byte[this.getHeaderSize()];
            baos.write(headerPadding);
            IOUtils.writeUTF8WithLength(baos, this.vendor);
            int numComments = 0;
            for (List<String> c : this.comments.values()) {
                numComments += c.size();
            }
            IOUtils.writeInt4(baos, numComments);
            Object[] tags = this.comments.keySet().toArray(new String[this.comments.size()]);
            Arrays.sort(tags);
            for (Object tag : tags) {
                for (String value : this.comments.get(tag)) {
                    String comment = (String)tag + '=' + value;
                    IOUtils.writeUTF8WithLength(baos, comment);
                }
            }
            this.populateMetadataFooter(baos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] data = baos.toByteArray();
        this.populateMetadataHeader(data, data.length);
        this.setData(data);
        return super.write();
    }
}

