/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.client.gui.block.MaidBeaconGui;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class OpenBeaconGuiMessage {
    private final BlockPos pos;

    public OpenBeaconGuiMessage(BlockPos pos) {
        this.pos = pos;
    }

    public static void encode(OpenBeaconGuiMessage message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
    }

    public static OpenBeaconGuiMessage decode(FriendlyByteBuf buf) {
        return new OpenBeaconGuiMessage(buf.m_130135_());
    }

    public static void handle(OpenBeaconGuiMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> OpenBeaconGuiMessage.handleOpenGui(message));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleOpenGui(OpenBeaconGuiMessage message) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        BlockEntity te = mc.f_91073_.m_7702_(message.pos);
        if (mc.f_91074_ != null && mc.f_91074_.m_6084_() && te instanceof TileEntityMaidBeacon) {
            mc.m_91152_((Screen)new MaidBeaconGui((TileEntityMaidBeacon)te));
        }
    }
}

