/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.InventoryScroll;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.AbstractBackpackMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.DisabledSlot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;

public abstract class AbstractBackpackScreen<T extends AbstractBackpackMenu>
extends AbstractContainerScreen<T> {
    public static final ResourceLocation BACKGROUND_11 = new ResourceLocation("travelersbackpack", "textures/gui/background_11.png");
    public static final ResourceLocation BACKGROUND_9 = new ResourceLocation("travelersbackpack", "textures/gui/background_9.png");
    public static final ResourceLocation SLOTS = new ResourceLocation("travelersbackpack", "textures/gui/slots.png");
    public static final ResourceLocation TANKS = new ResourceLocation("travelersbackpack", "textures/gui/tanks.png");
    public static final ResourceLocation ICONS = new ResourceLocation("travelersbackpack", "textures/gui/icons.png");
    public static final ResourceLocation TABS = new ResourceLocation("travelersbackpack", "textures/gui/tabs.png");
    public static final int TOP_BAR_OFFSET = 17;
    protected int slotCount;
    protected boolean wider = false;
    public final BackpackWrapper wrapper;
    public InventoryScroll scroll = null;
    public int slotYPos;
    public boolean isScrollable = false;
    public int scrollAmount = 0;
    public static final int HEIGHT_WITHOUT_STORAGE = 114;
    public int slotsHeight;
    public int visibleSlots;
    public int visibleRows;

    protected AbstractBackpackScreen(T pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        this.wrapper = ((AbstractBackpackMenu)((Object)pMenu)).getWrapper();
        this.f_97729_ = 6;
    }

    public BackpackWrapper getWrapper() {
        return this.wrapper;
    }

    public Player getScreenPlayer() {
        return ((AbstractBackpackMenu)this.m_6262_()).player;
    }

    public Font getFont() {
        return this.f_96547_;
    }

    public void updateDimensions() {
        int guiScaledHeight = Minecraft.m_91087_().m_91268_().m_85446_();
        if (guiScaledHeight < this.f_97727_) {
            int displayableNumberOfRows = Math.min((guiScaledHeight - 114) / 18, this.getRows());
            int newImageHeight = 114 + this.calculateSlotHeight(displayableNumberOfRows);
            this.slotsHeight = this.calculateSlotHeight(displayableNumberOfRows);
            this.visibleSlots = displayableNumberOfRows * (this.slotCount > 81 ? 11 : 9);
            this.f_97727_ = newImageHeight;
            this.visibleRows = displayableNumberOfRows;
            this.isScrollable = true;
        }
    }

    public void updateBackpackSlotsPosition() {
        int allStorageSlots = ((AbstractBackpackMenu)this.f_97732_).BACKPACK_INV_END;
        if (this.isScrollable) {
            int i;
            int scrollAmount = this.scrollAmount;
            int hiddenSlotsFirst = scrollAmount * this.getSlotsInRow();
            int movedSlots = this.visibleRows * this.getSlotsInRow() - hiddenSlotsFirst;
            int revealedSlots = scrollAmount * this.getSlotsInRow();
            int lastRowSlots = this.slotCount % this.getSlotsInRow();
            if (scrollAmount == this.getMaxScrollAmount() && lastRowSlots > 0) {
                revealedSlots -= this.getSlotsInRow();
                revealedSlots += lastRowSlots;
            }
            for (int i2 = 0; i2 < hiddenSlotsFirst; ++i2) {
                ((Slot)((AbstractBackpackMenu)this.f_97732_).f_38839_.get((int)i2)).f_40221_ = -1000;
            }
            int countSlots = 0;
            for (int i3 = hiddenSlotsFirst; i3 < hiddenSlotsFirst + movedSlots; ++i3) {
                ((Slot)((AbstractBackpackMenu)this.f_97732_).f_38839_.get((int)i3)).f_40221_ = this.slotYPos + (int)Math.floor((double)countSlots / (double)this.getSlotsInRow()) * 18;
                ++countSlots;
            }
            countSlots = 0;
            int lastY = this.slotYPos + (this.visibleRows - scrollAmount) * 18;
            for (i = hiddenSlotsFirst + movedSlots; i < hiddenSlotsFirst + movedSlots + revealedSlots; ++i) {
                ((Slot)((AbstractBackpackMenu)this.f_97732_).f_38839_.get((int)i)).f_40221_ = lastY + (int)Math.floor((double)countSlots / (double)this.getSlotsInRow()) * 18;
                ++countSlots;
            }
            for (i = hiddenSlotsFirst + movedSlots + revealedSlots; i < allStorageSlots; ++i) {
                ((Slot)((AbstractBackpackMenu)this.f_97732_).f_38839_.get((int)i)).f_40221_ = -1000;
            }
        }
    }

    public void updatePlayerSlotsPosition() {
        if (this.isScrollable) {
            int i;
            int firstPlayerSlotY = 32 + this.visibleRows * 18;
            int countSlots = 0;
            for (i = ((AbstractBackpackMenu)this.f_97732_).PLAYER_INV_START; i < ((AbstractBackpackMenu)this.f_97732_).PLAYER_HOT_END - 9; ++i) {
                ((Slot)((AbstractBackpackMenu)this.f_97732_).f_38839_.get((int)i)).f_40221_ = firstPlayerSlotY + (int)Math.floor((double)countSlots / 9.0) * 18;
                ++countSlots;
            }
            for (i = ((AbstractBackpackMenu)this.f_97732_).PLAYER_HOT_END - 9; i < ((AbstractBackpackMenu)this.f_97732_).PLAYER_HOT_END; ++i) {
                ((Slot)((AbstractBackpackMenu)this.f_97732_).f_38839_.get((int)i)).f_40221_ = firstPlayerSlotY + 54 + 4;
            }
        }
    }

    public int calculateSlotHeight(int displayableRows) {
        return displayableRows * 18;
    }

    public int calculateSlotHeight(boolean wider) {
        int rowSlots = wider ? 11 : 9;
        int rows = (int)Math.ceil((double)this.slotCount / (double)rowSlots);
        return rows * 18;
    }

    public int getRows() {
        return (int)Math.ceil((double)this.slotCount / (double)this.getSlotsInRow());
    }

    public int getSlotsInRow() {
        return this.wider ? 11 : 9;
    }

    public void setScrollAmount(int scrollAmount) {
        this.scrollAmount = scrollAmount;
    }

    public int getMaxScrollAmount() {
        return (int)Math.ceil((double)this.slotCount / (double)this.getSlotsInRow()) - (int)Math.ceil((double)this.visibleSlots / (double)this.getSlotsInRow());
    }

    public void renderInventoryBackground(GuiGraphics guiGraphics, int x, int y, ResourceLocation texture, int xSize, int slotsHeight) {
        int halfSlotHeight = slotsHeight / 2;
        guiGraphics.m_280218_(texture, x, y, 0, 0, xSize, 17 + halfSlotHeight);
        int playerInventoryHeight = 98;
        guiGraphics.m_280218_(texture, x, y + 17 + halfSlotHeight, 0, 256 - (playerInventoryHeight + halfSlotHeight), xSize, playerInventoryHeight + halfSlotHeight);
    }

    public void renderSlots(GuiGraphics guiGraphics, int x, int y, int slotCount) {
        int fullRows;
        int lastSlotRow = this.slotCount % this.getSlotsInRow();
        int visibleRows = this.visibleRows;
        int n = fullRows = this.isScrollable ? visibleRows : slotCount / this.getSlotsInRow();
        if (this.isScrollable && this.scrollAmount == this.getMaxScrollAmount() && lastSlotRow > 0) {
            --fullRows;
        }
        guiGraphics.m_280218_(BackpackScreen.SLOTS, x, y, 0, 0, this.getSlotsInRow() * 18, fullRows * 18);
        if (fullRows > 9) {
            guiGraphics.m_280218_(BackpackScreen.SLOTS, x, y + 162, 0, 0, this.getSlotsInRow() * 18, (fullRows - 9) * 18);
        }
        if (lastSlotRow > 0) {
            if (this.isScrollable) {
                if (this.scrollAmount == this.getMaxScrollAmount()) {
                    guiGraphics.m_280218_(BackpackScreen.SLOTS, x, y + fullRows * 18, 0, fullRows * 18, lastSlotRow * 18, 18);
                }
            } else {
                guiGraphics.m_280218_(BackpackScreen.SLOTS, x, y + fullRows * 18, 0, 0, lastSlotRow * 18, 18);
            }
        }
    }

    public void renderLockedBackpackSlot(GuiGraphics guiGraphics) {
        Slot slot;
        if (((AbstractBackpackMenu)this.f_97732_).disabledSlotIndex > 0 && ((AbstractBackpackMenu)this.f_97732_).disabledSlotIndex < ((AbstractBackpackMenu)this.f_97732_).f_38839_.size() && (slot = ((AbstractBackpackMenu)this.f_97732_).m_38853_(((AbstractBackpackMenu)this.f_97732_).disabledSlotIndex)) instanceof DisabledSlot) {
            DisabledSlot slot2 = (DisabledSlot)slot;
            int x = this.f_97735_ + slot2.f_40220_;
            int y = this.f_97736_ + slot2.f_40221_;
            guiGraphics.m_285795_(RenderType.m_286086_(), x, y, x + 16, y + 16, 0, -9934744);
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.renderScreen(guiGraphics, x, y, mouseX, mouseY, partialTicks);
        this.drawUnsortableSlots(guiGraphics);
        this.drawMemorySlots(guiGraphics);
    }

    public abstract void renderScreen(GuiGraphics var1, int var2, int var3, int var4, int var5, float var6);

    public abstract void drawUnsortableSlots(GuiGraphics var1);

    public abstract void drawMemorySlots(GuiGraphics var1);

    public boolean m_6050_(double mouseX, double mouseY, double scrollY) {
        if (this.scroll != null) {
            return this.scroll.m_6050_(mouseX, mouseY, scrollY);
        }
        return super.m_6050_(mouseX, mouseY, scrollY);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        for (GuiEventListener child : this.m_6702_()) {
            if (!child.m_5953_(mouseX, mouseY) || !child.m_7979_(mouseX, mouseY, button, dragX, dragY)) continue;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        GuiEventListener focused = this.m_7222_();
        if (focused != null && !focused.m_5953_(mouseX, mouseY) && focused instanceof WidgetBase) {
            WidgetBase widgetBase = (WidgetBase)focused;
            widgetBase.m_93692_(false);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void sendDataToServer() {
    }

    public void playUIClickSound() {
        ((AbstractBackpackMenu)this.f_97732_).getPlayerInventory().f_35978_.m_9236_().m_5594_(((AbstractBackpackMenu)this.f_97732_).getPlayerInventory().f_35978_, ((AbstractBackpackMenu)this.f_97732_).getPlayerInventory().f_35978_.m_20183_(), (SoundEvent)SoundEvents.f_12490_.m_203334_(), SoundSource.MASTER, 0.25f, 1.0f);
    }
}

