/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import com.corosus.coroutil.util.CULog;
import com.corosus.coroutil.util.CoroUtilCompatibility;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import weather2.ClientTickHandler;
import weather2.ClientWeatherProxy;
import weather2.client.SceneEnhancer;
import weather2.command.CommandWeather2Client;
import weather2.config.ConfigDebug;
import weather2.util.WeatherUtilBlock;
import weather2.util.WeatherUtilEntity;
import weather2.weathersystem.WeatherManagerClient;
import weather2.weathersystem.wind.WindManager;

@Mod.EventBusSubscriber(modid="weather2", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EventHandlerForge {
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void worldRender(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            ClientTickHandler.getClientWeather();
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES && ConfigDebug.Particle_engine_render) {
            ClientTickHandler.particleManagerExtended().render(event.getPoseStack(), null, Minecraft.m_91087_().f_91063_.m_109154_(), event.getCamera(), event.getPartialTick(), event.getFrustum());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @OnlyIn(value=Dist.CLIENT)
    public void onFogColors(ViewportEvent.ComputeFogColor event) {
        SceneEnhancer.getFogAdjuster().onFogColors(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @OnlyIn(value=Dist.CLIENT)
    public void onFogRender(ViewportEvent.RenderFog event) {
        SceneEnhancer.getFogAdjuster().onFogRender(event);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        SceneEnhancer.renderTick(event);
    }

    @SubscribeEvent
    public void onEntityLivingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity ent = event.getEntity();
        if (ent.m_9236_().f_46443_ && ent instanceof Player && ((Player)ent).m_7578_()) {
            this.onClientPlayerUpdate(event);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        CompoundTag tag = event.getOriginal().getPersistentData();
        CompoundTag tag2 = event.getEntity().getPersistentData();
        tag2.m_128356_("lastSandstormTime", tag.m_128454_("lastSandstormTime"));
        tag2.m_128356_("lastStormDeadlyTime", tag.m_128454_("lastStormDeadlyTime"));
    }

    public void onServerPlayerUpdate(LivingEvent.LivingTickEvent event) {
        Level level = event.getEntity().m_9236_();
        if (level.m_46467_() % 40L == 0L) {
            LivingEntity ent = event.getEntity();
            Biome bgb = (Biome)level.m_204166_(WeatherUtilBlock.getPrecipitationHeightSafe(level, new BlockPos(Mth.m_14107_((double)ent.m_20182_().f_82479_), 0, Mth.m_14107_((double)ent.m_20182_().f_82481_)))).get();
            float biomeTemp = CoroUtilCompatibility.getAdjustedTemperature((Level)ent.m_9236_(), (Biome)bgb, (BlockPos)new BlockPos(Mth.m_14107_((double)ent.m_20182_().f_82479_), Mth.m_14107_((double)ent.m_20182_().f_82480_), Mth.m_14107_((double)ent.m_20182_().f_82481_)));
            CULog.dbg((String)("biomeTemp: " + biomeTemp));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onClientPlayerUpdate(LivingEvent.LivingTickEvent event) {
        float playerSpeed;
        LivingEntity ent = event.getEntity();
        WeatherManagerClient weatherMan = ClientTickHandler.weatherManager;
        if (weatherMan == null) {
            return;
        }
        WindManager windMan = weatherMan.getWindManager();
        if (windMan == null) {
            return;
        }
        ClientWeatherProxy weather = ClientWeatherProxy.get();
        if ((weather.isSnowstorm() || weather.isSandstorm()) && ent.m_20096_() && !ent.m_5833_() && !WeatherUtilEntity.isPlayerSheltered((Entity)ent) && (playerSpeed = (float)Math.sqrt(ent.m_20184_().f_82479_ * ent.m_20184_().f_82479_ + ent.m_20184_().f_82481_ * ent.m_20184_().f_82481_)) > 0.02f && playerSpeed < 0.3f) {
            float dampenRate;
            float dampen;
            float diffAngle;
            float playerAngle = -((float)Math.toDegrees(Math.atan2(ent.m_20184_().f_82479_, ent.m_20184_().f_82481_)));
            int phi = (int)(Math.abs(windMan.getWindAngle(ent.m_20182_()) - playerAngle) % 360.0f);
            float f = diffAngle = phi > 180 ? (float)(360 - phi) : (float)phi;
            if (diffAngle < 90.0f) {
                float assistRate = 1.0f - diffAngle / 90.0f;
                float assist = 1.0f + 0.12f * assistRate;
                ent.m_20334_(ent.m_20184_().f_82479_ * (double)assist, ent.m_20184_().f_82480_, ent.m_20184_().f_82481_ * (double)assist);
            } else if (diffAngle >= 90.0f && (dampen = 1.0f - 0.12f * (dampenRate = (diffAngle - 90.0f) / 90.0f)) != 0.0f) {
                ent.m_20334_(ent.m_20184_().f_82479_ * (double)dampen, ent.m_20184_().f_82480_, ent.m_20184_().f_82481_ * (double)dampen);
            }
        }
    }

    @SubscribeEvent
    public void registerCommandsClient(RegisterClientCommandsEvent event) {
        CommandWeather2Client.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

