/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.EnumMap;
import java.util.Map;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedHopperBlock;
import net.geforcemods.securitycraft.inventory.VanillaHopperInsertOnlyItemHandler;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class ReinforcedHopperBlockEntity
extends HopperBlockEntity
implements IOwnable,
IModuleInventory {
    private LazyOptional<IItemHandler> insertOnlyHandler;
    private NonNullList<ItemStack> modules = NonNullList.m_122780_((int)this.getMaxNumberOfModules(), (Object)ItemStack.f_41583_);
    private Owner owner = new Owner();
    private Map<ModuleType, Boolean> moduleStates = new EnumMap<ModuleType, Boolean>(ModuleType.class);

    public ReinforcedHopperBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public BlockEntityType<?> m_58903_() {
        return (BlockEntityType)SCContent.REINFORCED_HOPPER_BLOCK_ENTITY.get();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.owner.load(tag);
        this.modules = this.readModuleInventory(tag);
        this.moduleStates = this.readModuleStates(tag);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.owner != null) {
            this.owner.save(tag, this.needsValidation());
        }
        this.writeModuleInventory(tag);
        this.writeModuleStates(tag);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        super.onDataPacket(net, packet);
        DisguisableBlockEntity.onHandleUpdateTag(this);
    }

    public void onLoad() {
        super.onLoad();
        DisguisableBlockEntity.onOnLoad(this);
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        IModuleInventory.super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onDisguiseModuleInserted((BlockEntity)this, stack, toggled);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        IModuleInventory.super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onDisguiseModuleRemoved((BlockEntity)this, stack, toggled);
        }
    }

    public void m_7651_() {
        super.m_7651_();
        DisguisableBlockEntity.onSetRemoved((BlockEntity)this);
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
        this.m_6596_();
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : super.m_8020_(slot);
    }

    public ItemStack m_8020_(int slot) {
        return this.getStackInSlot(slot);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)((ReinforcedHopperBlock)SCContent.REINFORCED_HOPPER.get()).m_7705_());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return BlockUtils.isAllowedToExtractFromProtectedObject(side, this) ? super.getCapability(cap, side) : this.getInsertOnlyHandler().cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        if (this.insertOnlyHandler != null) {
            this.insertOnlyHandler.invalidate();
        }
        super.invalidateCaps();
    }

    public void reviveCaps() {
        this.insertOnlyHandler = null;
        super.reviveCaps();
    }

    private LazyOptional<IItemHandler> getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null) {
            this.insertOnlyHandler = LazyOptional.of(() -> new VanillaHopperInsertOnlyItemHandler(this));
        }
        return this.insertOnlyHandler;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DISGUISE};
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public boolean isModuleEnabled(ModuleType module) {
        return this.hasModule(module) && this.moduleStates.get((Object)module) == Boolean.TRUE;
    }

    @Override
    public void toggleModuleState(ModuleType module, boolean shouldBeEnabled) {
        this.moduleStates.put(module, shouldBeEnabled);
    }

    @Override
    public boolean needsValidation() {
        return true;
    }

    @Override
    public Level myLevel() {
        return this.f_58857_;
    }

    @Override
    public BlockPos myPos() {
        return this.f_58858_;
    }

    public ModelData getModelData() {
        return DisguisableBlockEntity.getModelData((BlockEntity)this);
    }
}

