/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.blockentities.ProjectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class SyncProjector {
    private BlockPos pos;
    private int data;
    private DataType dataType;

    public SyncProjector() {
    }

    public SyncProjector(BlockPos pos, int data, DataType dataType) {
        this.pos = pos;
        this.data = data;
        this.dataType = dataType;
    }

    public SyncProjector(BlockPos pos, BlockState state) {
        this.pos = pos;
        this.data = Block.m_49956_((BlockState)state);
        this.dataType = DataType.BLOCK_STATE;
    }

    public SyncProjector(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.dataType = (DataType)buf.m_130066_(DataType.class);
        this.data = this.dataType.isBoolean ? (buf.readBoolean() ? 1 : 0) : buf.m_130242_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130068_((Enum)this.dataType);
        if (this.dataType.isBoolean) {
            buf.writeBoolean(this.data == 1);
        } else {
            buf.m_130130_(this.data);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ProjectorBlockEntity be;
        BlockEntity blockEntity;
        ServerPlayer player = ctx.get().getSender();
        Level level = player.m_9236_();
        if (!player.m_5833_() && level.m_46749_(this.pos) && (blockEntity = level.m_7702_(this.pos)) instanceof ProjectorBlockEntity && (be = (ProjectorBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            BlockState state = level.m_8055_(this.pos);
            switch (this.dataType) {
                case WIDTH: {
                    be.setProjectionWidth(this.data);
                    break;
                }
                case HEIGHT: {
                    be.setProjectionHeight(this.data);
                    break;
                }
                case RANGE: {
                    be.setProjectionRange(this.data);
                    break;
                }
                case OFFSET: {
                    be.setProjectionOffset(this.data);
                    break;
                }
                case HORIZONTAL: {
                    be.setHorizontal(this.data == 1);
                    break;
                }
                case OVERRIDING_BLOCKS: {
                    be.setOverridingBlocks(this.data == 1);
                    break;
                }
                case BLOCK_STATE: {
                    be.setProjectedState(Block.m_49803_((int)this.data));
                    break;
                }
            }
            level.m_7260_(this.pos, state, state, 2);
        }
    }

    public static enum DataType {
        WIDTH,
        HEIGHT,
        RANGE,
        OFFSET,
        HORIZONTAL(true),
        OVERRIDING_BLOCKS(true),
        BLOCK_STATE,
        INVALID;

        public final boolean isBoolean;

        private DataType() {
            this(false);
        }

        private DataType(boolean isBoolean) {
            this.isBoolean = isBoolean;
        }
    }
}

