/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.ae2netanalyser.common.items;

import appeng.api.implementations.menuobjects.IMenuItem;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.security.IActionHost;
import appeng.api.parts.IPart;
import appeng.blockentity.networking.CableBusBlockEntity;
import appeng.me.InWorldGridNode;
import appeng.me.helpers.IGridConnectedBlockEntity;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import com.glodblock.github.ae2netanalyser.AEAnalyser;
import com.glodblock.github.ae2netanalyser.common.AEAItems;
import com.glodblock.github.ae2netanalyser.common.inventory.AnalyserInventory;
import com.glodblock.github.ae2netanalyser.common.me.AnalyserMode;
import com.glodblock.github.ae2netanalyser.common.me.NetworkData;
import com.glodblock.github.ae2netanalyser.common.me.netdata.FlagType;
import com.glodblock.github.ae2netanalyser.common.me.netdata.LinkFlag;
import com.glodblock.github.ae2netanalyser.common.me.netdata.NodeFlag;
import com.glodblock.github.ae2netanalyser.common.me.netdata.State;
import com.glodblock.github.ae2netanalyser.common.me.tracker.PlayerTracker;
import com.glodblock.github.ae2netanalyser.container.ContainerAnalyser;
import com.glodblock.github.ae2netanalyser.network.AEANetworkHandler;
import com.glodblock.github.ae2netanalyser.network.packets.SNetworkDataUpdate;
import com.glodblock.github.glodium.client.render.ColorData;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ItemNetworkAnalyser
extends Item
implements IMenuItem {
    public static final Reference2ObjectMap<Enum<?>, ColorData> defaultColors = new Reference2ObjectOpenHashMap();

    public ItemNetworkAnalyser() {
        super(new Item.Properties().m_41487_(1));
    }

    public AnalyserConfig getConfig(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        Reference2ObjectOpenHashMap colors = new Reference2ObjectOpenHashMap();
        float nodeSize = 0.4f;
        AnalyserMode mode = AnalyserMode.FULL;
        colors.putAll(defaultColors);
        if (tag != null) {
            ListTag colorTag = tag.m_128437_("color_config", 10);
            try {
                for (Tag t : colorTag) {
                    CompoundTag data = (CompoundTag)t;
                    FlagType type = FlagType.valueOf(data.m_128461_("type"));
                    String name = data.m_128461_("name");
                    ColorData colorData = new ColorData(data.m_128451_("color"));
                    switch (type) {
                        case LINK: {
                            colors.put((Object)LinkFlag.valueOf(name), (Object)colorData);
                            break;
                        }
                        case NODE: {
                            colors.put((Object)NodeFlag.valueOf(name), (Object)colorData);
                        }
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (tag.m_128441_("node_size")) {
                nodeSize = tag.m_128457_("node_size");
            }
            if (tag.m_128441_("mode")) {
                mode = AnalyserMode.valueOf(tag.m_128461_("mode"));
            }
        }
        return new AnalyserConfig(mode, nodeSize, (Reference2ObjectMap<Enum<?>, ColorData>)colors);
    }

    public void saveConfig(AnalyserConfig config, ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128350_("node_size", config.nodeSize);
        tag.m_128359_("mode", config.mode.name());
        ListTag colorList = new ListTag();
        for (Map.Entry entry : config.colors.entrySet()) {
            Enum type = (Enum)entry.getKey();
            ColorData color = (ColorData)entry.getValue();
            CompoundTag colorRecord = new CompoundTag();
            if (type.getClass() == LinkFlag.class) {
                colorRecord.m_128359_("type", FlagType.LINK.name());
                colorRecord.m_128359_("name", type.name());
                colorRecord.m_128405_("color", color.toARGB());
            }
            if (type.getClass() == NodeFlag.class) {
                colorRecord.m_128359_("type", FlagType.NODE.name());
                colorRecord.m_128359_("name", type.name());
                colorRecord.m_128405_("color", color.toARGB());
            }
            if (colorRecord.m_128456_()) continue;
            colorList.add((Object)colorRecord);
        }
        if (!colorList.isEmpty()) {
            tag.m_128365_("color_config", (Tag)colorList);
        }
    }

    @Nullable
    public GlobalPos getPos(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("pos")) {
            return GlobalPos.f_122633_.decode((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("pos")).resultOrPartial(Util.m_137489_((String)"Network Position", arg_0 -> ((Logger)AEAnalyser.LOGGER).error(arg_0))).map(Pair::getFirst).orElse(null);
        }
        return null;
    }

    public void savePos(ItemStack stack, GlobalPos pos) {
        GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)pos).result().ifPresent(tag -> stack.m_41784_().m_128365_("pos", tag));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player p, @NotNull InteractionHand hand) {
        if (!level.m_5776_() && !p.m_6144_()) {
            MenuOpener.open(ContainerAnalyser.TYPE, (Player)p, (MenuLocator)MenuLocators.forHand((Player)p, (InteractionHand)hand));
        }
        return new InteractionResultHolder(InteractionResult.m_19078_((boolean)level.m_5776_()), (Object)p.m_21120_(hand));
    }

    @NotNull
    public InteractionResult m_6225_(@Nonnull UseOnContext context) {
        ServerPlayer player;
        ItemStack tool;
        Player player2;
        if (!context.m_43725_().f_46443_ && (player2 = context.m_43723_()) instanceof ServerPlayer && (tool = (player = (ServerPlayer)player2).m_21205_()).m_41720_() == AEAItems.ANALYSER) {
            AEAItems.ANALYSER.savePos(tool, GlobalPos.m_122643_((ResourceKey)context.m_43725_().m_46472_(), (BlockPos)context.m_8083_()));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int slot, boolean selected) {
        IInWorldGridNodeHost host;
        GlobalPos pos;
        ServerPlayer player;
        if (!world.f_46443_ && entity instanceof ServerPlayer && stack == (player = (ServerPlayer)entity).m_21205_() && player.m_21205_().m_41720_() == AEAItems.ANALYSER && (pos = AEAItems.ANALYSER.getPos(player.m_21205_())) != null && pos.m_122640_().equals((Object)world.m_46472_()) && PlayerTracker.needUpdate((Player)player, pos) && (host = GridHelper.getNodeHost((Level)world, (BlockPos)pos.m_122646_())) != null) {
            IGridNode node = host.getGridNode(null);
            if (node == null && host instanceof IGridConnectedBlockEntity) {
                IGridConnectedBlockEntity gct = (IGridConnectedBlockEntity)host;
                node = gct.getGridNode();
            }
            if (node != null) {
                ObjectOpenHashSet connections = new ObjectOpenHashSet();
                Set<NetworkData.ANode> nodes = this.extractNodes(node.getGrid(), (Set<IGridConnection>)connections, world);
                ObjectOpenHashSet links = new ObjectOpenHashSet();
                for (IGridConnection c : connections) {
                    NetworkData.ANode a = this.wrapGridNode(c.a());
                    NetworkData.ANode b = this.wrapGridNode(c.b());
                    if (a == null || b == null || Objects.equals(a, b)) continue;
                    State<LinkFlag> state = new State<LinkFlag>(LinkFlag.NORMAL);
                    if (c.a().hasFlag(GridFlags.DENSE_CAPACITY) && c.b().hasFlag(GridFlags.DENSE_CAPACITY)) {
                        state.set(LinkFlag.DENSE);
                    }
                    if (c.a().hasFlag(GridFlags.CANNOT_CARRY_COMPRESSED) && c.b().hasFlag(GridFlags.CANNOT_CARRY_COMPRESSED)) {
                        state.set(LinkFlag.COMPRESSED);
                    }
                    links.add((Object)new NetworkData.ALink(a, b, (short)c.getUsedChannels(), state));
                }
                AEANetworkHandler.INSTANCE.sendTo(new SNetworkDataUpdate(new NetworkData(nodes.toArray(new NetworkData.ANode[0]), (NetworkData.ALink[])links.toArray((Object[])new NetworkData.ALink[0]))), player);
            }
        }
    }

    private Set<NetworkData.ANode> extractNodes(IGrid grid, Set<IGridConnection> connections, Level world) {
        if (grid != null) {
            ObjectOpenHashSet nodes = new ObjectOpenHashSet();
            for (IGridNode node : grid.getNodes()) {
                NetworkData.ANode a;
                ResourceKey dim = node.getLevel().m_46472_();
                if (!dim.equals((Object)world.m_46472_()) || (a = this.wrapGridNode(node)) == null) continue;
                connections.addAll(node.getConnections());
                nodes.add((Object)this.wrapGridNode(node));
            }
            return nodes;
        }
        return Set.of();
    }

    @Nullable
    private NetworkData.ANode wrapGridNode(IGridNode node) {
        if (node instanceof InWorldGridNode) {
            InWorldGridNode worldNode = (InWorldGridNode)node;
            BlockPos pos = worldNode.getLocation();
            State<NodeFlag> state = new State<NodeFlag>(NodeFlag.NORMAL);
            if (!this.checkChannel(worldNode)) {
                state.set(NodeFlag.MISSING);
            }
            if (node.hasFlag(GridFlags.DENSE_CAPACITY)) {
                state.set(NodeFlag.DENSE);
            }
            return new NetworkData.ANode(pos, state);
        }
        return null;
    }

    private boolean checkChannel(@NotNull InWorldGridNode node) {
        BlockPos pos;
        ServerLevel world = node.getLevel();
        BlockEntity tile = world.m_7702_(pos = node.getLocation());
        if (tile instanceof CableBusBlockEntity) {
            CableBusBlockEntity cable = (CableBusBlockEntity)tile;
            for (Direction face : Direction.values()) {
                IActionHost host;
                IPart part = cable.getPart(face);
                if (!(part instanceof IActionHost) || (host = (IActionHost)part).getActionableNode() == null || host.getActionableNode().isOnline()) continue;
                return false;
            }
            return true;
        }
        return node.isOnline();
    }

    @Nullable
    public ItemMenuHost getMenuHost(Player player, int inventorySlot, ItemStack stack, @Nullable BlockPos pos) {
        return new AnalyserInventory(player, inventorySlot, stack);
    }

    static {
        defaultColors.put((Object)NodeFlag.NORMAL, (Object)new ColorData(0.8f, 0.0f, 0.0f, 1.0f));
        defaultColors.put((Object)NodeFlag.DENSE, (Object)new ColorData(0.8f, 1.0f, 1.0f, 0.0f));
        defaultColors.put((Object)NodeFlag.MISSING, (Object)new ColorData(0.8f, 1.0f, 0.0f, 0.0f));
        defaultColors.put((Object)LinkFlag.NORMAL, (Object)new ColorData(0.8f, 0.0f, 0.0f, 1.0f));
        defaultColors.put((Object)LinkFlag.DENSE, (Object)new ColorData(0.8f, 1.0f, 1.0f, 0.0f));
        defaultColors.put((Object)LinkFlag.COMPRESSED, (Object)new ColorData(0.8f, 1.0f, 0.0f, 1.0f));
    }

    public record AnalyserConfig(AnalyserMode mode, float nodeSize, Reference2ObjectMap<Enum<?>, ColorData> colors) {
        public void writeToBytes(FriendlyByteBuf buf) {
            buf.writeByte(this.mode.ordinal());
            buf.writeFloat(this.nodeSize);
            buf.writeByte(this.colors.size());
            for (Map.Entry entry : this.colors.entrySet()) {
                Enum type = (Enum)entry.getKey();
                ColorData color = (ColorData)entry.getValue();
                if (type.getClass() == LinkFlag.class) {
                    buf.writeByte(FlagType.LINK.ordinal());
                    buf.writeByte(type.ordinal());
                    buf.writeInt(color.toARGB());
                }
                if (type.getClass() != NodeFlag.class) continue;
                buf.writeByte(FlagType.NODE.ordinal());
                buf.writeByte(type.ordinal());
                buf.writeInt(color.toARGB());
            }
        }

        public static AnalyserConfig readFromBytes(FriendlyByteBuf buf) {
            AnalyserMode mode = AnalyserMode.byIndex(buf.readByte());
            float node_size = buf.readFloat();
            Reference2ObjectOpenHashMap colors = new Reference2ObjectOpenHashMap();
            int size = buf.readByte();
            block4: for (int i = 0; i < size; ++i) {
                FlagType type = FlagType.byIndex(buf.readByte());
                byte name = buf.readByte();
                ColorData color = new ColorData(buf.readInt());
                switch (type) {
                    case LINK: {
                        colors.put((Object)LinkFlag.byIndex(name), (Object)color);
                        continue block4;
                    }
                    case NODE: {
                        colors.put((Object)NodeFlag.byIndex(name), (Object)color);
                    }
                }
            }
            return new AnalyserConfig(mode, node_size, (Reference2ObjectMap<Enum<?>, ColorData>)colors);
        }
    }
}

