/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks;

import com.endertech.minecraft.forge.client.ItemModel;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.DataCollector;
import com.endertech.minecraft.mods.adhooks.client.ControlBindings;
import com.endertech.minecraft.mods.adhooks.client.HookShotRenderer;
import com.endertech.minecraft.mods.adhooks.client.LauncherModel;
import com.endertech.minecraft.mods.adhooks.init.Entities;
import com.endertech.minecraft.mods.adhooks.init.Items;
import com.endertech.minecraft.mods.adhooks.init.Recipes;
import com.endertech.minecraft.mods.adhooks.items.HookItem;
import com.endertech.minecraft.mods.adhooks.motion.MotionControllers;
import com.endertech.minecraft.mods.adhooks.network.JumpBoostMsg;
import com.endertech.minecraft.mods.adhooks.network.MakeShotMsg;
import com.endertech.minecraft.mods.adhooks.network.TarzanJumpMsg;
import com.endertech.minecraft.mods.adhooks.network.WatchedBoolMsg;
import com.endertech.minecraft.mods.adhooks.properties.HookType;
import com.endertech.minecraft.mods.adhooks.properties.SynchronizedProperties;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod(value="adhooks")
public class AdHooks
extends AbstractForgeMod {
    public static final String ID = "adhooks";
    private static AdHooks instance;
    public final Items items;
    public final Entities entities;

    public static AdHooks getInstance() {
        return instance;
    }

    public AdHooks() {
        instance = this;
        this.items = new Items(this);
        this.entities = new Entities(this);
        this.registerCommonConfig();
        this.getForgeEventBus().addListener(MotionControllers::onServerTick);
        this.getForgeEventBus().addListener(MotionControllers::onClientTick);
        this.getForgeEventBus().addListener(this::onPlayerLoggedIn);
        this.getForgeEventBus().addListener(this::onLevelUnloaded);
    }

    public String getId() {
        return ID;
    }

    public void gatherData(DataCollector collector) {
        collector.addRecipes(Recipes::new);
    }

    public void commonInit() {
        this.registerNetMessage(WatchedBoolMsg::new);
        this.registerNetMessage(MakeShotMsg::new);
        this.registerNetMessage(JumpBoostMsg::new);
        this.registerNetMessage(TarzanJumpMsg::new);
        this.registerNetMessage(SynchronizedProperties::new);
    }

    public void commonConfigInit(AbstractForgeMod.ConfigValueBuilder value) {
        for (HookType type : HookType.values()) {
            if (type == HookType.PROTOTYPE) continue;
            value.push(type.getCategoryName());
            type.synchedProperties().forEach(props -> props.define(value));
            value.pop();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientBuildCreativeModeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            this.items.streamAll().filter(item -> {
                if (!(item instanceof HookItem)) return true;
                HookItem hook = (HookItem)((Object)item);
                if (hook.hookType != HookType.PROTOTYPE) return true;
                return false;
            }).forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).m_246326_(arg_0));
        }
    }

    public void clientRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        ControlBindings.register(event);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterRenderers() {
        this.registerEntityRender((EntityType)this.entities.hookShot.get(), HookShotRenderer::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientReplaceModels(ItemModel.RegistryWrapper registry) {
        for (HookType type : HookType.values()) {
            BakedModel hook = registry.getModelOf((Item)type.hook.item.get());
            BakedModel launcher = registry.getModelOf((Item)type.launcher.item.get());
            registry.replaceModelOf((Item)type.launcher.item.get(), (BakedModel)new LauncherModel(launcher, hook));
        }
    }

    public void configUpdated(ModConfig config) {
        if (config.getType() == ModConfig.Type.COMMON) {
            SynchronizedProperties.syncWithAllPlayersAndReload();
        }
    }

    public void tagsUpdated() {
        SynchronizedProperties.syncWithAllPlayersAndReload();
    }

    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            SynchronizedProperties.syncWithPlayer(player2);
        }
    }

    public void onLevelUnloaded(LevelEvent.Unload event) {
        SynchronizedProperties.resetToConfigValues();
    }
}

