/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.parts;

import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.properties.synched.AbstractSynchedProperty;
import com.endertech.minecraft.forge.properties.synched.IHaveSynchedProperties;
import com.endertech.minecraft.forge.properties.synched.SynchedBoolProperty;
import com.endertech.minecraft.forge.properties.synched.SynchedDoubleProperty;
import com.endertech.minecraft.forge.properties.synched.SynchedProperties;
import com.endertech.minecraft.mods.adhooks.items.HookItem;
import com.endertech.minecraft.mods.adhooks.properties.HookInteractableBlocks;
import com.endertech.minecraft.mods.adhooks.properties.HookType;
import net.minecraftforge.common.util.Lazy;

public class Hook
implements IHaveSynchedProperties {
    public final HookType type;
    public final String name;
    public final Lazy<HookItem> item;
    public final HookInteractableBlocks breakableBlocks;
    public final HookInteractableBlocks hookableBlocks;
    public final HookInteractableBlocks reboundableBlocks;
    protected SynchedBoolProperty affectsItems;
    protected SynchedBoolProperty affectsNPCs;
    protected SynchedBoolProperty affectsPlayers;
    protected SynchedDoubleProperty strength;
    protected SynchedDoubleProperty damage;
    protected SynchedDoubleProperty resistance;
    private final SynchedProperties synchedProperties = new SynchedProperties("Hook");

    public Hook(HookType type, Properties<?> props) {
        this.type = type;
        this.name = props.name;
        this.item = Lazy.of(() -> new HookItem(type, props));
        this.strength = this.synchedProperty("strength", props.strength, FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(20.0f)), "Maximum load the hook can withstand");
        this.damage = this.synchedProperty("damage", props.damage, FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(100.0f)), "Damage dealt to an entity on impact");
        this.resistance = this.synchedProperty("resistance", props.resistance, FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(60.0f)), "Amount of time (in seconds) the hook can withstand fire");
        this.affectsItems = this.synchedProperty("affectsItems", props.affectsItems, "Controls interaction with dropped items on the ground");
        this.affectsNPCs = this.synchedProperty("affectsNPCs", props.affectsNPCs, "Controls interaction with non-playable characters");
        this.affectsPlayers = this.synchedProperty("affectsPlayers", props.affectsPlayers, "Controls interaction with players");
        this.breakableBlocks = (HookInteractableBlocks)this.getSynchedProperties().add((AbstractSynchedProperty)new HookInteractableBlocks("breakableBlocks", props.breakableBlocks, "Blocks that will be broken when hit by this hook"));
        this.hookableBlocks = (HookInteractableBlocks)this.getSynchedProperties().add((AbstractSynchedProperty)new HookInteractableBlocks("hookableBlocks", props.hookableBlocks, "Blocks this hook can be attached to.\nWorks as a whitelist. If anything is specified here, the hook will attach only to these blocks"));
        this.reboundableBlocks = (HookInteractableBlocks)this.getSynchedProperties().add((AbstractSynchedProperty)new HookInteractableBlocks("reboundableBlocks", props.reboundableBlocks, "Blocks this hook cannot be attached to.\nWorks as a blacklist, preventing the hook from being attached to specified blocks"));
    }

    public SynchedProperties getSynchedProperties() {
        return this.synchedProperties;
    }

    public boolean affectsItems() {
        return (Boolean)this.affectsItems.getValue();
    }

    public boolean affectsNPCs() {
        return (Boolean)this.affectsNPCs.getValue();
    }

    public boolean affectsPlayers() {
        return (Boolean)this.affectsPlayers.getValue();
    }

    public float getStrength() {
        return ((Double)this.strength.getValue()).floatValue();
    }

    public float getDamage() {
        return ((Double)this.damage.getValue()).floatValue();
    }

    public float getResistance() {
        return ((Double)this.resistance.getValue()).floatValue();
    }

    public static class Properties<T extends Properties<T>>
    extends ForgeItem.Properties<T> {
        public boolean affectsItems = true;
        public boolean affectsNPCs = true;
        public boolean affectsPlayers = true;
        public String[] breakableBlocks = new String[0];
        public String[] hookableBlocks = new String[0];
        public String[] reboundableBlocks = new String[0];
        public float strength;
        public float damage;
        public float resistance;

        public static Properties<?> of(String name) {
            return new Properties<Properties>(Properties.class, name);
        }

        protected Properties(Class<T> selfClass, String name) {
            super(selfClass, name);
        }

        public T breakableBlocks(String ... blocks) {
            this.breakableBlocks = blocks;
            return (T)((Object)((Properties)this.self));
        }

        public T hookableBlocks(String ... blocks) {
            this.hookableBlocks = blocks;
            return (T)((Object)((Properties)this.self));
        }

        public T reboundableBlocks(String ... blocks) {
            this.reboundableBlocks = blocks;
            return (T)((Object)((Properties)this.self));
        }

        public T ignoreItems() {
            this.affectsItems = false;
            return (T)((Object)((Properties)this.self));
        }

        public T ignoreNPCs() {
            this.affectsNPCs = false;
            return (T)((Object)((Properties)this.self));
        }

        public T ignorePlayers() {
            this.affectsPlayers = false;
            return (T)((Object)((Properties)this.self));
        }

        public T strength(float value) {
            this.strength = value;
            return (T)((Object)((Properties)this.self));
        }

        public T damage(float value) {
            this.damage = value;
            return (T)((Object)((Properties)this.self));
        }

        public T resistance(float value) {
            this.resistance = value;
            return (T)((Object)((Properties)this.self));
        }
    }
}

