/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.deposit;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.Names;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.mods.adlods.AdLods;
import com.endertech.minecraft.mods.adlods.deposit.Deposit;
import com.endertech.minecraft.mods.adlods.deposit.DepositSample;
import com.endertech.minecraft.mods.adlods.deposit.Flowers;
import com.endertech.minecraft.mods.adlods.ore.AbstractOre;
import com.endertech.minecraft.mods.adlods.target.AbstractTarget;
import com.endertech.minecraft.mods.adlods.target.AbstractTargetGenerator;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.world.BiomeModifier;

public class DepositGenerator
extends AbstractTargetGenerator<Deposit> {
    public static ForgeConfigSpec.ConfigValue<DisabledDeposits> disabledDeposits;

    public DepositGenerator(AbstractForgeMod mod) {
        super(mod, "Deposits");
    }

    static String withOreSuffix(String name) {
        return Names.registry().join(new String[]{name, "ore"});
    }

    @Override
    protected Deposit createTarget(UnitConfig config, String name) {
        return new Deposit(config, Deposit.Properties.overworld(name));
    }

    @Override
    protected void createDefaultTargets(Path dir) {
        if (dir.toFile().exists()) {
            return;
        }
        DepositSample sample = new DepositSample(new Deposit.Size(900, 1800), new Deposit.Altitude(0, 80), new Deposit.Rarity(800, 2400));
        this.createVanillaDeposit(dir, "coal", sample, 1.0f, Flowers.circles(Flowers.GlowRose.BLACK_DIAMOND, Flowers.Mystical.BLACK, Flowers.Vanilla.LARGE_FERN));
        Deposit.in(dir, (Deposit.Properties)((Object)((Deposit.Properties)((Object)((AbstractOre.Properties)((Object)((Deposit.Properties)((Object)((Deposit.Properties)((Object)((AbstractOre.Properties)((Object)Deposit.Properties.overworld("gas_pocket").size(50, 500))).altitude(4, 64))).rarity(1000))).ores("adpother:carbon:[density=heavy], 50", "adpother:sulfur:[density=heavy], 1"))).replaceableBlocks("#minecraft:stone_ore_replaceables", "air:*"))).exposed(false)));
        sample = new DepositSample(new Deposit.Size(700, 1400), new Deposit.Altitude(16, 64), new Deposit.Rarity(1000, 3000));
        this.createVanillaDeposit(dir, "iron", sample.withAltitude(-64, 64), 1.0f, Flowers.circles(Flowers.GlowRose.CITRINE, Flowers.Mystical.BROWN, Flowers.Vanilla.ORANGE_TULIP, Flowers.Metal.CHEAP));
        this.createCustomDeposit(dir, "aluminum", sample, 6.6f, Flowers.circles(Flowers.GlowRose.MOONSTONE, Flowers.Mystical.LIGHT_GRAY, Flowers.Vanilla.LILY_OF_THE_VALLEY, Flowers.Metal.CHEAP));
        this.createCustomDeposit(dir, "lead", sample, 7.0f, Flowers.circles(Flowers.GlowRose.ONYX, Flowers.Mystical.GRAY, Flowers.Vanilla.AZURE_BLUET, Flowers.Metal.CHEAP));
        this.createCustomDeposit(dir, "zinc", sample, 10.3f, Flowers.circles(Flowers.GlowRose.EUCLAUSE, Flowers.Mystical.LIGHT_BLUE, Flowers.Vanilla.BLUE_ORCHID, Flowers.Metal.NORMAL));
        this.createVanillaDeposit(dir, "copper", sample.withAltitude(-16, 64), 22.6f, Flowers.circles(Flowers.GlowRose.SPINEL, Flowers.Mystical.ORANGE, Flowers.Vanilla.ORANGE_TULIP, Flowers.Metal.NORMAL));
        this.createCustomDeposit(dir, "nickel", sample, 44.6f, Flowers.circles(Flowers.GlowRose.OPAL, Flowers.Mystical.WHITE, Flowers.Vanilla.LILY_OF_THE_VALLEY, Flowers.Metal.NORMAL));
        this.createCustomDeposit(dir, "tin", sample, 74.8f, Flowers.circles(Flowers.GlowRose.ZIRCON, Flowers.Mystical.YELLOW, Flowers.Vanilla.OXEYE_DAISY, Flowers.Metal.NORMAL));
        this.createCustomDeposit(dir, "cobalt", sample, 104.7f, Flowers.circles(Flowers.GlowRose.BENITOITE, Flowers.Mystical.BLUE, Flowers.Vanilla.CORNFLOWER, Flowers.Metal.NORMAL));
        sample = new DepositSample(new Deposit.Size(500, 1000), new Deposit.Altitude(8, 32), new Deposit.Rarity(1200, 3600));
        this.createCustomDeposit(dir, "silver", sample, 1.0f, Flowers.circles(Flowers.GlowRose.MOONSTONE, Flowers.Mystical.GRAY, Flowers.Vanilla.AZURE_BLUET, Flowers.Metal.PRECIOUS));
        this.createCustomDeposit(dir, "ruthenium", sample, 17.45f, Flowers.circles(Flowers.GlowRose.MOONSTONE, Flowers.Mystical.LIGHT_GRAY, Flowers.Vanilla.LILY_OF_THE_VALLEY, Flowers.Metal.PRECIOUS));
        this.createCustomDeposit(dir, "osmium", sample, 26.2f, Flowers.circles(Flowers.GlowRose.EUCLAUSE, Flowers.Mystical.LIGHT_BLUE, Flowers.Vanilla.BLUE_ORCHID, Flowers.Metal.NORMAL));
        this.createCustomDeposit(dir, "platinum", sample, 58.89f, Flowers.circles(Flowers.GlowRose.OPAL, Flowers.Mystical.LIGHT_GRAY, Flowers.Vanilla.LILY_OF_THE_VALLEY, Flowers.Metal.PRECIOUS));
        this.createVanillaDeposit(dir, "gold", sample, 85.67f, Flowers.circles(Flowers.GlowRose.JASPER, Flowers.Mystical.ORANGE, Flowers.Vanilla.DANDELION, Flowers.Metal.PRECIOUS));
        this.createCustomDeposit(dir, "palladium", sample, 90.97f, Flowers.circles(Flowers.GlowRose.OPAL, Flowers.Mystical.WHITE, Flowers.Vanilla.WHITE_TULIP, Flowers.Metal.PRECIOUS));
        this.createCustomDeposit(dir, "iridium", sample, 97.8f, Flowers.circles(Flowers.GlowRose.ZIRCON, Flowers.Mystical.YELLOW, Flowers.Vanilla.OXEYE_DAISY, Flowers.Metal.PRECIOUS));
        this.createCustomDeposit(dir, "uranium", sample, 100.0f, Flowers.circles(Flowers.GlowRose.MALACHITE, Flowers.Mystical.LIME, Flowers.Vanilla.LILY_OF_THE_VALLEY, Flowers.Metal.PRECIOUS));
        this.createCustomDeposit(dir, "rhodium", sample, 211.94f, Flowers.circles(Flowers.GlowRose.OPAL, Flowers.Mystical.WHITE, Flowers.Vanilla.WHITE_TULIP, Flowers.Metal.PRECIOUS));
        sample = new DepositSample(new Deposit.Size(300, 600), new Deposit.Altitude(4, 16), new Deposit.Rarity(1400, 4200));
        this.createVanillaDeposit(dir, "redstone", sample.withAltitude(-32, 16), 60.0f, Flowers.circles(Flowers.GlowRose.CARNELIAN, Flowers.Mystical.RED, Flowers.Vanilla.POPPY));
        this.createVanillaDeposit(dir, "lapis", sample.withAltitude(-32, 16), 80.0f, Flowers.circles(Flowers.GlowRose.BENITOITE, Flowers.Mystical.BLUE, Flowers.Vanilla.CORNFLOWER));
        this.createVanillaDeposit(dir, "diamond", sample.withAltitude(-64, 16), 100.0f, Flowers.circles(Flowers.GlowRose.FLUORITE, Flowers.Mystical.CYAN, Flowers.Vanilla.BLUE_ORCHID));
        this.createCustomDeposit(dir, "amethyst", sample, 70.0f, Flowers.circles(Flowers.GlowRose.AMETHYST, Flowers.Mystical.PURPLE, Flowers.Vanilla.PINK_TULIP));
        this.createCustomDeposit(dir, "sapphire", sample, 80.0f, Flowers.circles(Flowers.GlowRose.SAPPHIRE, Flowers.Mystical.BLUE, Flowers.Vanilla.CORNFLOWER));
        this.createCustomDeposit(dir, "ruby", sample, 90.0f, Flowers.circles(Flowers.GlowRose.RUBY, Flowers.Mystical.RED, Flowers.Vanilla.RED_TULIP));
        this.createCustomDeposit(dir, "topaz", sample, 100.0f, Flowers.circles(Flowers.GlowRose.TOPAZ, Flowers.Mystical.ORANGE, Flowers.Vanilla.ORANGE_TULIP));
        this.createVanillaDeposit(dir, "emerald", sample.withAltitude(-16, 16), 110.0f, Flowers.circles(Flowers.GlowRose.PHOSPHOPHYLLITE, Flowers.Mystical.LIME, Flowers.Vanilla.WHITE_TULIP));
        this.createVanillaNetherDeposit(dir, "ancient_debris", new Deposit.Size(250, 500), 1800, false, new String[]{"minecraft:brown_mushroom, 3", "minecraft:brown_mushroom, 6"});
        this.createVanillaNetherDeposit(dir, "nether_gold", new Deposit.Size(500, 1000), 600, true, new String[0]);
        this.createVanillaNetherDeposit(dir, "nether_quartz", new Deposit.Size(700, 1400), 400, true, new String[0]);
    }

    public Deposit createVanillaNetherDeposit(Path dir, String name, Deposit.Size size, int rarity, boolean exposed, String[] indicators) {
        String[] ores = new String[]{name.startsWith("nether") ? DepositGenerator.withOreSuffix(name) : name};
        return Deposit.in(dir, (Deposit.Properties)((Object)((Deposit.Properties)((Object)((AbstractOre.Properties)((Object)((Deposit.Properties)((Object)((Deposit.Properties)((Object)((AbstractOre.Properties)((Object)((Deposit.Properties)((Object)Deposit.Properties.nether(name).vanilla())).size(size.getMin(), size.getMax()))).altitude(8, 118))).rarity(rarity))).ores(ores))).exposed(exposed))).indicators(indicators)));
    }

    public Deposit createVanillaDeposit(Path dir, String name, DepositSample sample, float priceFactor, String[] indicators) {
        String ore = DepositGenerator.withOreSuffix(name);
        float factor = new Percentage(priceFactor).toFraction();
        return Deposit.in(dir, (Deposit.Properties)((Object)((Deposit.Properties)((Object)((AbstractOre.Properties)((Object)((Deposit.Properties)((Object)((Deposit.Properties)((Object)((AbstractOre.Properties)((Object)((Deposit.Properties)((Object)Deposit.Properties.overworld(name).vanilla())).size(sample.size().getMin(), sample.size().getMax()))).altitude(sample.altitude().getMin(), sample.altitude().getMax()))).rarity(sample.getRarity(factor)))).ores(ore))).deepslate(ore))).indicators(indicators)));
    }

    public Deposit createCustomDeposit(Path dir, String name, DepositSample sample, float priceFactor, String[] indicators) {
        float factor = new Percentage(priceFactor).toFraction();
        return this.createCustomDeposit(dir, name, sample.size(), sample.altitude(), sample.getRarity(factor), indicators);
    }

    public Deposit createCustomDeposit(Path dir, String name, Deposit.Size size, Deposit.Altitude altitude, int rarity, String[] indicators) {
        return this.createCustomDeposit(dir, name, size, altitude, rarity, new String[]{"#forge:ores/" + name}, indicators);
    }

    public Deposit createCustomDeposit(Path dir, String name, Deposit.Size size, Deposit.Altitude altitude, int rarity, String[] ores, String[] indicators) {
        return Deposit.in(dir, (Deposit.Properties)((Object)((AbstractTarget.Properties)((Object)((Deposit.Properties)((Object)((Deposit.Properties)((Object)((AbstractOre.Properties)((Object)Deposit.Properties.deposit(name).size(size.getMin(), size.getMax()))).altitude(altitude.getMin(), altitude.getMax()))).rarity(rarity))).ores(ores))).indicators(indicators)));
    }

    @Override
    public boolean addTarget(Deposit deposit) {
        switch ((DisabledDeposits)((Object)disabledDeposits.get())) {
            case VANILLA: {
                if (!deposit.isVanilla()) break;
                return false;
            }
            case CUSTOM: {
                if (deposit.isVanilla()) break;
                return false;
            }
            case ALL: {
                return false;
            }
        }
        return super.addTarget(deposit);
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)AdLods.getInstance().codecs.depositGenerator.get();
    }

    public static enum DisabledDeposits {
        NONE,
        VANILLA,
        CUSTOM,
        ALL;

    }
}

