/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.ore;

import com.endertech.common.CommonCollect;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.BlockStatesMap;
import com.endertech.minecraft.forge.blocks.BlockStatesSet;
import com.endertech.minecraft.forge.configs.AbstractParsableList;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.Parsers;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adlods.AdLods;
import com.endertech.minecraft.mods.adlods.ore.WeightedOre;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractOrePlacements
extends AbstractParsableList
implements IHaveConfig {
    public static final String SYNTAX = "     Syntax:\n          Block: blockId\n          Block with weight: blockId, weight\n          Replacement: targetId -> replacementId\n          Replacement with weight: targetId -> replacementId, weight\n";
    protected final Parsers.UnitId_OptInteger oreParser = new Parsers.UnitId_OptInteger(IntBounds.INTEGER_POSITIVE, ",");
    protected final Function<UnitId, Optional<BlockState>> oreMapper;
    protected final BlockStatesSet replaceableBlocks;
    protected final BlockStatesMap<CommonCollect.WeightedList<WeightedOre>> replacements;
    protected final CommonCollect.WeightedList<WeightedOre> ores;
    protected final Set<Block> oreBlocks;

    protected AbstractOrePlacements(UnitConfig config, String category, String key, String[] defaultPlacements, BlockStatesSet replaceableBlocks, Function<UnitId, Optional<BlockState>> oreMapper) {
        super(config, category, key, defaultPlacements);
        this.oreMapper = oreMapper;
        this.replaceableBlocks = replaceableBlocks;
        this.replacements = new BlockStatesMap();
        this.ores = new CommonCollect.WeightedList();
        this.oreBlocks = new HashSet<Block>();
    }

    public UnitConfig getConfig() {
        return this.config;
    }

    public boolean isReplaceable(BlockState state) {
        return this.replaceableBlocks.contains((Object)state) || this.replacements.containsKey((Object)state);
    }

    public boolean isReplaceableBlock(Block block) {
        return this.replaceableBlocks.contains((Object)block) || this.replacements.containsKey((Object)block);
    }

    public Set<Block> getOreBlocks() {
        return Collections.unmodifiableSet(this.oreBlocks);
    }

    public Optional<WeightedOre> pickOreFor(BlockState replaceableBlock, Random random) {
        Optional<WeightedOre> pickedOre = Optional.ofNullable((CommonCollect.WeightedList)this.replacements.get((Object)replaceableBlock)).flatMap(ores -> ores.getRandom(random));
        if (pickedOre.isEmpty() && this.replaceableBlocks.contains((Object)replaceableBlock)) {
            pickedOre = this.pickOre(random);
        }
        return pickedOre;
    }

    public Optional<WeightedOre> pickOre(Random random) {
        return this.ores.getRandom(random);
    }

    public boolean isEmpty() {
        return (this.replaceableBlocks.isEmpty() || this.ores.isEmpty()) && this.replacements.isEmpty();
    }

    protected void parseConfigValues() {
        this.replacements.clear();
        for (String string : this.configValues) {
            List split = this.split(string, "->");
            try {
                int i = 0;
                BlockStatesSet replaceableBlocks = null;
                if (split.size() == 2) {
                    UnitId targetId = Optional.of((String)split.get(0)).map(UnitId::from).filter(UnitId::notEmpty).orElseThrow(() -> new Exception("Invalid targetId"));
                    i = 1;
                    replaceableBlocks = targetId.getAllMatchedBlockStates();
                } else if (split.size() != 1) {
                    throw new Exception("Invalid format");
                }
                UnitId oreId = this.oreParser.getId((CharSequence)split.get(i));
                int weight = this.oreParser.getInteger((CharSequence)split.get(i)).orElse(1);
                WeightedOre ore = this.oreMapper.apply(oreId).map(state -> new WeightedOre((BlockState)state, weight)).orElse(null);
                if (ore == null) continue;
                if (replaceableBlocks != null) {
                    this.addReplacement(replaceableBlocks, ore);
                    continue;
                }
                this.addOre(ore);
            }
            catch (Exception e) {
                this.oreParser.logError((AbstractForgeMod)AdLods.getInstance(), "placement", (CharSequence)string, e);
            }
        }
    }

    public void addOre(WeightedOre ore) {
        this.ores.add((CommonCollect.IWeighted)ore);
        this.oreBlocks.add(ore.getBlockState().m_60734_());
    }

    public void addOreBlocks(Collection<Block> oreBlocks) {
        this.oreBlocks.addAll(oreBlocks);
    }

    public void addReplacement(BlockStatesSet replaceableBlocks, WeightedOre ore) {
        this.oreBlocks.add(ore.getBlockState().m_60734_());
        replaceableBlocks.getBlocksWithAllStates().stream().map(block -> this.replacements.getBlocksWithAllStates().computeIfAbsent(block, b -> new CommonCollect.WeightedList())).forEach(list -> list.add((CommonCollect.IWeighted)ore));
        replaceableBlocks.stream().map(state -> (CommonCollect.WeightedList)this.replacements.computeIfAbsent(state, s -> new CommonCollect.WeightedList())).forEach(list -> list.add((CommonCollect.IWeighted)ore));
    }

    public void putAll(AbstractOrePlacements another) {
        another.ores.getElements().forEach(arg_0 -> this.ores.add(arg_0));
        this.oreBlocks.addAll(another.oreBlocks);
        this.replacements.putAll(another.replacements);
    }
}

