/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.target;

import com.endertech.common.CommonPath;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.IReloadableData;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.AbstractGenerator;
import com.endertech.minecraft.mods.adlods.ore.AbstractOre;
import com.endertech.minecraft.mods.adlods.target.AbstractTarget;
import com.endertech.minecraft.mods.adlods.target.TargetGenResult;
import com.endertech.minecraft.mods.adlods.world.WorldTargets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public abstract class AbstractTargetGenerator<T extends AbstractTarget>
extends AbstractGenerator
implements IReloadableData {
    protected final String category;
    protected final Path configsDir;
    protected final List<T> targets = new ArrayList<T>();
    @Nullable
    protected Map<Structure, List<T>> structures = null;

    public AbstractTargetGenerator(AbstractForgeMod mod, String category) {
        super(mod);
        this.category = category;
        this.configsDir = mod.getConfigsDir().resolve(category);
    }

    protected abstract T createTarget(UnitConfig var1, String var2);

    protected abstract void createDefaultTargets(Path var1);

    public List<T> getTargets() {
        return Collections.unmodifiableList(this.targets);
    }

    public Path getConfigsDir() {
        return this.configsDir;
    }

    public String getCategory() {
        return this.category;
    }

    public void loadData() {
        this.structures = null;
        this.targets.clear();
        this.createDefaultTargets(this.getConfigsDir());
        this.parseTargets(this.getConfigsDir());
    }

    protected void parseTargets(Path dir) {
        for (Path path : UnitConfig.listCustomConfigs((Path)dir, null)) {
            String name = CommonPath.getFileNameOnly((Path)path);
            T target = this.createTarget(new UnitConfig(path.toFile()), name);
            this.addTarget(target);
        }
    }

    public Optional<T> findByName(String name) {
        for (AbstractTarget target : this.targets) {
            if (!target.name.equals(name)) continue;
            return Optional.of(target);
        }
        return Optional.empty();
    }

    public boolean addTarget(T target) {
        if (!((AbstractTarget)target).isEnabled()) {
            return false;
        }
        if (!((AbstractOre)target).isValid()) {
            return false;
        }
        if (this.findByName(((AbstractTarget)target).getName()).isPresent()) {
            return false;
        }
        return this.targets.add(target);
    }

    public boolean removeTarget(T target) {
        return this.targets.remove(target);
    }

    protected Map<Structure, List<T>> mapStructures(WorldGenLevel level) {
        ConcurrentHashMap structureMap = new ConcurrentHashMap();
        for (AbstractTarget target : this.getTargets()) {
            UnitId id = target.indicator.getCenterId();
            Percentage threshold = target.indicator.threshold;
            if (id.isEmpty() || id.hasMetaData() || !threshold.isGreaterThan((Object)Percentage.ZERO)) continue;
            Optional registry = level.m_9598_().m_6632_(Registries.f_256944_);
            List<Object> structures = Collections.emptyList();
            ResourceLocation name = id.toResLoc();
            if (id.isTag()) {
                TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)name);
                structures = registry.stream().map(reg -> reg.m_203431_(tagKey)).flatMap(Optional::stream).flatMap(HolderSet.ListBacked::m_203614_).filter(Holder::m_203633_).map(Holder::m_203334_).toList();
            } else {
                structures = registry.map(reg -> (Structure)reg.m_7745_(name)).stream().toList();
            }
            structures.forEach(struct -> structureMap.computeIfAbsent((Structure)struct, k -> new ArrayList()).add(target));
        }
        return structureMap;
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        if (this.structures == null) {
            this.structures = this.mapStructures(context.m_159774_());
        }
        return super.m_142674_(context);
    }

    protected int getMaxGenAttempts() {
        return 16;
    }

    public boolean generateAt(WorldGenLevel level, ChunkPos chunk, Random random) {
        boolean newTargets = this.tryGenerateNewTargets(level, chunk, random);
        boolean deferredTargets = this.tryGenerateDeferredTargets(level, chunk, random);
        return newTargets || deferredTargets;
    }

    protected boolean tryGenerateNewTargets(WorldGenLevel level, ChunkPos chunk, Random random) {
        ArrayList targetsToGenerate = new ArrayList();
        if (this.structures != null && !this.structures.isEmpty()) {
            List structureStarts = level.m_6018_().m_215010_().m_220477_(chunk, this.structures::containsKey);
            if (!structureStarts.isEmpty()) {
                structureStarts.stream().filter(start -> new ChunkPos(start.m_73601_().m_162394_()).equals((Object)chunk)).map(StructureStart::m_226861_).map(this.structures::get).filter(Objects::nonNull).flatMap(Collection::stream).filter(target -> target.inAllowedDimenstion((ServerLevelAccessor)level) && target.indicator.threshold.takeChance(random)).forEach(targetsToGenerate::add);
            }
        }
        this.targets.stream().filter(target -> target.inAllowedDimenstion((ServerLevelAccessor)level) && target.getChance().takeChance(random)).forEach(targetsToGenerate::add);
        if (targetsToGenerate.isEmpty()) {
            return false;
        }
        Collections.shuffle(targetsToGenerate, random);
        boolean success = false;
        block0: for (AbstractTarget target2 : targetsToGenerate) {
            for (int attempt = 0; attempt < this.getMaxGenAttempts(); ++attempt) {
                TargetGenResult result = target2.generateAt(level, chunk, random);
                if (result.isEmpty()) continue;
                success = true;
                continue block0;
            }
        }
        if (!success) {
            ForgeEndertech.debugMsg((String)("Failed all attempts to generate " + this.category + " at " + chunk));
        }
        return success;
    }

    public boolean tryGenerateDeferredTargets(WorldGenLevel level, ChunkPos chunk, Random random) {
        boolean success = false;
        WorldTargets worldTargets = WorldTargets.get(level.m_6018_());
        HashMap<BlockPos, TargetGenResult> updatedResults = new HashMap<BlockPos, TargetGenResult>();
        int part = 0;
        for (Map.Entry<BlockPos, TargetGenResult> entry : worldTargets.deferred(chunk).entrySet()) {
            BlockPos start = entry.getKey();
            TargetGenResult result = entry.getValue();
            TargetGenResult origin = Optional.ofNullable((TargetGenResult)updatedResults.get(result.pos)).orElse(result);
            int size = origin.deferred;
            if (size == 0) continue;
            int finalPart = ++part;
            int count = this.findByName(origin.name).filter(target -> target.getClass().getSimpleName().equals(origin.target)).map(target -> target.generate(level, origin.pos, start, size, false, random, finalPart)).orElse(0);
            if (count <= 0) continue;
            success = true;
            result = new TargetGenResult(origin.target, origin.name, origin.pos, origin.size + count, origin.deferred - count, origin.indicator);
            updatedResults.put(result.pos, result);
        }
        updatedResults.values().forEach(worldTargets::saveGenResult);
        return success;
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, this.placedFeature);
        }
    }
}

