/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.world;

import com.endertech.minecraft.mods.adlods.target.TargetGenResult;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.commons.lang3.tuple.Pair;

public class WorldTargets
extends SavedData {
    protected final Map<BlockPos, TargetGenResult> generated = new ConcurrentHashMap<BlockPos, TargetGenResult>();
    protected final Map<ChunkPos, Map<BlockPos, BlockPos>> deferredEntryPoints = new ConcurrentHashMap<ChunkPos, Map<BlockPos, BlockPos>>();

    public static WorldTargets get(ServerLevel level) {
        return (WorldTargets)level.m_8895_().m_164861_(WorldTargets::load, WorldTargets::new, "large_ore_deposits");
    }

    public void saveDeferredEntryPoint(BlockPos entryPoint, BlockPos targetStartPos) {
        this.deferredEntryPoints.computeIfAbsent(new ChunkPos(entryPoint), k -> new ConcurrentHashMap()).put(entryPoint, targetStartPos);
        this.m_77762_();
    }

    public void removeDeferredEntryPointsIn(ChunkPos chunk) {
        if (this.deferredEntryPoints.remove(chunk) != null) {
            this.m_77762_();
        }
    }

    public void saveGenResult(TargetGenResult result) {
        if (result.isEmpty()) {
            this.generated.remove(result.pos);
        } else {
            this.generated.put(result.pos, result);
        }
        this.m_77762_();
    }

    public Map<BlockPos, TargetGenResult> generated() {
        return Collections.unmodifiableMap(this.generated);
    }

    public Map<BlockPos, TargetGenResult> deferred(ChunkPos chunk) {
        Map<BlockPos, BlockPos> points = this.deferredEntryPoints.get(chunk);
        if (points != null) {
            return points.entrySet().stream().map(entry -> Pair.of((Object)((BlockPos)entry.getKey()), (Object)this.generated.get(entry.getValue()))).filter(pair -> pair.getValue() != null).collect(Collectors.toUnmodifiableMap(Pair::getKey, Pair::getValue));
        }
        return Collections.emptyMap();
    }

    public static WorldTargets load(CompoundTag compound) {
        WorldTargets targets = new WorldTargets();
        compound.m_128437_("generated", 10).stream().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).map(TargetGenResult.EMPTY::readFrom).forEach(result -> targets.generated.put(result.pos, (TargetGenResult)result));
        compound.m_128437_("points", 12).stream().filter(LongArrayTag.class::isInstance).map(LongArrayTag.class::cast).map(LongArrayTag::m_128851_).filter(array -> ((long[])array).length == 2).forEach(array -> targets.saveDeferredEntryPoint(BlockPos.m_122022_((long)array[0]), BlockPos.m_122022_((long)array[1])));
        targets.m_77760_(false);
        return targets;
    }

    /*
     * Exception decompiling
     */
    public CompoundTag m_7176_(CompoundTag compound) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

