/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.events;

import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import net.pedroksl.advanced_ae.common.items.armors.QuantumBoots;
import net.pedroksl.advanced_ae.common.items.armors.QuantumChestplate;
import net.pedroksl.advanced_ae.common.items.armors.QuantumHelmet;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.advanced_ae.network.AAENetworkHandler;
import net.pedroksl.advanced_ae.network.packet.KeysPressedPacket;
import net.pedroksl.advanced_ae.xmod.Addons;
import net.pedroksl.advanced_ae.xmod.apoth.ApoEnchPlugin;

public class AAEPlayerEvents {
    public static final String NO_KEY_DATA = "aae$nokey";
    public static final String UP_KEY_DATA = "aae$upkey";
    public static final String DOWN_KEY_DATA = "aae$downkey";

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(AAEPlayerEvents::breakSpeed);
        MinecraftForge.EVENT_BUS.addListener(AAEPlayerEvents::playerTickStart);
        MinecraftForge.EVENT_BUS.addListener(AAEPlayerEvents::playerTickEnd);
    }

    public static void breakSpeed(PlayerEvent.BreakSpeed event) {
        float value;
        AttributeInstance att;
        ItemStack armor;
        Player player = event.getEntity();
        if (!player.m_20096_()) {
            ItemStack armor2;
            if (!(Addons.APOTHIC_ENCHANTING.isLoaded() && ApoEnchPlugin.checkForEnchant(player, ApoEnchPlugin.Enchantment.STABLE_FOOTING) || !((armor2 = player.m_6844_(EquipmentSlot.CHEST)).m_41720_() instanceof QuantumChestplate))) {
                float newValue = Math.max(event.getOriginalSpeed(), event.getOriginalSpeed() * 5.0f);
                event.setNewSpeed(newValue);
            }
        } else if (player.m_204029_(FluidTags.f_13131_) && (armor = player.m_6844_(EquipmentSlot.CHEST)).m_41720_() instanceof QuantumChestplate && (att = player.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get())) != null && (value = (float)att.m_22135_()) < 1.0f) {
            event.setNewSpeed(event.getOriginalSpeed() / value);
        }
    }

    public static void playerTickStart(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Player player = event.player;
        if (!(player.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof QuantumArmorBase) && player.getPersistentData().m_128471_("aaeFlightCard")) {
            player.m_150110_().f_35936_ = false;
            player.m_150110_().f_35935_ = false;
            player.getPersistentData().m_128473_("aaeFlightCard");
            player.m_6885_();
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MobEffectInstance nv = serverPlayer.m_21124_(MobEffects.f_19611_);
            ItemStack stack = player.m_6844_(EquipmentSlot.HEAD);
            if (!stack.m_41619_()) {
                QuantumHelmet helmet;
                Item item = stack.m_41720_();
                if (item instanceof QuantumHelmet && (helmet = (QuantumHelmet)item).isUpgradeEnabledAndPowered(stack, UpgradeType.NIGHT_VISION, serverPlayer.m_9236_()) && (nv == null || nv.m_19557_() < 210)) {
                    stack.m_41784_().m_128379_("night_vision_on", true);
                    serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 210, 0, false, false, false));
                    helmet.consumeEnergy(player, stack, UpgradeType.NIGHT_VISION);
                }
                if (stack.m_41784_().m_128471_("night_vision_on") && nv != null && nv.m_19557_() < 210) {
                    serverPlayer.m_21195_(MobEffects.f_19611_);
                    stack.m_41749_("night_vision_on");
                }
            }
        } else {
            ItemStack chestStack;
            Item item;
            boolean downKey;
            boolean upKey;
            ItemStack bootStack = player.m_6844_(EquipmentSlot.FEET);
            Item helmet = bootStack.m_41720_();
            if (helmet instanceof QuantumBoots) {
                QuantumBoots boots = (QuantumBoots)helmet;
                UpgradeType upgrade = UpgradeType.FLIGHT_DRIFT;
                if (player.m_150110_().f_35935_ && boots.isUpgradeEnabledAndPowered(bootStack, upgrade) && player.getPersistentData().m_128471_(NO_KEY_DATA)) {
                    Vec3 motion = player.m_20184_();
                    if (motion.f_82479_ != 0.0 || motion.f_82481_ != 0.0) {
                        float value = (float)boots.getUpgradeValue(bootStack, upgrade, 100) / 100.0f;
                        player.m_20334_(motion.f_82479_ * (double)value, motion.f_82480_, motion.f_82481_ * (double)value);
                    }
                }
            }
            if ((upKey = player.getPersistentData().m_128471_(UP_KEY_DATA)) != (downKey = player.getPersistentData().m_128471_(DOWN_KEY_DATA)) && (item = (chestStack = player.m_6844_(EquipmentSlot.CHEST)).m_41720_()) instanceof QuantumChestplate) {
                QuantumChestplate chest = (QuantumChestplate)item;
                UpgradeType upgrade = UpgradeType.FLIGHT;
                if (player.m_150110_().f_35935_ && chest.isUpgradeEnabledAndPowered(chestStack, upgrade)) {
                    float value = upgrade.getSettings().multiplier * (float)chest.getUpgradeValue(chestStack, upgrade, 0) / 35.0f;
                    int direction = upKey ? 1 : -1;
                    player.m_19920_(value, new Vec3(0.0, (double)direction, 0.0));
                }
            }
        }
    }

    public static void playerTickEnd(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            ItemStack chestStack;
            Options options;
            QuantumBoots boots;
            ItemStack bootStack = player.m_6844_(EquipmentSlot.FEET);
            Item item = bootStack.m_41720_();
            if (item instanceof QuantumBoots && (boots = (QuantumBoots)item).isUpgradeEnabledAndPowered(bootStack, UpgradeType.FLIGHT_DRIFT)) {
                boolean noKey;
                options = Minecraft.m_91087_().f_91066_;
                boolean bl = noKey = !options.f_92085_.m_90857_() && !options.f_92088_.m_90857_() && !options.f_92087_.m_90857_() && !options.f_92086_.m_90857_();
                if (player.getPersistentData().m_128471_(NO_KEY_DATA) != noKey) {
                    AAENetworkHandler.INSTANCE.sendToServer(new KeysPressedPacket(NO_KEY_DATA, noKey));
                    player.getPersistentData().m_128379_(NO_KEY_DATA, noKey);
                }
            }
            if ((chestStack = player.m_6844_(EquipmentSlot.CHEST)).m_41720_() instanceof QuantumChestplate) {
                options = Minecraft.m_91087_().f_91066_;
                boolean downKey = options.f_92090_.m_90857_();
                if (player.getPersistentData().m_128471_(DOWN_KEY_DATA) != downKey) {
                    AAENetworkHandler.INSTANCE.sendToServer(new KeysPressedPacket(DOWN_KEY_DATA, downKey));
                    player.getPersistentData().m_128379_(DOWN_KEY_DATA, downKey);
                }
                boolean upKey = options.f_92089_.m_90857_();
                if (player.getPersistentData().m_128471_(UP_KEY_DATA) != upKey) {
                    AAENetworkHandler.INSTANCE.sendToServer(new KeysPressedPacket(UP_KEY_DATA, upKey));
                    player.getPersistentData().m_128379_(UP_KEY_DATA, upKey);
                }
            }
        }
    }
}

