/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.items.armors;

import appeng.api.features.IGridLinkableHandler;
import appeng.api.implementations.blockentities.IWirelessAccessPoint;
import appeng.api.networking.IGrid;
import appeng.core.localization.PlayerMessages;
import appeng.util.Platform;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IGridLinkedItem {
    public static final Logger LOG = LoggerFactory.getLogger(IGridLinkedItem.class);
    public static final IGridLinkableHandler LINKABLE_HANDLER = new LinkableHandler();
    public static final String TAG_ACCESS_POINT_POS = "accessPoint";

    default public void updateStatus() {
    }

    @Nullable
    default public GlobalPos getLinkedPosition(ItemStack item) {
        CompoundTag tag = item.m_41783_();
        if (tag != null && tag.m_128425_(TAG_ACCESS_POINT_POS, 10)) {
            return GlobalPos.f_122633_.decode((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_(TAG_ACCESS_POINT_POS)).resultOrPartial(Util.m_137489_((String)"Linked position", arg_0 -> ((Logger)LOG).error(arg_0))).map(Pair::getFirst).orElse(null);
        }
        return null;
    }

    @Nullable
    default public IGrid getLinkedGrid(ItemStack stack, Level level) {
        return this.getLinkedGrid(stack, level, null);
    }

    @Nullable
    default public IGrid getLinkedGrid(ItemStack item, Level level, @Nullable Player sendMessagesTo) {
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        GlobalPos linkedPos = this.getLinkedPosition(item);
        if (linkedPos == null) {
            if (sendMessagesTo != null) {
                sendMessagesTo.m_5661_((Component)PlayerMessages.DeviceNotLinked.text(), true);
            }
            return null;
        }
        ServerLevel linkedLevel = serverLevel.m_7654_().m_129880_(linkedPos.m_122640_());
        if (linkedLevel == null) {
            if (sendMessagesTo != null) {
                sendMessagesTo.m_5661_((Component)PlayerMessages.LinkedNetworkNotFound.text(), true);
            }
            return null;
        }
        BlockEntity be = Platform.getTickingBlockEntity((Level)linkedLevel, (BlockPos)linkedPos.m_122646_());
        if (!(be instanceof IWirelessAccessPoint)) {
            if (sendMessagesTo != null) {
                sendMessagesTo.m_5661_((Component)PlayerMessages.LinkedNetworkNotFound.text(), true);
            }
            return null;
        }
        IWirelessAccessPoint accessPoint = (IWirelessAccessPoint)be;
        IGrid grid = accessPoint.getGrid();
        if (grid == null && sendMessagesTo != null) {
            sendMessagesTo.m_5661_((Component)PlayerMessages.LinkedNetworkNotFound.text(), true);
        }
        return grid;
    }

    public static class LinkableHandler
    implements IGridLinkableHandler {
        public boolean canLink(ItemStack stack) {
            return stack.m_41720_() instanceof IGridLinkedItem;
        }

        public void link(ItemStack itemStack, GlobalPos pos) {
            GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)pos).result().ifPresent(tag -> itemStack.m_41784_().m_128365_(IGridLinkedItem.TAG_ACCESS_POINT_POS, tag));
        }

        public void unlink(ItemStack itemStack) {
            itemStack.m_41749_(IGridLinkedItem.TAG_ACCESS_POINT_POS);
        }
    }
}

