/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.gui;

import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.ISubMenuHost;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.interfaces.IProgressProvider;
import appeng.menu.locator.MenuLocator;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.DisabledSlot;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.definitions.AAESlotSemantics;
import net.pedroksl.advanced_ae.common.inventory.QuantumArmorMenuHost;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import net.pedroksl.advanced_ae.common.items.upgrades.QuantumUpgradeBaseItem;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.advanced_ae.gui.QuantumArmorFilterConfigMenu;
import net.pedroksl.advanced_ae.gui.QuantumArmorMagnetMenu;
import net.pedroksl.advanced_ae.gui.QuantumArmorNumInputConfigMenu;
import net.pedroksl.advanced_ae.gui.QuantumArmorStyleConfigMenu;
import net.pedroksl.advanced_ae.network.AAENetworkHandler;
import net.pedroksl.advanced_ae.network.packet.quantumarmor.QuantumArmorUpgradeStatePacket;

public class QuantumArmorConfigMenu
extends AEBaseMenu
implements ISubMenuHost,
IProgressProvider {
    @GuiSync(value=2)
    public int maxProcessingTime;
    @GuiSync(value=3)
    public int processingTime = -1;
    private final QuantumArmorMenuHost host;
    private final Slot inputSlot;
    private boolean markDirty = false;
    private static final String REQUEST_UPDATE = "request_update";
    private static final String SELECT_SLOT = "select_slot";
    private static final String REQUEST_UNINSTALL = "request_uninstall";
    private static final String EMPTY_SLOT = "empty_slot";
    private static final String OPEN_STYLE = "open_style";
    public static final String LAST_SLOT_INDEX = "aae$lastSlotIndex";

    public QuantumArmorConfigMenu(int id, Inventory playerInventory, QuantumArmorMenuHost host) {
        super(AAEMenus.QUANTUM_ARMOR_CONFIG.get(), id, playerInventory, (Object)host);
        this.host = host;
        this.createPlayerInventorySlots(playerInventory);
        this.inputSlot = this.addSlot((Slot)new UpgradeSlot(host.getInventory(), 0), SlotSemantics.MACHINE_INPUT);
        int indexOfFirstQuantum = -1;
        for (int i = 3; i >= 0; --i) {
            int index = 36 + i;
            DisabledSlot slot = new DisabledSlot((Container)playerInventory, index);
            if (slot.m_7993_().m_41720_() instanceof QuantumArmorBase && indexOfFirstQuantum == -1) {
                indexOfFirstQuantum = index;
            }
            this.addSlot((Slot)slot, AAESlotSemantics.ARMOR);
        }
        this.maxProcessingTime = this.host.getMaxProcessingTime();
        this.host.setProgressChangedHandler(this::progressChanged);
        this.host.setUpgradeAppliedWatcher(() -> {
            this.markDirty = true;
        });
        this.host.setInventoryChangedHandler(this::onChangeInventory);
        this.registerClientAction(REQUEST_UPDATE, this::updateClient);
        this.registerClientAction(SELECT_SLOT, Integer.class, this::setSelectedItemSlot);
        this.registerClientAction(REQUEST_UNINSTALL, UpgradeType.class, this::requestUninstall);
        this.registerClientAction(EMPTY_SLOT, this::emptyUpgradeSlot);
        this.registerClientAction(OPEN_STYLE, this::openStyleScreen);
        if (this.getPlayer().getPersistentData().m_128441_(LAST_SLOT_INDEX)) {
            this.setSelectedItemSlot(this.getPlayer().getPersistentData().m_128451_(LAST_SLOT_INDEX));
        } else {
            this.setSelectedItemSlot(indexOfFirstQuantum);
        }
        this.updateClient();
    }

    public QuantumArmorMenuHost getHost() {
        return this.host;
    }

    private void progressChanged(int progress) {
        this.processingTime = progress;
    }

    private void onChangeInventory(InternalInventory inv, int slot) {
    }

    public void returnToMainMenu(Player player, ISubMenu iSubMenu) {
        this.host.returnToMainMenu(player, iSubMenu);
    }

    public ItemStack getMainMenuIcon() {
        return this.host.getItemStack();
    }

    public int getCurrentProgress() {
        return this.processingTime;
    }

    public int getMaxProgress() {
        return this.maxProcessingTime;
    }

    public boolean isArmorSlot(Slot slot) {
        return this.getSlots(AAESlotSemantics.ARMOR).contains(slot);
    }

    public void setSelectedItemSlot(int index) {
        if (this.isClientSide()) {
            this.sendClientAction(SELECT_SLOT, index);
            this.getPlayer().getPersistentData().m_128405_(LAST_SLOT_INDEX, index);
            return;
        }
        this.host.setSelectedItemSlot(index);
    }

    public int getSelectedSlotIndex() {
        return this.host.getSelectedSlotIndex();
    }

    public void toggleUpgradeEnable(UpgradeType upgradeType, boolean state) {
        QuantumArmorBase item;
        int slotIndex = this.host.getSelectedSlotIndex();
        ItemStack stack = this.getPlayer().m_150109_().m_8020_(slotIndex);
        Item item2 = stack.m_41720_();
        if (item2 instanceof QuantumArmorBase && (item = (QuantumArmorBase)item2).getPossibleUpgrades().contains((Object)upgradeType) && item.hasUpgrade(stack, upgradeType)) {
            item.toggleUpgrade(stack, upgradeType);
            this.markDirty = true;
        }
    }

    public void openNumInputConfigScreen(UpgradeType upgradeType, int currentValue) {
        MenuLocator locator = this.getLocator();
        if (locator != null) {
            QuantumArmorNumInputConfigMenu.open((ServerPlayer)this.getPlayer(), this.getLocator(), this.getSelectedSlotIndex(), upgradeType, currentValue);
        }
    }

    public void openFilterConfigScreen(UpgradeType upgradeType, List<GenericStack> filter) {
        MenuLocator locator = this.getLocator();
        if (locator != null && this.isServerSide()) {
            QuantumArmorFilterConfigMenu.open((ServerPlayer)this.getPlayer(), this.getLocator(), this.getSelectedSlotIndex(), filter, upgradeType);
        }
    }

    public void openMagnetScreen(int currentValue, List<GenericStack> filter, boolean blacklist) {
        MenuLocator locator = this.getLocator();
        if (locator != null && this.isServerSide()) {
            QuantumArmorMagnetMenu.open((ServerPlayer)this.getPlayer(), this.getLocator(), this.getSelectedSlotIndex(), filter, currentValue, blacklist);
        }
    }

    public void openStyleScreen() {
        if (this.isClientSide()) {
            this.sendClientAction(OPEN_STYLE);
            return;
        }
        MenuLocator locator = this.getLocator();
        if (locator != null) {
            QuantumArmorStyleConfigMenu.open((ServerPlayer)this.getPlayer(), this.getLocator(), this.getSelectedSlotIndex());
        }
    }

    public void requestUninstall(UpgradeType upgradeType) {
        QuantumArmorBase item;
        if (this.isClientSide()) {
            this.sendClientAction(REQUEST_UNINSTALL, (Object)upgradeType);
            return;
        }
        boolean upgradeRemoved = false;
        int slotIndex = this.host.getSelectedSlotIndex();
        ItemStack stack = this.getPlayer().m_150109_().m_8020_(slotIndex);
        Item item2 = stack.m_41720_();
        if (item2 instanceof QuantumArmorBase && (item = (QuantumArmorBase)item2).getPossibleUpgrades().contains((Object)upgradeType) && item.hasUpgrade(stack, upgradeType)) {
            upgradeRemoved = item.removeUpgrade(stack, upgradeType);
        }
        ItemStack upgradeStack = upgradeType.item().stack();
        if (upgradeRemoved && !this.getPlayer().m_150109_().m_36054_(upgradeStack)) {
            this.getPlayer().m_36176_(upgradeStack, false);
        }
        this.markDirty = true;
    }

    public void updateClient() {
        Player player;
        if (this.isClientSide()) {
            this.sendClientAction(REQUEST_UPDATE);
            return;
        }
        int slotIndex = this.host.getSelectedSlotIndex();
        ItemStack stack = this.getPlayer().m_150109_().m_8020_(slotIndex);
        if (!stack.m_41619_() && (player = this.getPlayer()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            int index = 4 - (slotIndex - 36) + 36;
            AAENetworkHandler.INSTANCE.sendTo(new QuantumArmorUpgradeStatePacket(index, stack), player2);
        }
    }

    public void m_38946_() {
        super.m_38946_();
        if (this.host != null) {
            this.host.tick();
        }
        if (this.markDirty) {
            this.updateClient();
            this.markDirty = false;
        }
    }

    public void emptyUpgradeSlot() {
        if (this.isClientSide()) {
            this.sendClientAction(EMPTY_SLOT);
            return;
        }
        if (!this.inputSlot.m_7993_().m_41619_()) {
            this.getPlayer().m_36356_(this.inputSlot.m_7993_());
            this.inputSlot.m_5852_(ItemStack.f_41583_);
        }
    }

    private static class UpgradeSlot
    extends AppEngSlot {
        public UpgradeSlot(InternalInventory inv, int invSlot) {
            super(inv, invSlot);
        }

        public boolean m_5857_(ItemStack stack) {
            Item item = stack.m_41720_();
            if (item instanceof QuantumUpgradeBaseItem) {
                QuantumUpgradeBaseItem upgrade = (QuantumUpgradeBaseItem)item;
                return upgrade.getType() != UpgradeType.EMPTY;
            }
            return false;
        }

        public boolean m_8010_(Player player) {
            return true;
        }
    }
}

