/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.ae2.stack;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.core.localization.GuiText;
import me.ramidzkh.mekae2.AMText;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public record ChemicalHandlerFacade(@Nullable IChemicalHandler[] handlers, boolean extractableOnly, Runnable changeListener) implements MEStorage
{
    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (!(what instanceof MekanismKey)) {
            return 0L;
        }
        MekanismKey key = (MekanismKey)what;
        IChemicalHandler handler = this.handlers[key.getForm()];
        if (handler == null) {
            return 0L;
        }
        long inserted = amount - handler.insertChemical(key.withAmount(amount), Action.fromFluidAction((IFluidHandler.FluidAction)mode.getFluidAction())).getAmount();
        if (inserted > 0L && mode == Actionable.MODULATE && this.changeListener != null) {
            this.changeListener.run();
        }
        return inserted;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (!(what instanceof MekanismKey)) {
            return 0L;
        }
        MekanismKey key = (MekanismKey)what;
        IChemicalHandler handler = this.handlers[key.getForm()];
        if (handler == null) {
            return 0L;
        }
        long extracted = handler.extractChemical(key.withAmount(amount), Action.fromFluidAction((IFluidHandler.FluidAction)mode.getFluidAction())).getAmount();
        if (extracted > 0L && mode == Actionable.MODULATE && this.changeListener != null) {
            this.changeListener.run();
        }
        return extracted;
    }

    public Component getDescription() {
        return GuiText.ExternalStorage.text(new Object[]{AMText.CHEMICAL});
    }

    public void getAvailableStacks(KeyCounter out) {
        for (IChemicalHandler handler : this.handlers) {
            if (handler == null) continue;
            for (int i = 0; i < handler.getTanks(); ++i) {
                ChemicalStack stack = handler.getChemicalInTank(i);
                MekanismKey key = MekanismKey.of(stack);
                if (key == null || this.extractableOnly && handler.extractChemical(stack, Action.SIMULATE).isEmpty()) continue;
                out.add((AEKey)key, stack.getAmount());
            }
        }
    }
}

