/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.common.caps;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import com.glodblock.github.appflux.common.me.key.FluxKey;
import com.glodblock.github.appflux.common.me.key.type.EnergyType;
import com.glodblock.github.appflux.util.AFUtil;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public record NetworkFEPower(IStorageService storage, IActionSource source) implements IEnergyStorage
{
    public static IEnergyStorage of(@Nullable IStorageService storage, IActionSource source) {
        if (storage != null) {
            return new NetworkFEPower(storage, source);
        }
        return new EnergyStorage(0);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return (int)this.storage.getInventory().insert((AEKey)FluxKey.of(EnergyType.FE), (long)maxReceive, Actionable.ofSimulate((boolean)simulate), this.source);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return (int)this.storage.getInventory().extract((AEKey)FluxKey.of(EnergyType.FE), (long)maxExtract, Actionable.ofSimulate((boolean)simulate), this.source);
    }

    public int getEnergyStored() {
        return AFUtil.clampLong(this.storage.getCachedInventory().get((AEKey)FluxKey.of(EnergyType.FE)));
    }

    public int getMaxEnergyStored() {
        long space = this.storage.getInventory().insert((AEKey)FluxKey.of(EnergyType.FE), 0x7FFFFFFFFFFFFFFEL, Actionable.SIMULATE, this.source);
        return AFUtil.clampLong(space + (long)this.getEnergyStored());
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }
}

