/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.data;

import java.util.function.BiFunction;

public enum LogicalOperation {
    AND("and", "&&", (a, b) -> a != false && b != false),
    NAND("nand", "!&", (a, b) -> a == false || b == false),
    OR("or", "||", (a, b) -> a != false || b != false),
    NOR("nor", "!|", (a, b) -> a == false && b == false),
    XOR("xor", "^", (a, b) -> a ^ b);

    private final String name;
    private final String symbol;
    private final BiFunction<Boolean, Boolean, Boolean> operation;

    private LogicalOperation(String name, String symbol, BiFunction<Boolean, Boolean, Boolean> operation) {
        this.name = name;
        this.symbol = symbol;
        this.operation = operation;
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public boolean apply(boolean a, boolean b) {
        return this.operation.apply(a, b);
    }

    public static LogicalOperation fromName(String name) {
        for (LogicalOperation operation : LogicalOperation.values()) {
            if (!operation.getName().equals(name)) continue;
            return operation;
        }
        return null;
    }

    public static LogicalOperation of(String symbol) {
        for (LogicalOperation operation : LogicalOperation.values()) {
            if (!operation.getSymbol().equals(symbol)) continue;
            return operation;
        }
        return null;
    }
}

