/*
 * Decompiled with CFR 0.152.
 */
package ballistix;

import ballistix.api.blast.RegisterBlastEvent;
import ballistix.client.BallistixClientRegister;
import ballistix.client.event.RegisterBlastRenderersEvent;
import ballistix.common.blast.util.thread.ThreadSimpleBlast;
import ballistix.common.block.BallistixVoxelShapes;
import ballistix.common.block.subtype.SubtypeBlast;
import ballistix.common.item.ItemGrenade;
import ballistix.common.item.ItemMinecart;
import ballistix.common.packet.NetworkHandler;
import ballistix.common.settings.BallistixConstants;
import ballistix.common.tags.BallistixTags;
import ballistix.registers.BallistixItems;
import ballistix.registers.UnifiedBallistixRegister;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import voltaic.prefab.configuration.ConfigurationHandler;

@Mod(value="ballistix")
@Mod.EventBusSubscriber(modid="ballistix", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Ballistix {
    public static final String ID = "ballistix";
    public static final String NAME = "Ballistix";
    public static final String NUCLEAR_SCIENCE_ID = "nuclearscience";
    public static final String GRIEF_DEFENDER_ID = "griefdefender";

    public Ballistix() {
        ConfigurationHandler.registerConfig(BallistixConstants.class);
        BallistixVoxelShapes.init();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        UnifiedBallistixRegister.register(bus);
        bus.register(RegisterBlastEvent.class);
        bus.register(RegisterBlastRenderersEvent.class);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> BallistixClientRegister.setup());
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        NetworkHandler.init();
        BallistixTags.init();
        BallistixVoxelShapes.init();
        event.enqueueWork(() -> {
            RegisterBlastEvent registerBlastEvent = new RegisterBlastEvent();
            ModLoader.get().postEvent((Event)registerBlastEvent);
            registerBlastEvent.stashBlasts();
        });
    }

    @SubscribeEvent
    public static void registerBlasts(RegisterBlastEvent event) {
        for (SubtypeBlast subtypeBlast : SubtypeBlast.values()) {
            event.registerBlast(subtypeBlast);
        }
        for (Enum enum_ : ItemGrenade.SubtypeGrenade.values()) {
            event.registerGrenade(((ItemGrenade.SubtypeGrenade)enum_).explosiveType, (Item)BallistixItems.ITEMS_GRENADE.getValue((Object)enum_));
        }
        for (Enum enum_ : ItemMinecart.SubtypeMinecart.values()) {
            event.registerMinecart(((ItemMinecart.SubtypeMinecart)enum_).explosiveType, (Item)BallistixItems.ITEMS_MINECART.getValue((Object)enum_));
        }
        event.submitCachedThreads(() -> {
            new ThreadSimpleBlast(null, BlockPos.f_121853_, (int)BallistixConstants.EXPLOSIVE_ANTIMATTER_RADIUS, 2.1474836E9f, null, SubtypeBlast.antimatter.id()).start();
            new ThreadSimpleBlast(null, BlockPos.f_121853_, (int)BallistixConstants.EXPLOSIVE_DARKMATTER_RADIUS, 2.1474836E9f, null, SubtypeBlast.darkmatter.id()).start();
            new ThreadSimpleBlast(null, BlockPos.f_121853_, (int)BallistixConstants.EXPLOSIVE_LARGEANTIMATTER_RADIUS, 2.1474836E9f, null, SubtypeBlast.largeantimatter.id()).start();
            new ThreadSimpleBlast(null, BlockPos.f_121853_, (int)((double)((int)BallistixConstants.EXPLOSIVE_NUCLEAR_SIZE) * 2.5), 2.1474836E9f, null, SubtypeBlast.nuclear.id()).start();
            new ThreadSimpleBlast(null, BlockPos.f_121853_, (int)BallistixConstants.EXPLOSIVE_EMP_RADIUS, 2.1474836E9f, null, SubtypeBlast.emp.id());
            new ThreadSimpleBlast(null, BlockPos.f_121853_, (int)BallistixConstants.EXPLOSIVE_SONIC_RADIUS, 2.1474836E9f, null, SubtypeBlast.sonic.id());
            new ThreadSimpleBlast(null, BlockPos.f_121853_, (int)BallistixConstants.EXPLOSIVE_HYPERSONIC_RADIUS, 2.1474836E9f, null, SubtypeBlast.hypersonic.id());
            new ThreadSimpleBlast(null, BlockPos.f_121853_, (int)BallistixConstants.EXPLOSIVE_ENDOTHERMIC_RADIUS, 2.1474836E9f, null, SubtypeBlast.endothermic.id());
            new ThreadSimpleBlast(null, BlockPos.f_121853_, (int)BallistixConstants.EXPLOSIVE_INFESTIVE_RADIUS, 2.1474836E9f, null, SubtypeBlast.infestive.id());
            new ThreadSimpleBlast(null, BlockPos.f_121853_, (int)BallistixConstants.EXPLOSIVE_EXOTHERMIC_RADIUS, 2.1474836E9f, null, SubtypeBlast.exothermic.id());
        });
    }

    public static final ResourceLocation rl(String path) {
        return new ResourceLocation(ID, path);
    }
}

