/*
 * Decompiled with CFR 0.152.
 */
package ballistix.client.screen;

import ballistix.common.inventory.container.ContainerAirRaidSiren;
import ballistix.common.tile.TileAirRaidSiren;
import ballistix.prefab.utils.BallistixTextUtils;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.types.ScreenComponentHorizontalSlider;
import voltaic.prefab.screen.component.types.ScreenComponentSimpleLabel;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.utilities.math.Color;

public class ScreenAirRaidSiren
extends GenericScreen<ContainerAirRaidSiren> {
    private ScreenComponentHorizontalSlider volumeSlider;
    private ScreenComponentHorizontalSlider pitchSlider;
    private ScreenComponentHorizontalSlider rangeSlider;
    private boolean hasInitHappened = false;

    public ScreenAirRaidSiren(ContainerAirRaidSiren container, Inventory inv, Component title) {
        super((GenericContainer)container, inv, title);
        this.playerInvLabel.setVisible(false);
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(19, 30, 10, Color.TEXT_GRAY, (Component)BallistixTextUtils.gui("airraidsiren.volume", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(144, 30, 10, Color.TEXT_GRAY, () -> {
            TileAirRaidSiren siren = (TileAirRaidSiren)((ContainerAirRaidSiren)this.m_6262_()).getSafeHost();
            if (siren == null) {
                return Component.m_237119_();
            }
            return Component.m_237113_((String)("" + siren.volume.getValue()));
        }));
        this.volumeSlider = new ScreenComponentHorizontalSlider(20, 40, 138).setClickConsumer(mouseX -> {
            ScreenComponentHorizontalSlider slider = this.volumeSlider;
            TileAirRaidSiren siren = (TileAirRaidSiren)((ContainerAirRaidSiren)this.m_6262_()).getSafeHost();
            if (slider.isSliderActive() && siren != null) {
                int sliderX = slider.xLocation;
                int sliderWidth = slider.width;
                int mouseWidth = mouseX - sliderX;
                if (mouseWidth >= sliderWidth - 2 - 15) {
                    siren.volume.setValue((Object)1.0);
                    slider.setSliderXOffset(sliderWidth - 2 - 15);
                } else if (mouseWidth <= 2) {
                    siren.volume.setValue((Object)0.0);
                    slider.setSliderXOffset(0);
                } else {
                    double heightRatio = (double)mouseWidth / (double)sliderWidth;
                    siren.volume.setValue((Object)ScreenAirRaidSiren.round(1.0 * heightRatio, 1));
                    int moveRoom = slider.width - 15 - 2;
                    double moved = (Double)siren.volume.getValue() / 1.0;
                    slider.setSliderXOffset((int)((double)moveRoom * moved));
                }
            }
        }).setDragConsumer(mouseX -> {
            ScreenComponentHorizontalSlider slider = this.volumeSlider;
            TileAirRaidSiren siren = (TileAirRaidSiren)((ContainerAirRaidSiren)this.m_6262_()).getSafeHost();
            if (slider.isSliderActive() && siren != null) {
                int sliderX = slider.xLocation;
                int sliderWidth = slider.width;
                if (mouseX <= sliderX + 2) {
                    siren.volume.setValue((Object)0.0);
                    slider.setSliderXOffset(0);
                } else if (mouseX >= sliderX + sliderWidth - 2 - 15) {
                    siren.volume.setValue((Object)1.0);
                    slider.setSliderXOffset(sliderWidth - 2 - 15);
                } else {
                    int mouseWidth = mouseX - sliderX;
                    slider.setSliderXOffset(mouseWidth);
                    double widthRatio = (double)mouseWidth / (double)sliderWidth;
                    siren.volume.setValue((Object)ScreenAirRaidSiren.round(1.0 * widthRatio, 1));
                }
            }
        });
        this.addComponent((AbstractScreenComponent)this.volumeSlider);
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(19, 55, 10, Color.TEXT_GRAY, (Component)Component.m_237113_((String)"0.0")));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(144, 55, 10, Color.TEXT_GRAY, (Component)Component.m_237113_((String)"1.0")));
        this.volumeSlider.updateActive(true);
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(19, 70, 10, Color.TEXT_GRAY, (Component)BallistixTextUtils.gui("airraidsiren.pitch", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(144, 70, 10, Color.TEXT_GRAY, () -> {
            TileAirRaidSiren siren = (TileAirRaidSiren)((ContainerAirRaidSiren)this.m_6262_()).getSafeHost();
            if (siren == null) {
                return Component.m_237119_();
            }
            return Component.m_237113_((String)("" + siren.pitch.getValue()));
        }));
        this.pitchSlider = new ScreenComponentHorizontalSlider(20, 80, 138).setClickConsumer(mouseX -> {
            ScreenComponentHorizontalSlider slider = this.pitchSlider;
            TileAirRaidSiren siren = (TileAirRaidSiren)((ContainerAirRaidSiren)this.m_6262_()).getSafeHost();
            if (slider.isSliderActive() && siren != null) {
                int sliderX = slider.xLocation;
                int sliderWidth = slider.width;
                int mouseWidth = mouseX - sliderX;
                if (mouseWidth >= sliderWidth - 2 - 15) {
                    siren.pitch.setValue((Object)2.0);
                    slider.setSliderXOffset(sliderWidth - 2 - 15);
                } else if (mouseWidth <= 2) {
                    siren.pitch.setValue((Object)0.5);
                    slider.setSliderXOffset(0);
                } else {
                    double heightRatio = (double)mouseWidth / (double)sliderWidth;
                    siren.pitch.setValue((Object)ScreenAirRaidSiren.round(1.5 * heightRatio + 0.5, 1));
                    int moveRoom = slider.width - 15 - 2;
                    double moved = ((Double)siren.pitch.getValue() - 0.5) / 1.5;
                    slider.setSliderXOffset((int)((double)moveRoom * moved + 0.5));
                }
            }
        }).setDragConsumer(mouseX -> {
            ScreenComponentHorizontalSlider slider = this.pitchSlider;
            TileAirRaidSiren siren = (TileAirRaidSiren)((ContainerAirRaidSiren)this.m_6262_()).getSafeHost();
            if (slider.isSliderActive() && siren != null) {
                int sliderX = slider.xLocation;
                int sliderWidth = slider.width;
                if (mouseX <= sliderX + 2) {
                    siren.pitch.setValue((Object)0.5);
                    slider.setSliderXOffset(0);
                } else if (mouseX >= sliderX + sliderWidth - 2 - 15) {
                    siren.pitch.setValue((Object)2.0);
                    slider.setSliderXOffset(sliderWidth - 2 - 15);
                } else {
                    int mouseWidth = mouseX - sliderX;
                    slider.setSliderXOffset(mouseWidth);
                    double widthRatio = (double)mouseWidth / (double)sliderWidth;
                    siren.pitch.setValue((Object)ScreenAirRaidSiren.round(1.5 * widthRatio + 0.5, 1));
                }
            }
        });
        this.addComponent((AbstractScreenComponent)this.pitchSlider);
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(19, 95, 10, Color.TEXT_GRAY, (Component)Component.m_237113_((String)"0.5")));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(144, 95, 10, Color.TEXT_GRAY, (Component)Component.m_237113_((String)"2.0")));
        this.pitchSlider.updateActive(true);
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(19, 110, 10, Color.TEXT_GRAY, (Component)BallistixTextUtils.gui("airraidsiren.radius", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(140, 110, 10, Color.TEXT_GRAY, () -> {
            TileAirRaidSiren siren = (TileAirRaidSiren)((ContainerAirRaidSiren)this.m_6262_()).getSafeHost();
            if (siren == null) {
                return Component.m_237119_();
            }
            return Component.m_237113_((String)("" + siren.range.getValue()));
        }));
        this.rangeSlider = new ScreenComponentHorizontalSlider(20, 120, 138).setClickConsumer(mouseX -> {
            ScreenComponentHorizontalSlider slider = this.rangeSlider;
            TileAirRaidSiren siren = (TileAirRaidSiren)((ContainerAirRaidSiren)this.m_6262_()).getSafeHost();
            if (slider.isSliderActive() && siren != null) {
                int sliderX = slider.xLocation;
                int sliderWidth = slider.width;
                int mouseWidth = mouseX - sliderX;
                if (mouseWidth >= sliderWidth - 2 - 15) {
                    siren.range.setValue((Object)256);
                    slider.setSliderXOffset(sliderWidth - 2 - 15);
                } else if (mouseWidth <= 2) {
                    siren.range.setValue((Object)1);
                    slider.setSliderXOffset(0);
                } else {
                    double heightRatio = (double)mouseWidth / (double)sliderWidth;
                    siren.range.setValue((Object)((int)ScreenAirRaidSiren.round(255.0 * heightRatio + 1.0, 1)));
                    int moveRoom = slider.width - 15 - 2;
                    double moved = (double)((Integer)siren.range.getValue() - 1) / 255.0;
                    slider.setSliderXOffset((int)((double)moveRoom * moved + 1.0));
                }
            }
        }).setDragConsumer(mouseX -> {
            ScreenComponentHorizontalSlider slider = this.rangeSlider;
            TileAirRaidSiren siren = (TileAirRaidSiren)((ContainerAirRaidSiren)this.m_6262_()).getSafeHost();
            if (slider.isSliderActive() && siren != null) {
                int sliderX = slider.xLocation;
                int sliderWidth = slider.width;
                if (mouseX <= sliderX + 2) {
                    siren.range.setValue((Object)1);
                    slider.setSliderXOffset(0);
                } else if (mouseX >= sliderX + sliderWidth - 2 - 15) {
                    siren.range.setValue((Object)256);
                    slider.setSliderXOffset(sliderWidth - 2 - 15);
                } else {
                    int mouseWidth = mouseX - sliderX;
                    slider.setSliderXOffset(mouseWidth);
                    double widthRatio = (double)mouseWidth / (double)sliderWidth;
                    siren.range.setValue((Object)((int)ScreenAirRaidSiren.round(255.0 * widthRatio + 1.0, 1)));
                }
            }
        });
        this.addComponent((AbstractScreenComponent)this.rangeSlider);
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(19, 135, 10, Color.TEXT_GRAY, (Component)Component.m_237113_((String)"1")));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(140, 135, 10, Color.TEXT_GRAY, (Component)Component.m_237113_((String)"256")));
        this.rangeSlider.updateActive(true);
    }

    protected void m_181908_() {
        super.m_181908_();
        if (!this.hasInitHappened) {
            TileAirRaidSiren siren = (TileAirRaidSiren)((ContainerAirRaidSiren)this.m_6262_()).getSafeHost();
            if (siren == null) {
                return;
            }
            int moveRoom = this.volumeSlider.width - 15 - 2;
            double ratio = (Double)siren.volume.getValue() / 1.0;
            this.volumeSlider.setSliderXOffset((int)((double)moveRoom * ratio));
            moveRoom = this.pitchSlider.width - 15 - 2;
            ratio = ((Double)siren.pitch.getValue() - 0.5) / 1.5;
            this.pitchSlider.setSliderXOffset((int)((double)moveRoom * ratio + 0.5));
            moveRoom = this.rangeSlider.width - 15 - 2;
            ratio = (double)((Integer)siren.range.getValue() - 1) / 255.0;
            this.rangeSlider.setSliderXOffset((int)((double)moveRoom * ratio));
            this.hasInitHappened = true;
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollY) {
        TileAirRaidSiren siren = (TileAirRaidSiren)((ContainerAirRaidSiren)this.m_6262_()).getSafeHost();
        double scroll = 0.0;
        if (scrollY > 0.0) {
            scroll = 0.1;
        } else if (scrollY < 0.0) {
            scroll = -0.1;
        }
        if (Screen.m_96637_()) {
            scroll *= 10.0;
        }
        if (this.volumeSlider != null && siren != null && ScreenAirRaidSiren.isPointInRegion(this.volumeSlider.xLocation, this.volumeSlider.yLocation, mouseX - this.getGuiWidth(), mouseY - this.getGuiHeight(), this.volumeSlider.width, this.volumeSlider.height)) {
            int moveRoom = this.volumeSlider.width - 15 - 2;
            siren.volume.setValue((Object)ScreenAirRaidSiren.round(Mth.m_14008_((double)((Double)siren.volume.getValue() + scroll), (double)0.0, (double)1.0), 1));
            this.volumeSlider.setSliderXOffset((int)((Double)siren.volume.getValue() / 1.0 * (double)moveRoom));
            return true;
        }
        if (this.pitchSlider != null && siren != null && ScreenAirRaidSiren.isPointInRegion(this.pitchSlider.xLocation, this.pitchSlider.yLocation, mouseX - this.getGuiWidth(), mouseY - this.getGuiHeight(), this.pitchSlider.width, this.pitchSlider.height)) {
            int moveRoom = this.pitchSlider.width - 15 - 2;
            siren.pitch.setValue((Object)ScreenAirRaidSiren.round(Mth.m_14008_((double)((Double)siren.pitch.getValue() + scroll), (double)0.5, (double)2.0), 1));
            this.pitchSlider.setSliderXOffset((int)(((Double)siren.pitch.getValue() - 0.5) / 1.5 * (double)moveRoom));
            return true;
        }
        if (this.rangeSlider != null && siren != null && ScreenAirRaidSiren.isPointInRegion(this.rangeSlider.xLocation, this.rangeSlider.yLocation, mouseX - this.getGuiWidth(), mouseY - this.getGuiHeight(), this.rangeSlider.width, this.rangeSlider.height)) {
            int moveRoom = this.rangeSlider.width - 15 - 2;
            siren.range.setValue((Object)((int)ScreenAirRaidSiren.round(Mth.m_14008_((double)((double)((Integer)siren.range.getValue()).intValue() + (scroll *= 10.0)), (double)1.0, (double)256.0), 1)));
            this.rangeSlider.setSliderXOffset((int)((double)((Integer)siren.range.getValue() - 1) / 255.0 * (double)moveRoom));
            return true;
        }
        return super.m_6050_(mouseX, mouseY, scrollY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.volumeSlider != null && ScreenAirRaidSiren.isPointInRegion(this.volumeSlider.xLocation, this.volumeSlider.yLocation, mouseX - this.getGuiWidth(), mouseY - this.getGuiHeight(), this.volumeSlider.width, this.volumeSlider.height)) {
            this.volumeSlider.m_6375_(mouseX, mouseY, button);
        }
        if (this.pitchSlider != null && ScreenAirRaidSiren.isPointInRegion(this.pitchSlider.xLocation, this.pitchSlider.yLocation, mouseX - this.getGuiWidth(), mouseY - this.getGuiHeight(), this.pitchSlider.width, this.pitchSlider.height)) {
            this.pitchSlider.m_6375_(mouseX, mouseY, button);
        }
        if (this.rangeSlider != null && ScreenAirRaidSiren.isPointInRegion(this.rangeSlider.xLocation, this.rangeSlider.yLocation, mouseX - this.getGuiWidth(), mouseY - this.getGuiHeight(), this.rangeSlider.width, this.rangeSlider.height)) {
            this.rangeSlider.m_6375_(mouseX, mouseY, button);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.volumeSlider != null && ScreenAirRaidSiren.isPointInRegion(this.volumeSlider.xLocation, this.volumeSlider.yLocation, mouseX - this.getGuiWidth(), mouseY - this.getGuiHeight(), this.volumeSlider.width, this.volumeSlider.height)) {
            this.volumeSlider.m_6348_(mouseX, mouseY, button);
        }
        if (this.pitchSlider != null && ScreenAirRaidSiren.isPointInRegion(this.pitchSlider.xLocation, this.pitchSlider.yLocation, mouseX - this.getGuiWidth(), mouseY - this.getGuiHeight(), this.pitchSlider.width, this.pitchSlider.height)) {
            this.pitchSlider.m_6348_(mouseX, mouseY, button);
        }
        if (this.rangeSlider != null && ScreenAirRaidSiren.isPointInRegion(this.rangeSlider.xLocation, this.rangeSlider.yLocation, mouseX - this.getGuiWidth(), mouseY - this.getGuiHeight(), this.rangeSlider.width, this.rangeSlider.height)) {
            this.rangeSlider.m_6348_(mouseX, mouseY, button);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (ScreenAirRaidSiren.isPointInRegion(this.volumeSlider.xLocation, this.volumeSlider.yLocation, mouseX - this.getGuiWidth(), mouseY - this.getGuiHeight(), this.volumeSlider.width, this.volumeSlider.height)) {
            return this.volumeSlider.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        if (ScreenAirRaidSiren.isPointInRegion(this.pitchSlider.xLocation, this.pitchSlider.yLocation, mouseX - this.getGuiWidth(), mouseY - this.getGuiHeight(), this.pitchSlider.width, this.pitchSlider.height)) {
            return this.pitchSlider.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        if (ScreenAirRaidSiren.isPointInRegion(this.rangeSlider.xLocation, this.rangeSlider.yLocation, mouseX - this.getGuiWidth(), mouseY - this.getGuiHeight(), this.rangeSlider.width, this.rangeSlider.height)) {
            return this.rangeSlider.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    private static double round(double value, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        return (double)Math.round(value * (double)scale) / (double)scale;
    }

    private static boolean isPointInRegion(int x, int y, double xAxis, double yAxis, int width, int height) {
        return xAxis >= (double)x && xAxis <= (double)(x + width - 1) && yAxis >= (double)y && yAxis <= (double)(y + height - 1);
    }
}

