/*
 * Decompiled with CFR 0.152.
 */
package ballistix.client.screen;

import ballistix.common.inventory.container.ContainerFireControlRadar;
import ballistix.common.settings.BallistixConstants;
import ballistix.common.tile.radar.TileFireControlRadar;
import ballistix.prefab.BallistixIconTypes;
import ballistix.prefab.screen.ScreenComponentRadarGrid;
import ballistix.prefab.screen.WrapperFireControlFrequencyManager;
import ballistix.prefab.utils.BallistixTextUtils;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.phys.Vec3;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.screen.ITexture;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.screen.component.types.ScreenComponentCustomRender;
import voltaic.prefab.screen.component.types.ScreenComponentSlot;
import voltaic.prefab.screen.component.types.ScreenComponentVerticalSlider;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentElectricInfo;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentGuiTab;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.utilities.math.Color;

public class ScreenFireControlRadar
extends GenericScreen<ContainerFireControlRadar> {
    public final ScreenComponentVerticalSlider slider;
    public final WrapperFireControlFrequencyManager frequencyWrapper;
    public final ScreenComponentCustomRender trackingLabel;
    public final ScreenComponentRadarGrid radarGrid;

    public ScreenFireControlRadar(ContainerFireControlRadar container, Inventory inv, Component title) {
        super((GenericContainer)container, inv, title);
        this.addComponent((AbstractScreenComponent)new ScreenComponentElectricInfo(-25, 2).wattage(BallistixConstants.FIRE_CONTROL_RADAR_USAGE));
        this.addComponent((AbstractScreenComponent)new ScreenComponentGuiTab((ITexture)ScreenComponentGuiTab.GuiInfoTabTextures.REGULAR, (ITexture)ScreenComponentSlot.IconType.SONAR_PROFILE, () -> {
            ArrayList<FormattedCharSequence> info = new ArrayList<FormattedCharSequence>();
            TileFireControlRadar radar = (TileFireControlRadar)((ContainerFireControlRadar)this.f_97732_).getSafeHost();
            if (radar == null) {
                return info;
            }
            info.add(BallistixTextUtils.tooltip("turret.blockrange", new Object[0]).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
            info.add(BallistixTextUtils.tooltip("turret.maxrange", ChatFormatter.formatDecimals((double)BallistixConstants.FIRE_CONTROL_RADAR_RANGE, (int)1).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
            return info;
        }, -25, 28));
        this.frequencyWrapper = new WrapperFireControlFrequencyManager(this, -25, 54, 0, 0);
        this.slider = new ScreenComponentVerticalSlider(11, 80, 75).setClickConsumer(this.frequencyWrapper.getSliderClickedConsumer()).setDragConsumer(this.frequencyWrapper.getSliderDraggedConsumer());
        this.addComponent((AbstractScreenComponent)this.slider);
        this.slider.setVisible(false);
        this.trackingLabel = new ScreenComponentCustomRender(10, 20, graphics -> {
            TileFireControlRadar tile = (TileFireControlRadar)((ContainerFireControlRadar)this.f_97732_).getSafeHost();
            if (tile == null) {
                return;
            }
            MutableComponent radar = ((Vec3)tile.trackingPos.getValue()).equals((Object)TileFireControlRadar.OUT_OF_REACH) ? BallistixTextUtils.gui("turret.radarnone", new Object[0]).m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)new BlockPos((int)((Vec3)tile.trackingPos.getValue()).f_82479_, (int)((Vec3)tile.trackingPos.getValue()).f_82480_, (int)((Vec3)tile.trackingPos.getValue()).f_82481_).toString()).m_130940_(ChatFormatting.DARK_GRAY);
            int x = (int)(this.getGuiWidth() + 10.0);
            int y = (int)(this.getGuiHeight() + 20.0);
            MutableComponent label = BallistixTextUtils.gui("radar.tracking", new Object[0]).m_130940_(ChatFormatting.BLACK);
            int width = this.getFontRenderer().m_92852_((FormattedText)label);
            Objects.requireNonNull(this.getFontRenderer());
            int height = 9;
            graphics.m_280614_(this.getFontRenderer(), (Component)label, x, y, Color.WHITE.color(), false);
            x += width;
            float scale = 1.0f;
            width = this.f_96547_.m_92852_((FormattedText)radar);
            if (width > 100) {
                scale = 100.0f / (float)width;
            }
            float remHeight = ((float)height - (float)height * scale) / 2.0f;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)x, (float)y + remHeight, 0.0f);
            graphics.m_280168_().m_85841_(scale, scale, scale);
            graphics.m_280614_(this.getFontRenderer(), (Component)radar, 0, 0, Color.WHITE.color(), false);
            graphics.m_280168_().m_85849_();
        });
        this.addComponent((AbstractScreenComponent)this.trackingLabel);
        this.radarGrid = new ScreenComponentRadarGrid(27, 33, 121, 121);
        this.addComponent((AbstractScreenComponent)this.radarGrid);
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton((ITexture)ScreenComponentGuiTab.GuiInfoTabTextures.REGULAR, -25, 80).setOnPress(button -> {
            TileFireControlRadar tile = (TileFireControlRadar)((ContainerFireControlRadar)this.f_97732_).getSafeHost();
            if (tile == null) {
                return;
            }
            tile.usingRedstone.setValue((Object)((Boolean)tile.usingRedstone.getValue() == false ? 1 : 0));
        }).setIcon((ITexture)BallistixIconTypes.REDSTONE).onTooltip((graphics, button, x, y) -> {
            TileFireControlRadar tile = (TileFireControlRadar)((ContainerFireControlRadar)this.f_97732_).getSafeHost();
            if (tile == null) {
                return;
            }
            ArrayList<FormattedCharSequence> info = new ArrayList<FormattedCharSequence>();
            info.add(BallistixTextUtils.tooltip("radar.redstone", new Object[0]).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
            String key = (Boolean)tile.usingRedstone.getValue() != false ? "radar.redstone.enabled" : "radar.redstone.disabled";
            info.add(BallistixTextUtils.tooltip(key, new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}).m_7532_());
            graphics.m_280245_(this.getFontRenderer(), info, x, y);
        }));
    }

    protected void m_181908_() {
        super.m_181908_();
        this.frequencyWrapper.tick();
    }

    protected void initializeComponents() {
        super.initializeComponents();
        this.playerInvLabel.setVisible(false);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollY) {
        if (this.frequencyWrapper != null) {
            if (scrollY > 0.0) {
                this.frequencyWrapper.handleMouseScroll(-1);
            } else if (scrollY < 0.0) {
                this.frequencyWrapper.handleMouseScroll(1);
            }
        }
        return super.m_6050_(mouseX, mouseY, scrollY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.slider != null && this.slider.isVisible()) {
            this.slider.m_6375_(mouseX, mouseY, button);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.slider != null && this.slider.isVisible()) {
            this.slider.m_6348_(mouseX, mouseY, button);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)pKeyCode, (int)pScanCode);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey) && this.frequencyWrapper.addEditBox.isVisible() && this.frequencyWrapper.addEditBox.m_93696_()) {
            return false;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.slider.isVisible()) {
            return this.slider.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }
}

