/*
 * Decompiled with CFR 0.152.
 */
package ballistix.client.shake;

import ballistix.client.shake.PerlinNoise;

public class CameraShakeEffect {
    private final double duration;
    private final double fadeInTime;
    private final double fadeOutTime;
    private final double amplitude;
    private final double frequency;
    private final long startTime;
    private final PerlinNoise noise;
    private final double xOffsetSeed;
    private final double yOffsetSeed;

    public CameraShakeEffect(double duration, double fadeInTime, double fadeOutTime, double amplitude, double frequency, long worldTime, long seed) {
        this.duration = duration;
        this.fadeInTime = fadeInTime;
        this.fadeOutTime = fadeOutTime;
        this.amplitude = amplitude;
        this.frequency = frequency;
        this.startTime = worldTime;
        this.noise = new PerlinNoise(seed);
        this.xOffsetSeed = (double)seed * 1.37;
        this.yOffsetSeed = (double)seed * 2.17;
    }

    public float[] getShakeOffsets(long currentTime) {
        double elapsed = currentTime - this.startTime;
        if (elapsed < 0.0 || elapsed > this.duration) {
            return new float[]{0.0f, 0.0f};
        }
        double fadeMultiplier = this.computeFadeMultiplier(elapsed);
        double t = elapsed * this.frequency * 0.01;
        double noiseX = this.noise.noise(this.xOffsetSeed + t, 0.0, 0.0);
        double noiseY = this.noise.noise(this.yOffsetSeed + t, 0.0, 0.0);
        float yawOffset = (float)(noiseX * this.amplitude * fadeMultiplier);
        float pitchOffset = (float)(noiseY * this.amplitude * fadeMultiplier);
        return new float[]{yawOffset, pitchOffset};
    }

    private double computeFadeMultiplier(double elapsed) {
        if (elapsed < this.fadeInTime) {
            return elapsed / this.fadeInTime;
        }
        if (elapsed > this.duration - this.fadeOutTime) {
            double fadeOutStart = this.duration - this.fadeOutTime;
            return 1.0 - (elapsed - fadeOutStart) / this.fadeOutTime;
        }
        return 1.0;
    }

    public boolean isComplete(long currentTime) {
        return (double)(currentTime - this.startTime) > this.duration;
    }
}

