/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.blast.tier3;

import ballistix.api.blast.AntigravedChunk;
import ballistix.api.blast.IBlast;
import ballistix.common.blast.util.Blast;
import ballistix.common.block.subtype.SubtypeBlast;
import ballistix.common.settings.BallistixConstants;
import ballistix.registers.BallistixCapabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class BlastAntigravity
extends Blast {
    public BlastAntigravity(Level world, BlockPos position) {
        super(world, position);
    }

    @Override
    public IBlast getBlastType() {
        return SubtypeBlast.antigravity;
    }

    @Override
    public void doPreExplode() {
        if (!this.world.f_46443_) {
            this.world.m_5594_(null, this.position, SoundEvents.f_11860_, SoundSource.BLOCKS, 25.0f, 1.0f);
        }
    }

    @Override
    public boolean doExplode(int callCount) {
        super.doExplode(callCount);
        if (this.world.m_5776_()) {
            return false;
        }
        for (int i = -BallistixConstants.EXPLOSIVE_ANTIGRAVITY_CHUNKRADIUS; i < BallistixConstants.EXPLOSIVE_ANTIGRAVITY_CHUNKRADIUS; ++i) {
            for (int j = -BallistixConstants.EXPLOSIVE_ANTIGRAVITY_CHUNKRADIUS; j < BallistixConstants.EXPLOSIVE_ANTIGRAVITY_CHUNKRADIUS; ++j) {
                BlockPos pos = this.position.m_7918_(i * 16, 0, j * 16);
                ChunkPos chunkPos = new ChunkPos(pos);
                this.world.getCapability(BallistixCapabilities.ANTIGRAVED_CHUNKS).ifPresent(cap -> cap.activeChunks.add(new AntigravedChunk(chunkPos, BallistixConstants.EXPLOSIVE_ANTIGRAVITY_CHUNKDURATION)));
            }
        }
        return true;
    }
}

