/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.blast.util.thread.raycast;

import ballistix.common.blast.util.thread.raycast.IResistanceCallback;
import ballistix.common.blast.util.thread.raycast.ThreadRaycastBlast;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.prefab.block.HashDistanceBlockPos;

public class ThreadRaySideBlast
extends Thread {
    public final ThreadRaycastBlast mainBlast;
    public final Direction direction;
    private final RandomSource random = RandomSource.m_216337_();
    private static final float DEFAULT_POWER_DEC = 1.125f;

    public ThreadRaySideBlast(ThreadRaycastBlast threadRaycastBlast, Direction dir) {
        this.mainBlast = threadRaycastBlast;
        this.direction = dir;
        this.setName("Raycast Blast Side Thread");
        this.setPriority(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int explosionRadius = this.mainBlast.explosionRadius;
        BlockPos position = this.mainBlast.position;
        Level world = this.mainBlast.level;
        int iMin = -explosionRadius;
        int iMax = explosionRadius;
        int jMax = explosionRadius;
        int jMin = -explosionRadius;
        Vec3i orientation = this.direction.m_122436_();
        float explosionEnergy = this.mainBlast.explosionEnergy;
        IResistanceCallback callback = this.mainBlast.callBack;
        Entity explosionSource = this.mainBlast.explosionSource;
        boolean xNotZero = orientation.m_123341_() != 0;
        boolean yNotZero = orientation.m_123342_() != 0;
        boolean zNotZero = orientation.m_123343_() != 0;
        int expX = orientation.m_123341_() * explosionRadius;
        int expY = orientation.m_123342_() * explosionRadius;
        int expZ = orientation.m_123343_() * explosionRadius;
        HashSet<HashDistanceBlockPos> toadd = new HashSet<HashDistanceBlockPos>();
        for (int i = iMin; i < iMax; ++i) {
            block4: for (int j = jMin; j < jMax; ++j) {
                int x = 0;
                int y = 0;
                int z = 0;
                if (xNotZero) {
                    x = expX;
                    y += i;
                    z += j;
                } else if (yNotZero) {
                    x += i;
                    y = expY;
                    z += j;
                } else if (zNotZero) {
                    x += i;
                    y += j;
                    z = expZ;
                }
                BlockPos currentBlockPos = new BlockPos((Vec3i)position);
                float currentX = (float)position.m_123341_() + 0.5f;
                float currentY = (float)position.m_123342_() + 0.5f;
                float currentZ = (float)position.m_123343_() + 0.5f;
                float len = Mth.m_14116_((float)(x * x + y * y + z * z));
                float invLen = len == 0.0f ? 0.0f : 1.0f / len;
                float dx = (float)x * invLen;
                float dy = (float)y * invLen;
                float dz = (float)z * invLen;
                for (float power = explosionEnergy - explosionEnergy * this.random.m_188501_() / 2.0f; power > 0.0f; power -= 1.125f) {
                    BlockState block;
                    BlockPos next = new BlockPos((int)Math.floor(currentX), (int)Math.floor(currentY), (int)Math.floor(currentZ));
                    if (!next.equals((Object)currentBlockPos) && currentBlockPos != position && !(block = world.m_8055_(currentBlockPos = next)).m_60795_()) {
                        if (block.m_60800_((BlockGetter)world, currentBlockPos) >= 0.0f) {
                            if ((power -= Math.max(1.125f, callback.getResistance(world, position, currentBlockPos, explosionSource, block))) > 0.0f) {
                                int idistancesq = (int)(Math.pow(currentBlockPos.m_123341_() - position.m_123341_(), 2.0) + Math.pow(currentBlockPos.m_123342_() - position.m_123342_(), 2.0) + Math.pow(currentBlockPos.m_123343_() - position.m_123343_(), 2.0));
                                toadd.add(new HashDistanceBlockPos((double)currentBlockPos.m_123341_(), (double)currentBlockPos.m_123342_(), (double)currentBlockPos.m_123343_(), idistancesq));
                            }
                        } else {
                            power = 0.0f;
                            continue block4;
                        }
                    }
                    currentX += dx;
                    currentY += dy;
                    currentZ += dz;
                }
            }
        }
        Set<BlockPos> set = this.mainBlast.resultsSync;
        synchronized (set) {
            this.mainBlast.resultsSync.addAll(toadd);
        }
        this.mainBlast.underBlasts.remove(this);
    }
}

