/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.entity;

import ballistix.api.missile.MissileManager;
import ballistix.api.missile.virtual.VirtualProjectile;
import ballistix.client.particle.ParticleOptionsMissileSmoke;
import ballistix.common.settings.BallistixConstants;
import ballistix.registers.BallistixEntities;
import com.mojang.serialization.DynamicOps;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import voltaic.Voltaic;

public class EntitySAM
extends Entity {
    private static final float RAD2DEG = 57.29578f;
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.m_135353_(EntitySAM.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(EntitySAM.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    public UUID id;
    public float speed = 0.0f;
    public int variant = 0;

    public EntitySAM(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public EntitySAM(Level level) {
        this((EntityType)BallistixEntities.ENTITY_SAM.get(), level);
    }

    public void m_8119_() {
        float topSpeed;
        boolean isServer;
        Level level = this.m_9236_();
        boolean isClient = level.m_5776_();
        boolean bl = isServer = !isClient;
        if (this.f_19797_ > 30 && this.m_20184_().m_82553_() <= 0.0) {
            if (isServer) {
                this.m_6089_();
            }
            return;
        }
        if (isServer) {
            if (this.id == null) {
                this.m_6089_();
                return;
            }
            VirtualProjectile.VirtualSAM sam = MissileManager.getSAM((ResourceKey<Level>)level.m_46472_(), this.id);
            if (sam == null) {
                this.m_6089_();
                return;
            }
            if (sam.hasExploded()) {
                this.m_6089_();
                return;
            }
            if (!this.m_20183_().equals((Object)sam.blockPosition()) || !this.m_20184_().equals((Object)sam.deltaMovement)) {
                this.m_146884_(sam.position);
                this.speed = sam.speed;
                this.m_20256_(sam.deltaMovement);
            }
        }
        if (isServer) {
            this.f_19804_.m_135381_(SPEED, (Object)Float.valueOf(this.speed));
            this.f_19804_.m_135381_(VARIANT, (Object)this.variant);
        } else {
            this.speed = ((Float)this.f_19804_.m_135370_(SPEED)).floatValue();
            this.variant = (Integer)this.f_19804_.m_135370_(VARIANT);
        }
        this.m_146884_(new Vec3(this.m_20185_() + this.m_20184_().f_82479_ * (double)this.speed, this.m_20186_() + this.m_20184_().f_82480_ * (double)this.speed, this.m_20189_() + this.m_20184_().f_82481_ * (double)this.speed));
        this.m_146926_((float)(Math.atan(this.m_20184_().m_7098_() / Math.sqrt(this.m_20184_().m_7096_() * this.m_20184_().m_7096_() + this.m_20184_().m_7094_() * this.m_20184_().m_7094_())) * (double)57.29578f));
        this.m_146922_((float)(Math.atan2(this.m_20184_().m_7096_(), this.m_20184_().m_7094_()) * (double)57.29578f));
        float f = topSpeed = this.variant == 0 ? BallistixConstants.SAM_TOP_SPEED : BallistixConstants.ANTIBALLISTICMISSILE_TOP_SPEED;
        if (this.speed < topSpeed) {
            this.speed += this.variant == 0 ? BallistixConstants.SAM_ACCELERATION : BallistixConstants.ANTIBALLISTICMISSILE_ACCELERATION;
        }
        if (isServer || this.speed >= 3.0f) {
            return;
        }
        float x = (float)this.m_20185_();
        float y = (float)this.m_20186_();
        float z = (float)this.m_20189_();
        float motionX = (float)((double)this.speed * this.m_20184_().f_82479_);
        float motionY = (float)((double)this.speed * this.m_20184_().f_82480_);
        float motionZ = (float)((double)this.speed * this.m_20184_().f_82481_);
        x -= motionX;
        y -= motionY;
        z -= motionZ;
        for (int i = 0; i < (this.variant == 0 ? 2 : 4); ++i) {
            Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)new ParticleOptionsMissileSmoke().setParameters(1.0f, 1.0f, 1.0f, this.variant == 0 ? 0.2f : 0.5f, 50, true), (double)x, (double)y, (double)z, (double)(-motionX) * (0.4 + 0.2 * Voltaic.RANDOM.nextDouble()), (double)(-motionY) * (0.4 + 0.2 * Voltaic.RANDOM.nextDouble()), (double)(-motionZ) * (0.4 + 0.2 * Voltaic.RANDOM.nextDouble()));
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SPEED, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    protected void m_7378_(CompoundTag compound) {
        ServerLevel server;
        Level level = this.m_9236_();
        if (!(!(level instanceof ServerLevel) || (server = (ServerLevel)level).m_143340_(this.m_20183_()) && server.m_46805_(this.m_20183_()))) {
            this.m_142467_(Entity.RemovalReason.DISCARDED);
        }
        if (this.id != null) {
            UUIDUtil.f_235867_.encode((Object)this.id, (DynamicOps)NbtOps.f_128958_, (Object)new CompoundTag()).result().ifPresent(tag -> compound.m_128365_("id", tag));
        }
        this.speed = compound.m_128457_("speed");
        this.variant = compound.m_128451_("variant");
    }

    protected void m_7380_(CompoundTag compound) {
        UUIDUtil.f_235867_.decode((DynamicOps)NbtOps.f_128958_, (Object)compound.m_128469_("id")).result().ifPresent(pair -> {
            this.id = (UUID)pair.getFirst();
        });
        compound.m_128350_("speed", this.speed);
        compound.m_128405_("variant", this.variant);
    }

    public boolean m_6087_() {
        return true;
    }

    protected boolean m_7341_(Entity vehicle) {
        return true;
    }

    public void m_6043_() {
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_36341_()) {
            return InteractionResult.PASS;
        }
        if (!this.m_9236_().f_46443_) {
            return player.m_7998_((Entity)this, true) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        VirtualProjectile.VirtualSAM missile;
        if (!this.m_9236_().f_46443_ && this.id != null && (missile = MissileManager.getSAM((ResourceKey<Level>)this.m_9236_().m_46472_(), this.id)) != null) {
            missile.setSpawned(false, -1);
        }
        super.m_142687_(reason);
    }

    public boolean m_142389_() {
        return true;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

