/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.tile;

import ballistix.common.block.subtype.SubtypeBallistixMachine;
import ballistix.common.inventory.container.ContainerESMTower;
import ballistix.common.settings.BallistixConstants;
import ballistix.common.tile.radar.TileFireControlRadar;
import ballistix.common.tile.radar.TileSearchRadar;
import ballistix.registers.BallistixTiles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import voltaic.api.multiblock.subnodebased.TileMultiSubnode;
import voltaic.api.multiblock.subnodebased.parent.IMultiblockParentBlock;
import voltaic.api.multiblock.subnodebased.parent.IMultiblockParentTile;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.ListProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentForgeEnergy;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileESMTower
extends GenericTile
implements IMultiblockParentTile {
    public static final ConcurrentHashMap<ResourceKey<Level>, HashSet<TileSearchRadar>> SEARCH_RADARS = new ConcurrentHashMap();
    public static final ConcurrentHashMap<ResourceKey<Level>, HashSet<TileFireControlRadar>> FIRE_CONTROL_RADARS = new ConcurrentHashMap();
    public static final ConcurrentHashMap<ResourceKey<Level>, HashSet<TileESMTower>> ESM_TOWERS = new ConcurrentHashMap();
    public final SingleProperty<Boolean> active = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "active", (Object)false));
    public final SingleProperty<Boolean> searchRadarDetected = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "searchradar", (Object)false));
    public final ListProperty<BlockPos> fireControlRadars = (ListProperty)((ListProperty)this.property((AbstractProperty)new ListProperty(PropertyTypes.BLOCK_POS_LIST, "firecontrolradars", new ArrayList()))).setNoUpdateServer();
    private final AABB searchArea = new AABB(this.m_58899_()).m_82400_(BallistixConstants.ESM_TOWER_SEARCH_RADIUS);

    public TileESMTower(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)BallistixTiles.TILE_ESMTOWER.get(), worldPos, blockState);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).voltage(480.0).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).maxJoules(BallistixConstants.ESM_TOWER_USAGE_PER_TICK * 20.0));
        this.addComponent((IComponent)new ComponentContainerProvider("esmtower", (GenericTile)this).createMenu((id, player) -> new ContainerESMTower((int)id, (Inventory)player, (Container)new SimpleContainer(0), (ContainerData)this.getCoordsArray())));
        this.addComponent((IComponent)new ComponentForgeEnergy((GenericTile)this));
    }

    public void tickServer(ComponentTickable tickable) {
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        this.active.setValue((Object)(electro.getJoulesStored() > BallistixConstants.ESM_TOWER_USAGE_PER_TICK && this.f_58857_.m_45517_(LightLayer.SKY, this.m_58899_()) > 0 ? 1 : 0));
        if (!((Boolean)this.active.getValue()).booleanValue()) {
            TileESMTower.removeESMTower(this);
            this.searchRadarDetected.setValue((Object)false);
            this.fireControlRadars.wipeList();
            return;
        }
        TileESMTower.addESMTower(this);
        this.searchRadarDetected.setValue((Object)false);
        this.fireControlRadars.wipeList();
        for (GenericTile radar : SEARCH_RADARS.getOrDefault(this.m_58904_().m_46472_(), new HashSet())) {
            if (!this.searchArea.m_82381_(new AABB(radar.m_58899_()))) continue;
            this.searchRadarDetected.setValue((Object)true);
            break;
        }
        for (GenericTile radar : FIRE_CONTROL_RADARS.getOrDefault(this.m_58904_().m_46472_(), new HashSet())) {
            if (!this.searchArea.m_82381_(new AABB(radar.m_58899_()))) continue;
            this.fireControlRadars.addValue((Object)radar.m_58899_());
        }
    }

    public IMultiblockParentBlock.SubnodeWrapper getSubNodes() {
        return SubtypeBallistixMachine.Subnodes.ESM_TOWER;
    }

    public InteractionResult onSubnodeUse(Player player, InteractionHand hand, BlockHitResult hit, TileMultiSubnode subnode) {
        return this.use(player, hand, hit);
    }

    public void onSubnodeDestroyed(TileMultiSubnode tileMultiSubnode) {
        this.f_58857_.m_46961_(this.f_58858_, true);
    }

    public Direction getFacingDirection() {
        return this.getFacing();
    }

    public static void removeSearchRadar(TileSearchRadar radar) {
        SEARCH_RADARS.getOrDefault(radar.m_58904_().m_46472_(), new HashSet()).remove((Object)radar);
    }

    public static void removeFireControlRadar(TileFireControlRadar radar) {
        FIRE_CONTROL_RADARS.getOrDefault(radar.m_58904_().m_46472_(), new HashSet()).remove((Object)radar);
    }

    public static void removeESMTower(TileESMTower esm) {
        ESM_TOWERS.getOrDefault(esm.m_58904_().m_46472_(), new HashSet()).remove((Object)esm);
    }

    public static void addSearchRadar(TileSearchRadar radar) {
        HashSet<TileSearchRadar> radars = SEARCH_RADARS.getOrDefault(radar.m_58904_().m_46472_(), new HashSet());
        radars.add(radar);
        SEARCH_RADARS.put((ResourceKey<Level>)radar.m_58904_().m_46472_(), radars);
    }

    public static void addFireControlRadar(TileFireControlRadar radar) {
        HashSet<TileFireControlRadar> radars = FIRE_CONTROL_RADARS.getOrDefault(radar.m_58904_().m_46472_(), new HashSet());
        radars.add(radar);
        FIRE_CONTROL_RADARS.put((ResourceKey<Level>)radar.m_58904_().m_46472_(), radars);
    }

    public static void addESMTower(TileESMTower esm) {
        HashSet<TileESMTower> esmTowers = ESM_TOWERS.getOrDefault(esm.m_58904_().m_46472_(), new HashSet());
        esmTowers.add(esm);
        ESM_TOWERS.put((ResourceKey<Level>)esm.m_58904_().m_46472_(), esmTowers);
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82377_(0.0, 2.0, 0.0);
    }

    @Mod.EventBusSubscriber(modid="ballistix", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class MapHandlerer {
        @SubscribeEvent
        public static void clearMaps(TickEvent.ServerTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            for (Map.Entry<ResourceKey<Level>, HashSet<TileSearchRadar>> entry : SEARCH_RADARS.entrySet()) {
                Iterator<TileSearchRadar> it = entry.getValue().iterator();
                while (it.hasNext()) {
                    TileSearchRadar radar = it.next();
                    if (radar != null && !radar.m_58901_()) continue;
                    it.remove();
                }
            }
            for (Map.Entry<ResourceKey<Level>, HashSet<TileFireControlRadar>> entry : FIRE_CONTROL_RADARS.entrySet()) {
                Iterator<TileFireControlRadar> it = entry.getValue().iterator();
                while (it.hasNext()) {
                    TileFireControlRadar radar = it.next();
                    if (radar != null && !radar.m_58901_()) continue;
                    it.remove();
                }
            }
            for (Map.Entry<ResourceKey<Level>, HashSet<TileESMTower>> entry : ESM_TOWERS.entrySet()) {
                Iterator<TileESMTower> it = entry.getValue().iterator();
                while (it.hasNext()) {
                    TileESMTower radar = it.next();
                    if (radar != null && !radar.m_58901_()) continue;
                    it.remove();
                }
            }
        }
    }
}

