/*
 * Decompiled with CFR 0.152.
 */
package ballistix.prefab.screen;

import ballistix.client.screen.ScreenFireControlRadar;
import ballistix.common.inventory.container.ContainerFireControlRadar;
import ballistix.common.settings.BallistixConstants;
import ballistix.common.tile.radar.TileFireControlRadar;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.phys.Vec3;
import voltaic.prefab.screen.component.ScreenComponentGeneric;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.math.Color;
import voltaic.prefab.utilities.math.MathUtils;

public class ScreenComponentRadarGrid
extends ScreenComponentGeneric {
    private static final Color RADAR_BLACK = new Color(0, 0, 0, 255);
    private static final Color RADAR_GRID_GREEN = new Color(19, 125, 62, 255);
    private static final Color RADAR_PULSE_GREEN = new Color(38, 253, 9, 255);

    public ScreenComponentRadarGrid(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public void renderBackground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        int i;
        int x = this.xLocation + guiWidth;
        int y = this.yLocation + guiHeight;
        TileFireControlRadar tile = (TileFireControlRadar)((ContainerFireControlRadar)((ScreenFireControlRadar)this.gui).m_6262_()).getSafeHost();
        if (tile == null) {
            return;
        }
        graphics.m_280509_(x, y, x + this.width, y + this.height, RADAR_BLACK.color());
        int gridWidth = 12;
        for (i = 1; i < 10; ++i) {
            graphics.m_280509_(x + 1, y + gridWidth * i, x + this.width - 1, y + 1 + gridWidth * i, RADAR_GRID_GREEN.color());
        }
        for (i = 1; i < 10; ++i) {
            graphics.m_280509_(x + gridWidth * i, y + 1, x + 1 + gridWidth * i, y + this.height - 1, RADAR_GRID_GREEN.color());
        }
        if (!((Boolean)tile.running.getValue()).booleanValue()) {
            graphics.m_280509_(x - 3, y - 3, x + 1, y + this.height + 3, Color.TEXT_GRAY.color());
            graphics.m_280509_(x + this.width - 1, y - 3, x + this.width + 3, y + this.height + 3, Color.TEXT_GRAY.color());
            graphics.m_280509_(x, y - 3, x + this.width, y + 1, Color.TEXT_GRAY.color());
            graphics.m_280509_(x, y + this.height - 1, x + this.width, y + this.height + 3, Color.TEXT_GRAY.color());
            return;
        }
        float center = (float)(this.width - 2) / 2.0f + 1.0f;
        float ratio = (float)(((ComponentTickable)tile.getComponent(IComponentType.Tickable)).getTicks() % 25L) / 25.0f;
        float theta = ratio * 360.0f;
        float quad = theta % 90.0f;
        if (quad > 45.0f) {
            quad = 90.0f - quad;
        }
        float angleRad = (float)((double)(quad / 180.0f) * Math.PI);
        float leg = (float)Math.abs(Math.tan(angleRad)) * center;
        float hyp = (float)Math.sqrt(leg * leg + center * center);
        float extra = hyp - center;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)x + center, (float)y + center, 0.0f);
        graphics.m_280168_().m_252781_(MathUtils.rotQuaternionDeg((float)0.0f, (float)0.0f, (float)theta));
        graphics.m_280168_().m_252880_((float)(-x) - center, (float)(-y) - center, 0.0f);
        graphics.m_280509_((int)Math.floor((float)(x + 1) - extra - 2.0f), (int)Math.floor((float)y + center - 1.0f), (int)Math.ceil((float)x + center), (int)Math.ceil((float)y + center + 1.0f), RADAR_PULSE_GREEN.color());
        graphics.m_280168_().m_85849_();
        graphics.m_280509_(x - 3, y - 3, x + 1, y + this.height + 3, Color.TEXT_GRAY.color());
        graphics.m_280509_(x + this.width - 1, y - 3, x + this.width + 3, y + this.height + 3, Color.TEXT_GRAY.color());
        graphics.m_280509_(x, y - 3, x + this.width, y + 1, Color.TEXT_GRAY.color());
        graphics.m_280509_(x, y + this.height - 1, x + this.width, y + this.height + 3, Color.TEXT_GRAY.color());
        graphics.m_280509_((int)Math.floor((float)x + center - 1.0f), (int)Math.floor((float)y + center - 1.0f), (int)Math.ceil((float)x + center + 1.0f), (int)Math.ceil((float)y + center + 1.0f), Color.JEI_TEXT_GRAY.color());
        if (((Vec3)tile.trackingPos.getValue()).equals((Object)TileFireControlRadar.OUT_OF_REACH)) {
            return;
        }
        float deltaX = (float)((((Vec3)tile.trackingPos.getValue()).f_82479_ - (double)tile.m_58899_().m_123341_()) / (double)(2.0f * (float)BallistixConstants.FIRE_CONTROL_RADAR_RANGE)) * (float)this.width;
        float deltaZ = (float)((((Vec3)tile.trackingPos.getValue()).f_82481_ - (double)tile.m_58899_().m_123343_()) / (double)(2.0f * (float)BallistixConstants.FIRE_CONTROL_RADAR_RANGE)) * (float)this.width;
        double angleRads = Math.atan2(deltaZ, deltaX);
        float dotTheta = (float)(angleRads / Math.PI * 180.0) + 180.0f;
        int alpha = (int)((dotTheta + 360.0f - theta) / 360.0f * 255.0f);
        graphics.m_280509_((int)Math.floor((float)x + center + deltaX - 1.0f), (int)Math.floor((float)y + center + deltaZ - 1.0f), (int)Math.ceil((float)x + center + deltaX + 1.0f), (int)Math.ceil((float)y + center + deltaZ + 1.0f), new Color(255, 0, 0, alpha).color());
    }
}

