/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.integration.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.utility.BnCTextUtils;
import umpaz.brewinandchewin.integration.emi.BnCRecipeCategories;
import umpaz.brewinandchewin.integration.emi.recipe.KegEmiRecipe;
import umpaz.brewinandchewin.integration.emi.widget.BnCFluidWidget;
import vectorwing.farmersdelight.common.utility.ClientRenderUtils;

public class FermentingEmiRecipe
implements KegEmiRecipe {
    public static final ResourceLocation BACKGROUND = BrewinAndChewin.asResource("textures/gui/emi/fermenting.png");
    private final ResourceLocation id;
    private final List<EmiIngredient> itemInputs;
    @Nullable
    private final EmiIngredient itemFluidInput;
    @Nullable
    private final EmiIngredient fluidInput;
    private final EmiStack output;
    private final int temperature;
    private final int cookTime;
    private final float experience;
    private List<EmiIngredient> inputs;
    private static final Random RANDOM = new Random();

    public FermentingEmiRecipe(ResourceLocation id, List<EmiIngredient> itemInputs, @Nullable EmiIngredient itemFluidInput, @Nullable EmiIngredient fluidInput, EmiStack output, int temperature, int cookTime, float experience) {
        this.id = id;
        this.itemInputs = itemInputs;
        this.itemFluidInput = itemFluidInput;
        this.output = output;
        this.fluidInput = fluidInput;
        this.temperature = temperature;
        this.cookTime = cookTime;
        this.experience = experience;
    }

    public EmiRecipeCategory getCategory() {
        return BnCRecipeCategories.FERMENTING;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public List<EmiIngredient> getInputs() {
        if (this.inputs == null) {
            ArrayList<EmiIngredient> ingredients = new ArrayList<EmiIngredient>(this.itemInputs);
            if (this.fluidInput != null) {
                ingredients.add(this.fluidInput);
            }
            this.inputs = List.copyOf(ingredients);
        }
        return this.inputs;
    }

    @Override
    public List<EmiIngredient> getItemInputs() {
        return this.itemInputs;
    }

    @Override
    @Nullable
    public EmiIngredient getFluidInput() {
        return this.fluidInput;
    }

    @Override
    @Nullable
    public EmiIngredient getFluidItemInput() {
        return this.itemFluidInput;
    }

    public List<EmiIngredient> getCatalysts() {
        if (this.itemFluidInput != null) {
            return List.of(this.itemFluidInput);
        }
        return List.of();
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.output);
    }

    public int getDisplayWidth() {
        return 136;
    }

    public int getDisplayHeight() {
        return 49;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(BACKGROUND, 0, 0, 138, 49, 10, 11);
        int borderSlotSize = 18;
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 2; ++column) {
                int inputIndex = row * 2 + column;
                if (inputIndex >= this.itemInputs.size()) continue;
                this.addSlot(widgets, this.itemInputs.get(inputIndex), column * borderSlotSize + 30, row * borderSlotSize + 2);
            }
        }
        if (this.fluidInput != null) {
            widgets.add((Widget)new BnCFluidWidget(this.fluidInput, RANDOM.nextInt(), 1, 3));
        }
        if (this.output.getKeyOfType(Fluid.class) != null) {
            ((BnCFluidWidget)widgets.add((Widget)new BnCFluidWidget((EmiIngredient)this.output, RANDOM.nextInt(), 101, 3))).recipeContext(this);
        } else {
            this.addSlot(widgets, (EmiIngredient)this.output, 106, 6).recipeContext((EmiRecipe)this);
        }
        widgets.addAnimatedTexture(BACKGROUND, 69, 12, 23, 16, 171, 4, 10000, true, false, false);
        if (this.temperature <= 2) {
            widgets.addTexture(BACKGROUND, 35, 41, 9, 3, 178, 0);
        }
        if (this.temperature <= 1) {
            widgets.addTexture(BACKGROUND, 27, 41, 8, 3, 170, 0);
        }
        if (this.temperature >= 4) {
            widgets.addTexture(BACKGROUND, 52, 41, 9, 3, 195, 0);
        }
        if (this.temperature >= 5) {
            widgets.addTexture(BACKGROUND, 61, 41, 8, 3, 204, 0);
        }
        widgets.addTexture(BACKGROUND, 72, 4, 8, 11, 170, 21);
        if (this.experience > 0.0f) {
            widgets.addTexture(BACKGROUND, 71, 23, 9, 9, 170, 32);
        }
        widgets.addTooltip(this::getTooltips, 0, 0, widgets.getWidth(), widgets.getHeight());
    }

    private SlotWidget addSlot(WidgetHolder widgets, EmiIngredient ingredient, int x, int y) {
        return (SlotWidget)widgets.add((Widget)new SlotWidget(ingredient, x, y){

            public void drawBackground(GuiGraphics draw, int mouseX, int mouseY, float delta) {
            }
        });
    }

    public List<ClientTooltipComponent> getTooltips(double mouseX, double mouseY) {
        ArrayList<ClientTooltipComponent> tooltip = new ArrayList<ClientTooltipComponent>();
        if (ClientRenderUtils.isCursorInsideBounds((int)68, (int)2, (int)22, (int)28, (double)mouseX, (double)mouseY)) {
            if (this.cookTime > 0) {
                tooltip.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237110_((String)"brewinandchewin.emi.cooking.time.minutes", (Object[])new Object[]{Float.valueOf((float)this.cookTime / 20.0f / 60.0f)}).m_7532_()));
            }
            if (this.experience > 0.0f) {
                tooltip.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237110_((String)"emi.cooking.experience", (Object[])new Object[]{Float.valueOf(this.experience)}).m_7532_()));
            }
        } else if (ClientRenderUtils.isCursorInsideBounds((int)26, (int)41, (int)44, (int)5, (double)mouseX, (double)mouseY)) {
            MutableComponent key;
            switch (this.temperature) {
                case 1: {
                    MutableComponent mutableComponent = BnCTextUtils.getTranslation("container.keg.cold", new Object[0]);
                    break;
                }
                case 2: {
                    MutableComponent mutableComponent = BnCTextUtils.getTranslation("container.keg.chilly", new Object[0]);
                    break;
                }
                case 3: {
                    MutableComponent mutableComponent = BnCTextUtils.getTranslation("container.keg.normal", new Object[0]);
                    break;
                }
                case 4: {
                    MutableComponent mutableComponent = BnCTextUtils.getTranslation("container.keg.warm", new Object[0]);
                    break;
                }
                case 5: {
                    MutableComponent mutableComponent = BnCTextUtils.getTranslation("container.keg.hot", new Object[0]);
                    break;
                }
                default: {
                    MutableComponent mutableComponent = key = null;
                }
            }
            if (key != null) {
                tooltip.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)key.m_7532_()));
            }
        }
        return tooltip;
    }
}

