/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.simple;

import java.util.List;
import team.creative.creativecore.common.gui.controls.simple.GuiStateButton;
import team.creative.creativecore.common.util.text.TextMapBuilder;

public class GuiStateButtonMapped<K>
extends GuiStateButton {
    private final List<K> keys;

    public GuiStateButtonMapped(String name, TextMapBuilder<K> lines) {
        super(name, lines);
        this.keys = lines.keys();
    }

    public GuiStateButtonMapped(String name, int index, TextMapBuilder<K> lines) {
        super(name, lines);
        this.keys = lines.keys();
        this.setState(index);
    }

    public GuiStateButtonMapped(String name, K selected, TextMapBuilder<K> lines) {
        super(name, lines);
        this.keys = lines.keys();
        this.select(selected);
    }

    public K getSelected() {
        int index = this.getState();
        if (index < this.keys.size()) {
            return this.keys.get(index);
        }
        return null;
    }

    public K getSelected(K defaultValue) {
        int index = this.getState();
        if (index < this.keys.size()) {
            return this.keys.get(index);
        }
        return defaultValue;
    }

    public void select(K key) {
        int index = this.keys.indexOf(key);
        if (index != -1) {
            this.setState(index);
        }
    }
}

