/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.brnbrd.delightful.common.DelightfulConfig;
import net.brnbrd.delightful.common.item.DelightfulItems;
import net.brnbrd.delightful.common.item.IConfigured;
import net.brnbrd.delightful.compat.Modid;
import net.brnbrd.delightful.compat.Mods;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.registries.tags.ITagManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static final String EMPTY_STR = "";
    public static final Modid[] EMPTY = new Modid[0];
    public static final String MC = "minecraft";
    public static final String LOADER = "forge";
    public static final UUID BLOCK_REACH = UUID.fromString("C18598A9-F66A-44E7-9CE1-99B1EE178678");
    public static final UUID ENTITY_REACH = UUID.fromString("61F992E6-276F-4D2B-88A7-823CB64BA459");

    public static ResourceLocation rl(@NotNull String modid, @NotNull String path) {
        return new ResourceLocation(modid, path);
    }

    public static ResourceLocation rl(@NotNull Modid modid, @NotNull String path) {
        return Util.rl(modid.get(), path);
    }

    public static ResourceLocation rl(@NotNull String separated) {
        return new ResourceLocation(separated);
    }

    public static ResourceLocation rl(ItemLike itemLike) {
        Block block;
        IForgeRegistry reg;
        if (itemLike instanceof Item) {
            IForgeRegistry reg2 = ForgeRegistries.ITEMS;
            Item item = (Item)itemLike;
            if (reg2.containsValue((Object)item)) {
                return reg2.getKey((Object)item);
            }
        } else if (itemLike instanceof Block && (reg = ForgeRegistries.BLOCKS).containsValue((Object)(block = (Block)itemLike))) {
            return reg.getKey((Object)block);
        }
        return Util.rl(EMPTY_STR, EMPTY_STR);
    }

    public static ResourceLocation delight(String path) {
        return Util.rl("delightful", path);
    }

    public static TagKey<Item> it(String id, String path) {
        return ItemTags.create((ResourceLocation)Util.rl(id, path));
    }

    public static TagKey<EntityType<?>> et(Modid modid, String path) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)Util.rl(modid, path));
    }

    public static TagKey<EntityType<?>> et(String id, String path) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)Util.rl(id, path));
    }

    public static boolean tagEmpty(@Nullable TagKey<Item> tag) {
        if (tag == null) {
            return true;
        }
        ITagManager tags = ForgeRegistries.ITEMS.tags();
        return tags != null && (!tags.isKnownTagName(tag) || tags.getTag(tag).isEmpty());
    }

    public static boolean tagPopulated(@Nullable TagKey<Item> tag) {
        if (tag == null) {
            return true;
        }
        ITagManager tags = ForgeRegistries.ITEMS.tags();
        return tags != null && tags.isKnownTagName(tag) && !tags.getTag(tag).isEmpty();
    }

    public static String tagName(TagKey<?> tagKey) {
        return tagKey.f_203868_().toString();
    }

    public static MutableComponent tagComponent(TagKey<?> tagKey) {
        return Component.m_237113_((String)Util.tagName(tagKey));
    }

    public static ObjectArrayList<ItemStack> with(ObjectArrayList<ItemStack> before, ItemStack addition) {
        before.add((Object)addition);
        return before.clone();
    }

    public static ObjectArrayList<ItemStack> with(ObjectArrayList<ItemStack> before, Item addition, int count) {
        return count < 1 ? before : Util.with(before, new ItemStack((ItemLike)addition, count));
    }

    public static ObjectArrayList<ItemStack> with(ObjectArrayList<ItemStack> before, Item addition, RandomSource rand, int min, int max) {
        if (max < min) {
            return before;
        }
        return Util.with(before, addition, max == min ? min : rand.m_216332_(min, max));
    }

    public static ObjectArrayList<ItemStack> with(ObjectArrayList<ItemStack> before, Item addition) {
        return Util.with(before, addition, 1);
    }

    public static boolean itemExists(ResourceLocation location) {
        return Mods.stringLoaded(location.m_135827_()) && ForgeRegistries.ITEMS.containsKey(location);
    }

    public static boolean blockExists(ResourceLocation location) {
        return Mods.stringLoaded(location.m_135827_()) && ForgeRegistries.BLOCKS.containsKey(location);
    }

    @Nullable
    public static Item item(ResourceLocation rl) {
        return (Item)ForgeRegistries.ITEMS.getValue(rl);
    }

    @Nullable
    public static Item item(String id, String path) {
        return Util.item(Util.rl(id, path));
    }

    @NotNull
    public static Item item(ResourceLocation location, @NotNull Item backup) {
        Item item;
        if (Util.itemExists(location) && (item = Util.item(location)) != null) {
            return item;
        }
        return backup;
    }

    @NotNull
    public static Item item(ResourceLocation location, @NotNull Supplier<Item> backup) {
        return Util.item(location, backup.get());
    }

    @NotNull
    public static ItemStack itemStack(ResourceLocation location, @NotNull ItemStack backup) {
        Item returnItem;
        if (Util.itemExists(location) && (returnItem = Util.item(location)) != null) {
            return new ItemStack((ItemLike)returnItem);
        }
        return backup;
    }

    public static boolean itemStackIs(ItemStack stack, ResourceLocation location) {
        return Util.itemExists(location) && stack.m_150930_(Util.item(location));
    }

    @Nullable
    public static Block block(Modid modid, String path) {
        return Util.block(Util.rl(modid, path));
    }

    @Nullable
    public static Block block(String id, String path) {
        return Util.block(Util.rl(id, path));
    }

    @Nullable
    public static Block block(ResourceLocation rl) {
        return (Block)ForgeRegistries.BLOCKS.getValue(rl);
    }

    public static boolean effectExists(ResourceLocation effect) {
        return Mods.stringLoaded(effect.m_135827_()) && ForgeRegistries.MOB_EFFECTS.containsKey(effect);
    }

    @Nullable
    private static MobEffect getBackup(@Nullable MobEffect[] backup) {
        return backup != null && backup.length > 0 ? backup[0] : null;
    }

    @Nullable
    public static MobEffect effect(ResourceLocation effLocation, MobEffect ... backup) {
        return Util.effectExists(effLocation) ? (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effLocation) : Util.getBackup(backup);
    }

    @Nullable
    public static MobEffect effect(String id, String name, MobEffect ... backup) {
        return Util.effect(Util.rl(id, name), backup);
    }

    @Nullable
    public static MobEffect effect(Modid modid, String name, MobEffect ... backup) {
        return modid.loaded() ? Util.effect(Util.rl(modid, name), backup) : Util.getBackup(backup);
    }

    public static void addEffect(LivingEntity entity, @Nullable MobEffect effect, int duration, int amp) {
        if (effect != null) {
            entity.m_7292_(new MobEffectInstance(effect, duration, amp));
        }
    }

    public static void addEffect(LivingEntity entity, String modid, String name, int duration, int amp, MobEffect ... backup) {
        MobEffect me = Util.effect(modid, name, backup);
        if (me != null) {
            Util.addEffect(entity, me, duration, amp);
        }
    }

    public static ItemStack gs(@Nullable @Nullable Supplier<@Nullable Item> r, int ... count) {
        if (r == null || r.get() == null) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)Objects.requireNonNull(r.get()), count.length > 0 ? count[0] : 1);
    }

    public static String nameSpace(ItemLike itemLike) {
        return Util.rl(itemLike).m_135827_();
    }

    public static String name(ItemLike itemLike) {
        return Util.rl(itemLike).m_135815_();
    }

    public static String name(RegistryObject<?> reg) {
        return reg.getId().m_135815_();
    }

    public static String nameSpace(ItemStack stack) {
        return Util.nameSpace((ItemLike)stack.m_41720_());
    }

    public static String name(ItemStack stack) {
        return Util.name((ItemLike)stack.m_41720_());
    }

    public static String id(ItemLike item) {
        return Util.rl(item).toString();
    }

    public static Ingredient ing(Supplier<? extends ItemLike> i) {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{i.get()});
    }

    public static ItemStack enchant(ItemStack stack, Enchantment enchantment, int level) {
        ItemStack enchanted = stack.m_41777_();
        enchanted.m_41663_(enchantment, level);
        return enchanted;
    }

    public static void drop(Level level, ItemStack stack, BlockPos pos, Direction dir) {
        RandomSource random = level.m_213780_();
        ItemEntity dropItem = new ItemEntity(level, (double)pos.m_123341_() + 0.5 + (double)dir.m_122429_() * 0.65, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5 + (double)dir.m_122431_() * 0.65, stack);
        dropItem.m_20334_(0.05 * (double)dir.m_122429_() + random.m_188500_() * 0.02, 0.05, 0.05 * (double)dir.m_122431_() + random.m_188500_() * 0.02);
        level.m_7967_((Entity)dropItem);
    }

    public static void dropOrGive(ItemStack stack, Level level, BlockPos pos, Direction direction, Player give) {
        if (stack == null || stack.m_41619_() || stack.m_41613_() < 1) {
            return;
        }
        if (((Boolean)DelightfulConfig.GIVE_SLICED_DIRECTLY.get()).booleanValue()) {
            ItemHandlerHelper.giveItemToPlayer((Player)give, (ItemStack)stack, (int)0);
        } else {
            Util.drop(level, stack, pos, direction);
        }
    }

    public static void dropOrGive(ItemStack stack, Level level, BlockPos pos, Player give) {
        Util.dropOrGive(stack, level, pos, give.m_6350_().m_122424_(), give);
    }

    public static boolean hasTagString(ItemStack stack, String key, String value) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            return tag != null && tag.m_128441_(key) && tag.m_128461_(key).equals(value);
        }
        return false;
    }

    public static boolean configEnabled(String item) {
        return DelightfulConfig.CONFIG.verify(item);
    }

    public static boolean configEnabled(Item item) {
        return Util.configEnabled(Util.name((ItemLike)item));
    }

    public static boolean enabled(Item item) {
        boolean bl;
        if (item instanceof IConfigured) {
            IConfigured conf = (IConfigured)item;
            bl = conf.enabled();
        } else {
            bl = Util.configEnabled(item);
        }
        return bl;
    }

    public static boolean enabled(Supplier<Item> item) {
        return Util.enabled(item.get());
    }

    public static boolean enabled(String item) {
        return DelightfulItems.ITEMS.getEntries().stream().filter(reg -> reg.getId().m_135815_().equals(item)).map(Util::enabled).findAny().orElse(Util.configEnabled(item));
    }

    public static MutableComponent translation(String modid, String key) {
        return Component.m_237115_((String)(modid + "." + key));
    }

    public static MutableComponent translation(String modid, String prefix, String key) {
        return Component.m_237115_((String)(prefix + "." + modid + "." + key));
    }

    public static MutableComponent description(String key) {
        return Component.m_237115_((String)("desc.delightful." + key));
    }

    public static MutableComponent tooltip(String key) {
        return Component.m_237115_((String)("tooltip.delightful." + key));
    }
}

