/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.client;

import electrodynamics.client.event.guipost.HandlerArmorData;
import electrodynamics.client.event.guipost.HandlerRailgunTemperature;
import electrodynamics.client.event.levelstage.HandlerMarkerLines;
import electrodynamics.client.event.levelstage.HandlerQuarryArm;
import electrodynamics.client.event.levelstage.HandlerSeismicScanner;
import electrodynamics.client.keys.event.HandlerModeSwitchJetpack;
import electrodynamics.client.keys.event.HandlerModeSwitchServoLegs;
import electrodynamics.client.keys.event.HandlerSwapBattery;
import electrodynamics.client.keys.event.HandlerToggleNVGoggles;
import electrodynamics.client.keys.event.HandlerToggleServoLegs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import voltaic.client.event.AbstractKeyPressHandler;
import voltaic.client.event.AbstractLevelStageHandler;
import voltaic.client.event.AbstractPostGuiOverlayHandler;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ElectrodynamicsClientEvents {
    private static final List<AbstractKeyPressHandler> KEY_PRESS_HANDLERS = new ArrayList<AbstractKeyPressHandler>();
    private static final List<AbstractLevelStageHandler> LEVEL_STAGE_RENDER_HANDLERS = new ArrayList<AbstractLevelStageHandler>();
    private static final List<AbstractPostGuiOverlayHandler> POST_GUI_OVERLAY_HANDLERS = new ArrayList<AbstractPostGuiOverlayHandler>();

    public static void init() {
        KEY_PRESS_HANDLERS.add(new HandlerToggleNVGoggles());
        KEY_PRESS_HANDLERS.add(new HandlerToggleServoLegs());
        KEY_PRESS_HANDLERS.add(new HandlerModeSwitchServoLegs());
        KEY_PRESS_HANDLERS.add(new HandlerModeSwitchJetpack());
        KEY_PRESS_HANDLERS.add(new HandlerSwapBattery());
        LEVEL_STAGE_RENDER_HANDLERS.add(HandlerQuarryArm.INSTANCE);
        LEVEL_STAGE_RENDER_HANDLERS.add(HandlerMarkerLines.INSTANCE);
        LEVEL_STAGE_RENDER_HANDLERS.add(HandlerSeismicScanner.INSTANCE);
        POST_GUI_OVERLAY_HANDLERS.add(new HandlerRailgunTemperature());
        POST_GUI_OVERLAY_HANDLERS.add(new HandlerArmorData());
    }

    @SubscribeEvent
    public static void handlerGuiOverlays(RenderGuiOverlayEvent.Post event) {
        POST_GUI_OVERLAY_HANDLERS.forEach(handler -> handler.renderToScreen(event.getOverlay(), event.getGuiGraphics(), event.getWindow(), Minecraft.m_91087_(), event.getPartialTick()));
    }

    @SubscribeEvent
    public static void handleRenderEvents(RenderLevelStageEvent event) {
        LEVEL_STAGE_RENDER_HANDLERS.forEach(handler -> {
            if (handler.shouldRender(event.getStage())) {
                handler.render(event.getCamera(), event.getFrustum(), event.getLevelRenderer(), event.getPoseStack(), event.getProjectionMatrix(), Minecraft.m_91087_(), event.getRenderTick(), event.getPartialTick());
            }
        });
    }

    @SubscribeEvent
    public static void wipeRenderHashes(ClientPlayerNetworkEvent.LoggingOut event) {
        LocalPlayer player = event.getPlayer();
        if (player != null) {
            LEVEL_STAGE_RENDER_HANDLERS.forEach(AbstractLevelStageHandler::clear);
        }
    }

    @SubscribeEvent
    public static void handleKeyPress(InputEvent.Key event) {
        KEY_PRESS_HANDLERS.forEach(handler -> handler.handler(event, Minecraft.m_91087_()));
    }
}

