/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.item.gear.armor.types;

import electrodynamics.client.ElectrodynamicsClientRegister;
import electrodynamics.client.model.armor.ModelNightVisionGoggles;
import electrodynamics.common.item.gear.armor.ICustomArmor;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import electrodynamics.registers.ElectrodynamicsItems;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.item.IItemElectric;
import voltaic.common.item.gear.ItemVoltaicArmor;
import voltaic.prefab.item.ElectricItemProperties;
import voltaic.prefab.utilities.VoltaicTextUtils;

public class ItemNightVisionGoggles
extends ItemVoltaicArmor
implements IItemElectric {
    private final ElectricItemProperties properties;
    public static final int JOULES_PER_TICK = 5;
    public static final int DURATION_SECONDS = 12;
    private static final String ARMOR_TEXTURE_OFF = "electrodynamics:textures/model/armor/nightvisiongogglesoff.png";
    private static final String ARMOR_TEXTURE_ON = "electrodynamics:textures/model/armor/nightvisiongoggleson.png";

    public ItemNightVisionGoggles(ElectricItemProperties properties, Supplier<CreativeModeTab> creativeTab) {
        super((ArmorMaterial)NightVisionGoggles.NVGS, ArmorItem.Type.HELMET, (Item.Properties)properties, creativeTab);
        this.properties = properties;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entity, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> properties) {
                ModelNightVisionGoggles model = new ModelNightVisionGoggles(ElectrodynamicsClientRegister.NIGHT_VISION_GOGGLES.m_171564_());
                model.f_102817_ = properties.f_102817_;
                model.f_102609_ = properties.f_102609_;
                model.f_102610_ = properties.f_102610_;
                return model;
            }
        });
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        super.onArmorTick(stack, world, player);
        ItemNightVisionGoggles.armorTick(stack, world, player);
    }

    protected static void armorTick(ItemStack stack, Level world, Player player) {
        if (!world.f_46443_) {
            IItemElectric nvgs = (IItemElectric)stack.m_41720_();
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128471_("on") && nvgs.getJoulesStored(stack) >= 5.0) {
                nvgs.extractPower(stack, 5.0, false);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 240, 0, false, false, false));
            }
        }
    }

    public ElectricItemProperties getElectricProperties() {
        return this.properties;
    }

    public boolean m_8120_(ItemStack p_41456_) {
        return false;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean m_41465_() {
        return false;
    }

    public int m_142158_(ItemStack stack) {
        return (int)Math.round(13.0 * this.getJoulesStored(stack) / this.getMaximumCapacity(stack));
    }

    public boolean m_142522_(ItemStack stack) {
        return this.getJoulesStored(stack) < this.getMaximumCapacity(stack);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, world, tooltip, flagIn);
        tooltip.add((Component)ElectroTextUtils.tooltip("item.electric.info", VoltaicTextUtils.ratio((Component)ChatFormatter.getChatDisplayShort((double)this.getJoulesStored(stack), (IDisplayUnit)DisplayUnits.JOULES), (Component)ChatFormatter.getChatDisplayShort((double)this.getMaximumCapacity(stack), (IDisplayUnit)DisplayUnits.JOULES)).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)ElectroTextUtils.tooltip("item.electric.voltage", ChatFormatter.getChatDisplayShort((double)this.properties.receive.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        IItemElectric.addBatteryTooltip((ItemStack)stack, (Level)world, tooltip);
        if (stack.m_41782_() && stack.m_41783_().m_128471_("on")) {
            tooltip.add((Component)ElectroTextUtils.tooltip("nightvisiongoggles.status", new Object[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)ElectroTextUtils.tooltip("nightvisiongoggles.on", new Object[0]).m_130940_(ChatFormatting.GREEN)));
        } else {
            tooltip.add((Component)ElectroTextUtils.tooltip("nightvisiongoggles.status", new Object[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)ElectroTextUtils.tooltip("nightvisiongoggles.off", new Object[0]).m_130940_(ChatFormatting.RED)));
        }
    }

    public void addCreativeModeItems(CreativeModeTab group, List<ItemStack> items) {
        ItemStack empty = new ItemStack((ItemLike)this);
        IItemElectric.setEnergyStored((ItemStack)empty, (double)0.0);
        items.add(empty);
        ItemStack charged = new ItemStack((ItemLike)this);
        IItemElectric.setEnergyStored((ItemStack)charged, (double)this.getMaximumCapacity(charged));
        items.add(charged);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_(newStack.m_41720_());
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        boolean isOn;
        boolean bl = isOn = stack.m_41782_() && stack.m_41783_().m_128471_("on");
        if (isOn) {
            return ARMOR_TEXTURE_ON;
        }
        return ARMOR_TEXTURE_OFF;
    }

    public Item getDefaultStorageBattery() {
        return (Item)ElectrodynamicsItems.ITEM_BATTERY.get();
    }

    public boolean m_142305_(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (!IItemElectric.overrideOtherStackedOnMe((ItemStack)stack, (ItemStack)other, (Slot)slot, (ClickAction)action, (Player)player, (SlotAccess)access)) {
            return super.m_142305_(stack, other, slot, action, player, access);
        }
        return true;
    }

    public static enum NightVisionGoggles implements ICustomArmor
    {
        NVGS;


        public SoundEvent m_7344_() {
            return SoundEvents.f_11677_;
        }

        public String m_6082_() {
            return "electrodynamics:nvgs";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }

        public int m_266425_(ArmorItem.Type pType) {
            return 100;
        }

        public int m_7366_(ArmorItem.Type pType) {
            return 1;
        }
    }
}

