/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.item.gear.tools.electric;

import electrodynamics.prefab.utilities.ElectroTextUtils;
import electrodynamics.registers.ElectrodynamicsItems;
import electrodynamics.registers.ElectrodynamicsSounds;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import voltaic.api.creativetab.CreativeTabSupplier;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.item.IItemElectric;
import voltaic.prefab.item.ElectricItemProperties;
import voltaic.prefab.utilities.VoltaicTextUtils;

public class ItemMechanizedCrossbow
extends ProjectileWeaponItem
implements IItemElectric,
CreativeTabSupplier {
    private final ElectricItemProperties properties;
    private final Supplier<CreativeModeTab> creativeTab;
    public static final int JOULES_PER_SHOT = 5000;
    public static final int NUMBER_OF_SHOTS = 200;
    public static final int PROJECTILE_RANGE = 20;
    public static final int PROJECTILE_SPEED = 3;

    public ItemMechanizedCrossbow(ElectricItemProperties properties, Supplier<CreativeModeTab> creativeTab) {
        super((Item.Properties)properties);
        this.properties = properties;
        this.creativeTab = creativeTab;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack crossbow = player.m_21120_(hand);
        if (world.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)crossbow);
        }
        ItemMechanizedCrossbow mechanized = (ItemMechanizedCrossbow)crossbow.m_41720_();
        if (mechanized.getJoulesStored(crossbow) < 5000.0) {
            world.m_5594_(null, player.m_20183_(), (SoundEvent)ElectrodynamicsSounds.SOUND_RAILGUNKINETIC_NOAMMO.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResultHolder.m_19098_((Object)crossbow);
        }
        ItemStack arrow = this.getAmmo(player);
        AbstractArrow projectile = ItemMechanizedCrossbow.getArrow(world, (LivingEntity)player, crossbow, arrow);
        if (arrow.m_41619_()) {
            world.m_5594_(null, player.m_20183_(), (SoundEvent)ElectrodynamicsSounds.SOUND_RAILGUNKINETIC_NOAMMO.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResultHolder.m_19098_((Object)crossbow);
        }
        mechanized.extractPower(crossbow, 5000.0, false);
        if (!player.m_7500_()) {
            arrow.m_41774_(1);
        }
        Vec3 playerUpVector = player.m_20289_(1.0f);
        Quaternionf quaternionf = new Quaternionf().setAngleAxis(0.0, playerUpVector.f_82479_, playerUpVector.f_82480_, playerUpVector.f_82481_);
        Vec3 playerViewVector = player.m_20252_(1.0f);
        Vector3f viewVector = playerViewVector.m_252839_().rotate((Quaternionfc)quaternionf);
        projectile.m_6686_((double)viewVector.x(), (double)viewVector.y(), (double)viewVector.z(), 3.0f, 1.0f);
        world.m_7967_((Entity)projectile);
        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, 1.0f);
        return InteractionResultHolder.m_19098_((Object)crossbow);
    }

    public boolean m_41465_() {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    private static AbstractArrow getArrow(Level world, LivingEntity entity, ItemStack crossbow, ItemStack ammo) {
        ArrowItem arrowitem = (ArrowItem)(ammo.m_41720_() instanceof ArrowItem ? ammo.m_41720_() : Items.f_42412_);
        AbstractArrow abstractarrow = arrowitem.m_6394_(world, ammo, entity);
        if (entity instanceof Player) {
            abstractarrow.m_36762_(true);
        }
        abstractarrow.m_36740_(SoundEvents.f_11840_);
        abstractarrow.m_36793_(true);
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)crossbow);
        if (i > 0) {
            abstractarrow.m_36767_((byte)i);
        }
        return abstractarrow;
    }

    private ItemStack getAmmo(Player player) {
        Inventory playerInv = player.m_150109_();
        for (ItemStack stack : playerInv.f_35974_) {
            if (!this.m_6437_().test(stack)) continue;
            return stack;
        }
        if (player.m_7500_()) {
            return new ItemStack((ItemLike)Items.f_42412_);
        }
        return ItemStack.f_41583_;
    }

    public void addCreativeModeItems(CreativeModeTab group, List<ItemStack> items) {
        ItemStack empty = new ItemStack((ItemLike)this);
        IItemElectric.setEnergyStored((ItemStack)empty, (double)0.0);
        items.add(empty);
        ItemStack charged = new ItemStack((ItemLike)this);
        IItemElectric.setEnergyStored((ItemStack)charged, (double)this.getMaximumCapacity(charged));
        items.add(charged);
    }

    public int m_142158_(ItemStack stack) {
        return (int)Math.round(13.0 * this.getJoulesStored(stack) / this.getMaximumCapacity(stack));
    }

    public boolean m_142522_(ItemStack stack) {
        return this.getJoulesStored(stack) < this.getMaximumCapacity(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_(newStack.m_41720_());
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)ElectroTextUtils.tooltip("item.electric.info", VoltaicTextUtils.ratio((Component)ChatFormatter.getChatDisplayShort((double)this.getJoulesStored(stack), (IDisplayUnit)DisplayUnits.JOULES), (Component)ChatFormatter.getChatDisplayShort((double)this.getMaximumCapacity(stack), (IDisplayUnit)DisplayUnits.JOULES)).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)ElectroTextUtils.tooltip("item.electric.voltage", ChatFormatter.getChatDisplayShort((double)this.properties.receive.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        IItemElectric.addBatteryTooltip((ItemStack)stack, (Level)worldIn, tooltip);
    }

    public ElectricItemProperties getElectricProperties() {
        return this.properties;
    }

    public Predicate<ItemStack> m_6437_() {
        return f_43005_;
    }

    public int m_6615_() {
        return 20;
    }

    public Item getDefaultStorageBattery() {
        return (Item)ElectrodynamicsItems.ITEM_BATTERY.get();
    }

    public boolean m_142305_(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (!IItemElectric.overrideOtherStackedOnMe((ItemStack)stack, (ItemStack)other, (Slot)slot, (ClickAction)action, (Player)player, (SlotAccess)access)) {
            return super.m_142305_(stack, other, slot, action, player, access);
        }
        return true;
    }

    public boolean isAllowedInCreativeTab(CreativeModeTab tab) {
        return this.creativeTab.get() == tab;
    }

    public boolean hasCreativeTab() {
        return this.creativeTab != null;
    }
}

